/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;

public class InternalTestDiscoveryListener
implements TestListener,
Closeable {
    private final String myModuleName;
    private final String myTracesDirectory;
    private final List<String> myCompletedMethodNames = new ArrayList<String>();
    private Object myDiscoveryIndex;
    private Class<?> myDiscoveryIndexClass;

    public InternalTestDiscoveryListener() {
        this.myTracesDirectory = System.getProperty("org.jetbrains.instrumentation.trace.dir");
        this.myModuleName = System.getProperty("org.jetbrains.instrumentation.main.module");
        System.out.println(this.getClass().getSimpleName() + " instantiated with module='" + this.myModuleName + "' , directory='" + this.myTracesDirectory + "'");
    }

    private Object getIndex() {
        if (this.myDiscoveryIndex == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            try {
                this.myDiscoveryIndexClass = Class.forName("com.intellij.execution.testDiscovery.TestDiscoveryIndex");
                this.myDiscoveryIndex = this.myDiscoveryIndexClass.getConstructor(Project.class, String.class).newInstance(project2, this.myTracesDirectory);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
        return this.myDiscoveryIndex;
    }

    public void addError(Test test, Throwable t2) {
    }

    public void addFailure(Test test, AssertionFailedError t2) {
    }

    public void endTest(Test test) {
        String className = InternalTestDiscoveryListener.getClassName(test);
        String methodName = InternalTestDiscoveryListener.getMethodName(test);
        try {
            Object data = this.getData();
            Method testEnded = data.getClass().getMethod("testDiscoveryEnded", String.class);
            testEnded.invoke(data, "j" + className + "-" + methodName);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        this.myCompletedMethodNames.add("j" + className + "." + methodName);
        if (this.myCompletedMethodNames.size() > 50) {
            String[] fullTestNames = ArrayUtil.toStringArray(this.myCompletedMethodNames);
            this.myCompletedMethodNames.clear();
            AppExecutorUtil.getAppExecutorService().execute(() -> this.flushCurrentTraces(fullTestNames));
        }
    }

    protected void flushCurrentTraces(String[] fullTestNames) {
        System.out.println("Start compacting to index");
        try {
            Object index = this.getIndex();
            Method method2 = Class.forName("com.intellij.execution.testDiscovery.TestDiscoveryExtension").getMethod("processAvailableTraces", fullTestNames.getClass(), this.myTracesDirectory.getClass(), String.class, String.class, this.myDiscoveryIndexClass);
            method2.invoke(null, fullTestNames, this.myTracesDirectory, this.myModuleName, "j", index);
            System.out.println("Compacting done.");
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    private static String getMethodName(Test test) {
        String toString = test.toString();
        int braceIdx = toString.indexOf("(");
        return braceIdx > 0 ? toString.substring(0, braceIdx) : toString;
    }

    private static String getClassName(Test test) {
        String toString = test.toString();
        int braceIdx = toString.indexOf("(");
        return braceIdx > 0 && toString.endsWith(")") ? toString.substring(braceIdx + 1, toString.length() - 1) : null;
    }

    public void startTest(Test test) {
        try {
            Object data = this.getData();
            Method testStarted = data.getClass().getMethod("testDiscoveryStarted", String.class);
            testStarted.invoke(data, InternalTestDiscoveryListener.getClassName(test) + "-" + InternalTestDiscoveryListener.getMethodName(test));
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    protected Object getData() throws Exception {
        return Class.forName("com.intellij.rt.coverage.data.ProjectData").getMethod("getProjectData", new Class[0]).invoke(null, new Object[0]);
    }

    @Override
    public void close() throws IOException {
        String[] fullTestNames = ArrayUtil.toStringArray(this.myCompletedMethodNames);
        this.myCompletedMethodNames.clear();
        this.flushCurrentTraces(fullTestNames);
        InternalTestDiscoveryListener.zipOutput(this.myTracesDirectory);
    }

    private static void zipOutput(String tracesDirectory) {
        File[] files2 = new File(tracesDirectory).listFiles();
        if (files2 == null) {
            System.out.println("No traces found.");
            return;
        }
        System.out.println("Preparing zip.");
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(tracesDirectory + File.separator + "out.zip"));){
            for (File file2 : files2) {
                ZipUtil.addFileToZip((ZipOutputStream)zipOutputStream, (File)file2, (String)("/" + file2.getName()), null, null);
            }
            System.out.println("Zip prepared.");
            for (File file2 : files2) {
                FileUtil.delete((File)file2);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

