/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public abstract class TestClassesFilter {
    public static final TestClassesFilter ALL_CLASSES = new TestClassesFilter(){

        @Override
        public boolean matches(String className, String moduleName) {
            return true;
        }
    };

    public abstract boolean matches(String var1, String var2);

    protected static ArrayList<Pattern> compilePatterns(Collection<String> filterList) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String aFilter : filterList) {
            String filter2 = aFilter.trim();
            if (filter2.length() == 0) continue;
            filter2 = filter2.replaceAll("\\*", ".\\*");
            Pattern pattern = Pattern.compile(filter2);
            patterns.add(pattern);
        }
        return patterns;
    }

    protected static boolean matchesAnyPattern(Collection<Pattern> patterns, String className) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }
}

