/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.GeneralCodeStyleOptionsProvider;
import com.intellij.application.options.GeneralCodeStyleOptionsProviderEP;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.GradientViewport;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralCodeStylePanel
extends CodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.GeneralCodeStylePanel");
    private static final String SYSTEM_DEPENDANT_STRING = ApplicationBundle.message((String)"combobox.crlf.system.dependent", (Object[])new Object[0]);
    private static final String UNIX_STRING = ApplicationBundle.message((String)"combobox.crlf.unix", (Object[])new Object[0]);
    private static final String WINDOWS_STRING = ApplicationBundle.message((String)"combobox.crlf.windows", (Object[])new Object[0]);
    private static final String MACINTOSH_STRING = ApplicationBundle.message((String)"combobox.crlf.mac", (Object[])new Object[0]);
    private final List<GeneralCodeStyleOptionsProvider> myAdditionalOptions;
    private JTextField myRightMarginField;
    private int myDefaultRightMargin;
    private Color myInitialRightMarginFieldColor;
    private JComboBox myLineSeparatorCombo;
    private JPanel myPanel;
    private JCheckBox myCbWrapWhenTypingReachesRightMargin;
    private JCheckBox myEnableFormatterTags;
    private JTextField myFormatterOnTagField;
    private JTextField myFormatterOffTagField;
    private JCheckBox myAcceptRegularExpressionsCheckBox;
    private JPanel myMarkersPanel;
    private JBLabel myFormatterOffLabel;
    private JBLabel myFormatterOnLabel;
    private JPanel myMarkerOptionsPanel;
    private JPanel myAdditionalSettingsPanel;
    private JCheckBox myAutodetectIndentsBox;
    private JCheckBox myShowDetectedIndentNotification;
    private JPanel myDefaultOptionsPanel;
    private JPanel myIndentsDetectionPanel;
    private final JScrollPane myScrollPane;

    public GeneralCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.myLineSeparatorCombo.addItem(SYSTEM_DEPENDANT_STRING);
        this.myLineSeparatorCombo.addItem(UNIX_STRING);
        this.myLineSeparatorCombo.addItem(WINDOWS_STRING);
        this.myLineSeparatorCombo.addItem(MACINTOSH_STRING);
        this.addPanelToWatch(this.myPanel);
        this.myDefaultRightMargin = settings.getDefaultRightMargin();
        this.myRightMarginField.setHorizontalAlignment(4);
        this.myInitialRightMarginFieldColor = this.myRightMarginField.getBackground();
        this.myEnableFormatterTags.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                boolean tagsEnabled = GeneralCodeStylePanel.this.myEnableFormatterTags.isSelected();
                GeneralCodeStylePanel.this.setFormatterTagControlsEnabled(tagsEnabled);
            }
        });
        this.myAutodetectIndentsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                boolean isDetectIndent = GeneralCodeStylePanel.this.myAutodetectIndentsBox.isSelected();
                GeneralCodeStylePanel.this.myShowDetectedIndentNotification.setEnabled(isDetectIndent);
            }
        });
        this.myDefaultOptionsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.default.options", (Object[])new Object[0])));
        this.myIndentsDetectionPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.indents.detection", (Object[])new Object[0])));
        this.myMarkersPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.title", (Object[])new Object[0]), (boolean)true));
        this.myMarkerOptionsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.options.title", (Object[])new Object[0]), (boolean)true));
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)10));
        this.myScrollPane = ScrollPaneFactory.createScrollPane(null, (boolean)true);
        this.myScrollPane.setViewport((JViewport)((Object)new GradientViewport(this.myPanel, (Insets)JBUI.insetsTop((int)5), true)));
        this.myAdditionalSettingsPanel.setLayout((LayoutManager)new VerticalFlowLayout(true, true));
        this.myAdditionalSettingsPanel.removeAll();
        this.myAdditionalOptions = ConfigurableWrapper.createConfigurables(GeneralCodeStyleOptionsProviderEP.EP_NAME);
        for (GeneralCodeStyleOptionsProvider provider : this.myAdditionalOptions) {
            JComponent generalSettingsComponent = provider.createComponent();
            if (generalSettingsComponent == null) continue;
            this.myAdditionalSettingsPanel.add(generalSettingsComponent);
        }
    }

    @Override
    protected void somethingChanged() {
        super.somethingChanged();
    }

    @Override
    protected int getRightMargin() {
        int rightMargin;
        String text2 = this.myRightMarginField.getText();
        this.myRightMarginField.setBackground(this.myInitialRightMarginFieldColor);
        try {
            rightMargin = Integer.parseInt(text2);
            if (rightMargin < 1 || rightMargin > 1000) {
                rightMargin = this.myDefaultRightMargin;
                this.myRightMarginField.setBackground(LightColors.RED);
            }
        }
        catch (NumberFormatException nfe) {
            this.myRightMarginField.setBackground(LightColors.RED);
            rightMargin = this.myDefaultRightMargin;
        }
        return rightMargin;
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = FileTypes.PLAIN_TEXT;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/GeneralCodeStylePanel", "getFileType"));
        }
        return languageFileType;
    }

    @Override
    protected String getPreviewText() {
        return null;
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        settings.LINE_SEPARATOR = this.getSelectedLineSeparator();
        settings.setDefaultRightMargin(this.getRightMargin());
        settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN = this.myCbWrapWhenTypingReachesRightMargin.isSelected();
        settings.FORMATTER_TAGS_ENABLED = this.myEnableFormatterTags.isSelected();
        settings.FORMATTER_TAGS_ACCEPT_REGEXP = this.myAcceptRegularExpressionsCheckBox.isSelected();
        settings.FORMATTER_OFF_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG);
        settings.setFormatterOffPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOffTagField, settings.FORMATTER_OFF_TAG));
        settings.FORMATTER_ON_TAG = GeneralCodeStylePanel.getTagText(this.myFormatterOnTagField, settings.FORMATTER_ON_TAG);
        settings.setFormatterOnPattern(GeneralCodeStylePanel.compilePattern(settings, this.myFormatterOnTagField, settings.FORMATTER_ON_TAG));
        settings.AUTODETECT_INDENTS = this.myAutodetectIndentsBox.isSelected();
        if (this.myShowDetectedIndentNotification.isEnabled()) {
            FileIndentOptionsProvider.setShowNotification((boolean)this.myShowDetectedIndentNotification.isSelected());
        }
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            option.apply(settings);
        }
    }

    @Nullable
    private static Pattern compilePattern(CodeStyleSettings settings, JTextField field, String patternText) {
        try {
            return Pattern.compile(patternText);
        }
        catch (PatternSyntaxException pse) {
            settings.FORMATTER_TAGS_ACCEPT_REGEXP = false;
            GeneralCodeStylePanel.showError(field, ApplicationBundle.message((String)"settings.code.style.general.formatter.marker.invalid.regexp", (Object[])new Object[0]));
            return null;
        }
    }

    private static String getTagText(JTextField field, String defaultValue) {
        String fieldText = field.getText();
        if (StringUtil.isEmpty((String)field.getText())) {
            return defaultValue;
        }
        return fieldText;
    }

    @Nullable
    private String getSelectedLineSeparator() {
        if (UNIX_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\n";
        }
        if (MACINTOSH_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r";
        }
        if (WINDOWS_STRING.equals(this.myLineSeparatorCombo.getSelectedItem())) {
            return "\r\n";
        }
        return null;
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        if (!Comparing.equal((String)this.getSelectedLineSeparator(), (String)settings.LINE_SEPARATOR)) {
            return true;
        }
        if (settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN ^ this.myCbWrapWhenTypingReachesRightMargin.isSelected()) {
            return true;
        }
        if (this.getRightMargin() != settings.getDefaultRightMargin()) {
            return true;
        }
        if (this.myEnableFormatterTags.isSelected() ? !settings.FORMATTER_TAGS_ENABLED || settings.FORMATTER_TAGS_ACCEPT_REGEXP != this.myAcceptRegularExpressionsCheckBox.isSelected() || !StringUtil.equals((CharSequence)this.myFormatterOffTagField.getText(), (CharSequence)settings.FORMATTER_OFF_TAG) || !StringUtil.equals((CharSequence)this.myFormatterOnTagField.getText(), (CharSequence)settings.FORMATTER_ON_TAG) : settings.FORMATTER_TAGS_ENABLED) {
            return true;
        }
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            if (!option.isModified(settings)) continue;
            return true;
        }
        if (settings.AUTODETECT_INDENTS != this.myAutodetectIndentsBox.isSelected()) {
            return true;
        }
        return this.myShowDetectedIndentNotification.isEnabled() && FileIndentOptionsProvider.isShowNotification() != this.myShowDetectedIndentNotification.isSelected();
    }

    @Override
    public JComponent getPanel() {
        return this.myScrollPane;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        String lineSeparator = settings.LINE_SEPARATOR;
        if ("\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(UNIX_STRING);
        } else if ("\r\n".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(WINDOWS_STRING);
        } else if ("\r".equals(lineSeparator)) {
            this.myLineSeparatorCombo.setSelectedItem(MACINTOSH_STRING);
        } else {
            this.myLineSeparatorCombo.setSelectedItem(SYSTEM_DEPENDANT_STRING);
        }
        this.myRightMarginField.setText(String.valueOf(settings.getDefaultRightMargin()));
        this.myCbWrapWhenTypingReachesRightMargin.setSelected(settings.WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN);
        this.myAcceptRegularExpressionsCheckBox.setSelected(settings.FORMATTER_TAGS_ACCEPT_REGEXP);
        this.myEnableFormatterTags.setSelected(settings.FORMATTER_TAGS_ENABLED);
        this.myFormatterOnTagField.setText(settings.FORMATTER_ON_TAG);
        this.myFormatterOffTagField.setText(settings.FORMATTER_OFF_TAG);
        this.setFormatterTagControlsEnabled(settings.FORMATTER_TAGS_ENABLED);
        this.myAutodetectIndentsBox.setSelected(settings.AUTODETECT_INDENTS);
        this.myShowDetectedIndentNotification.setEnabled(this.myAutodetectIndentsBox.isSelected());
        this.myShowDetectedIndentNotification.setSelected(FileIndentOptionsProvider.isShowNotification());
        for (GeneralCodeStyleOptionsProvider option : this.myAdditionalOptions) {
            option.reset(settings);
        }
    }

    private void setFormatterTagControlsEnabled(boolean isEnabled) {
        this.myFormatterOffTagField.setEnabled(isEnabled);
        this.myFormatterOnTagField.setEnabled(isEnabled);
        this.myMarkersPanel.setEnabled(isEnabled);
        this.myAcceptRegularExpressionsCheckBox.setEnabled(isEnabled);
        this.myFormatterOffLabel.setEnabled(isEnabled);
        this.myFormatterOnLabel.setEnabled(isEnabled);
        this.myMarkerOptionsPanel.setEnabled(isEnabled);
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getFileType(), scheme2, null);
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
    }

    @Override
    public Language getDefaultLanguage() {
        return null;
    }

    private static void showError(JTextField field, String message2) {
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, MessageType.ERROR.getDefaultIcon(), MessageType.ERROR.getPopupBackground(), null);
        balloonBuilder.setFadeoutTime(1500L);
        Balloon balloon = balloonBuilder.createBalloon();
        Rectangle rect = field.getBounds();
        Point p2 = new Point(0, rect.height);
        RelativePoint point = new RelativePoint((Component)field, p2);
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)ProjectManager.getInstance().getDefaultProject(), (Disposable)balloon);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JTextField jTextField;
        JCheckBox jCheckBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        JCheckBox jCheckBox4;
        JPanel jPanel4;
        JTextField jTextField2;
        JTextField jTextField3;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel5;
        JCheckBox jCheckBox5;
        JComboBox jComboBox;
        JPanel jPanel6;
        this.myPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, "West");
        this.myLineSeparatorCombo = jComboBox = new JComboBox();
        jPanel7.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.line.separator.for.new.files"));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel8, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.control"), (int)0, (int)0, null, null));
        this.myEnableFormatterTags = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.enable.formatter.tags"));
        jPanel8.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMarkersPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel5, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Markers:", 0, 0, null, null));
        this.myFormatterOffLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.off.tag"));
        jPanel5.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFormatterOnLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.on.tag"));
        jPanel5.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFormatterOnTagField = jTextField3 = new JTextField();
        jPanel5.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFormatterOffTagField = jTextField2 = new JTextField();
        jPanel5.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMarkerOptionsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Font font = jPanel4.getFont();
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, new Font(font.getName(), font.getStyle(), font.getSize()), null));
        this.myAcceptRegularExpressionsCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.formatter.marker.regexp"));
        jPanel4.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel3, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDefaultOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.default.options"), 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.right.margin.columns"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCbWrapWhenTypingReachesRightMargin = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("wrapping.wrap.on.typing"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myRightMarginField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myIndentsDetectionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.indents.detection"), 0, 0, null, null));
        this.myAutodetectIndentsBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("settings.code.style.general.autodetect.indents"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowDetectedIndentNotification = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show notifications about detected indents");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, "Center");
        jLabel.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jTextField2);
        jBLabel.setLabelFor(jTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

