/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PathMacrosImpl", storages={@Storage(value="path.macros.xml", roamingType=RoamingType.PER_OS)})
public class PathMacrosImpl
extends PathMacros
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(PathMacrosImpl.class);
    private final Map<String, String> myLegacyMacros = new THashMap();
    private final Map<String, String> myMacros = new LinkedHashMap();
    private int myModificationStamp = 0;
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final List<String> myIgnoredMacros = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final String MACRO_ELEMENT = "macro";
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    @NonNls
    public static final String IGNORED_MACRO_ELEMENT = "ignoredMacro";
    private static final Set<String> SYSTEM_MACROS = new THashSet();
    @NonNls
    public static final String EXT_FILE_NAME = "path.macros";
    private static final Set<String> ourToolsMacros;

    public static PathMacrosImpl getInstanceEx() {
        return (PathMacrosImpl)PathMacrosImpl.getInstance();
    }

    public Set<String> getUserMacroNames() {
        this.myLock.readLock().lock();
        try {
            THashSet tHashSet = new THashSet(this.myMacros.keySet());
            return tHashSet;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public static Set<String> getToolMacroNames() {
        return ourToolsMacros;
    }

    public Set<String> getSystemMacroNames() {
        return SYSTEM_MACROS;
    }

    public Collection<String> getIgnoredMacroNames() {
        return this.myIgnoredMacros;
    }

    public void setIgnoredMacroNames(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/application/options/PathMacrosImpl", "setIgnoredMacroNames"));
        }
        this.myIgnoredMacros.clear();
        this.myIgnoredMacros.addAll(names);
    }

    public void addIgnoredMacro(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/application/options/PathMacrosImpl", "addIgnoredMacro"));
        }
        if (!this.myIgnoredMacros.contains(name)) {
            this.myIgnoredMacros.add(name);
        }
    }

    public int getModificationStamp() {
        this.myLock.readLock().lock();
        try {
            int n2 = this.myModificationStamp;
            return n2;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public boolean isIgnoredMacroName(@NotNull String macro2) {
        if (macro2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", MACRO_ELEMENT, "com/intellij/application/options/PathMacrosImpl", "isIgnoredMacroName"));
        }
        return this.myIgnoredMacros.contains(macro2);
    }

    public Set<String> getAllMacroNames() {
        return ContainerUtil.union(this.getUserMacroNames(), this.getSystemMacroNames());
    }

    public String getValue(String name) {
        try {
            this.myLock.readLock().lock();
            String string2 = this.myMacros.get(name);
            return string2;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public void removeAllMacros() {
        try {
            this.myLock.writeLock().lock();
            this.myMacros.clear();
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    public Collection<String> getLegacyMacroNames() {
        try {
            this.myLock.readLock().lock();
            THashSet tHashSet = new THashSet(this.myLegacyMacros.keySet());
            return tHashSet;
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    public void setMacro(@NotNull String name, @NotNull String value2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/application/options/PathMacrosImpl", "setMacro"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VALUE_ATTR, "com/intellij/application/options/PathMacrosImpl", "setMacro"));
        }
        if (StringUtil.isEmptyOrSpaces((String)value2)) {
            return;
        }
        try {
            this.myLock.writeLock().lock();
            this.myMacros.put(name, value2);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    public void addLegacyMacro(@NotNull String name, @NotNull String value2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTR, "com/intellij/application/options/PathMacrosImpl", "addLegacyMacro"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", VALUE_ATTR, "com/intellij/application/options/PathMacrosImpl", "addLegacyMacro"));
        }
        try {
            this.myLock.writeLock().lock();
            this.myLegacyMacros.put(name, value2);
            this.myMacros.remove(name);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    public void removeMacro(String name) {
        try {
            this.myLock.writeLock().lock();
            String value2 = this.myMacros.remove(name);
            LOG.assertTrue(value2 != null);
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element getState() {
        try {
            Element element = new Element("state");
            this.myLock.writeLock().lock();
            for (Map.Entry<String, String> entry : this.myMacros.entrySet()) {
                String value2 = entry.getValue();
                if (StringUtil.isEmptyOrSpaces((String)value2)) continue;
                Element macro2 = new Element(MACRO_ELEMENT);
                macro2.setAttribute(NAME_ATTR, entry.getKey());
                macro2.setAttribute(VALUE_ATTR, value2);
                element.addContent(macro2);
            }
            for (String macro3 : this.myIgnoredMacros) {
                Element macroElement = new Element(IGNORED_MACRO_ELEMENT);
                macroElement.setAttribute(NAME_ATTR, macro3);
                element.addContent(macroElement);
            }
            Iterator<Object> iterator2 = element;
            return iterator2;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(Element element) {
        try {
            this.myLock.writeLock().lock();
            for (Element macro2 : element.getChildren(MACRO_ELEMENT)) {
                String name = macro2.getAttributeValue(NAME_ATTR);
                String value2 = macro2.getAttributeValue(VALUE_ATTR);
                if (name == null || value2 == null || SYSTEM_MACROS.contains(name)) continue;
                if (value2.length() > 1 && value2.charAt(value2.length() - 1) == '/') {
                    value2 = value2.substring(0, value2.length() - 1);
                }
                this.myMacros.put(name, value2);
            }
            for (Element macroElement : element.getChildren(IGNORED_MACRO_ELEMENT)) {
                String ignoredName = macroElement.getAttributeValue(NAME_ATTR);
                if (StringUtil.isEmpty((String)ignoredName) || this.myIgnoredMacros.contains(ignoredName)) continue;
                this.myIgnoredMacros.add(ignoredName);
            }
        }
        finally {
            ++this.myModificationStamp;
            this.myLock.writeLock().unlock();
        }
    }

    public void addMacroReplacements(ReplacePathToMacroMap result2) {
        for (String name : this.getUserMacroNames()) {
            String value2 = this.getValue(name);
            if (StringUtil.isEmptyOrSpaces((String)value2)) continue;
            result2.addMacroReplacement(value2, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMacroExpands(ExpandMacroToPathMap result2) {
        for (String string2 : this.getUserMacroNames()) {
            String value2 = this.getValue(string2);
            if (StringUtil.isEmptyOrSpaces((String)value2)) continue;
            result2.addMacroExpand(string2, value2);
        }
        this.myLock.readLock().lock();
        try {
            for (Map.Entry entry : this.myLegacyMacros.entrySet()) {
                result2.addMacroExpand((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            this.myLock.readLock().unlock();
        }
    }

    static {
        SYSTEM_MACROS.add("APPLICATION_HOME_DIR");
        SYSTEM_MACROS.add("APPLICATION_PLUGINS_DIR");
        SYSTEM_MACROS.add("PROJECT_DIR");
        SYSTEM_MACROS.add("MODULE_DIR");
        SYSTEM_MACROS.add("USER_HOME");
        ourToolsMacros = ContainerUtil.immutableSet((Object[])new String[]{"ClasspathEntry", "Classpath", "ColumnNumber", "ContentRoot", "FileClass", "FileDir", "FileParentDir", "FileDirName", "FileDirPathFromParent", "FileDirRelativeToProjectRoot", "/FileDirRelativeToProjectRoot", "FileDirRelativeToSourcepath", "/FileDirRelativeToSourcepath", "FileExt", "FileFQPackage", "FileName", "FileNameWithoutExtension", "FileNameWithoutAllExtensions", "FilePackage", "FilePath", "UnixSeparators", "FilePathRelativeToProjectRoot", "/FilePathRelativeToProjectRoot", "FilePathRelativeToSourcepath", "/FilePathRelativeToSourcepath", "FilePrompt", "FileRelativeDir", "/FileRelativeDir", "FileRelativePath", "/FileRelativePath", "FileEncoding", "JavaDocPath", "JDKPath", "LineNumber", "ModuleFileDir", "ModuleFilePath", "ModuleName", "AffectedModuleNames", "IsMake", "ModuleSourcePath", "ModuleSdkPath", "OutputPath", "PhpExecutable", "ProjectFileDir", "ProjectFilePath", "ProjectName", "Projectpath", "Prompt", "SourcepathEntry", "Sourcepath", "SHOW_CHANGES", "ClipboardContent", "SelectedText", "SelectionStartLine", "SelectionEndLine", "SelectionStartColumn", "SelectionEndColumn", "PyInterpreterDirectory", "ExecutableByFileExt"});
    }
}

