/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.PathMacroExpandableProtocolBean;
import com.intellij.openapi.components.PathMacroMap;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePathToMacroMap
extends PathMacroMap {
    private List<String> myPathsIndex = null;
    private final Map<String, String> myMacroMap = ContainerUtilRt.newLinkedHashMap();
    @NonNls
    public static final String[] PROTOCOLS;

    public void addMacroReplacement(String path, String macroName) {
        this.addReplacement(FileUtil.toSystemIndependentName((String)path), "$" + macroName + "$", true);
    }

    public void addReplacement(String path, String macroExpr, boolean overwrite) {
        path = StringUtil.trimEnd((String)path, (String)"/");
        this.putIfAbsent(path, macroExpr, overwrite);
        for (String protocol2 : PROTOCOLS) {
            this.putIfAbsent(protocol2 + ":" + path, protocol2 + ":" + macroExpr, overwrite);
            this.putIfAbsent(protocol2 + ":/" + path, protocol2 + ":/" + macroExpr, overwrite);
            this.putIfAbsent(protocol2 + "://" + path, protocol2 + "://" + macroExpr, overwrite);
        }
    }

    private void putIfAbsent(String path, String substitution, boolean overwrite) {
        if (overwrite || !this.myMacroMap.containsKey(path)) {
            this.myMacroMap.put(path, substitution);
        }
    }

    @Override
    public String substitute(@Nullable String text2, boolean caseSensitive) {
        if (text2 == null) {
            return null;
        }
        for (String path : this.getPathIndex()) {
            text2 = this.replacePathMacro(text2, path, caseSensitive);
        }
        return text2;
    }

    private String replacePathMacro(@NotNull String text2, @NotNull String path, boolean caseSensitive) {
        boolean startsWith;
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/ReplacePathToMacroMap", "replacePathMacro"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/application/options/ReplacePathToMacroMap", "replacePathMacro"));
        }
        if (text2.length() < path.length() || path.isEmpty()) {
            return text2;
        }
        boolean bl = startsWith = caseSensitive ? text2.startsWith(path) : StringUtil.startsWithIgnoreCase((String)text2, (String)path);
        if (!startsWith) {
            return text2;
        }
        int endOfOccurrence = path.length();
        boolean isWindowsRoot = path.endsWith(":/");
        if (!isWindowsRoot && endOfOccurrence < text2.length() && text2.charAt(endOfOccurrence) != '/' && !text2.substring(endOfOccurrence).startsWith("!/")) {
            return text2;
        }
        return this.myMacroMap.get(path) + text2.substring(endOfOccurrence);
    }

    @Override
    @NotNull
    public String substituteRecursively(@NotNull String text2, boolean caseSensitive) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/ReplacePathToMacroMap", "substituteRecursively"));
        }
        for (String path : this.getPathIndex()) {
            text2 = this.replacePathMacroRecursively(text2, path, caseSensitive);
        }
        String string2 = text2;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/ReplacePathToMacroMap", "substituteRecursively"));
        }
        return string2;
    }

    private String replacePathMacroRecursively(@NotNull String text2, @NotNull String path, boolean caseSensitive) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/application/options/ReplacePathToMacroMap", "replacePathMacroRecursively"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/application/options/ReplacePathToMacroMap", "replacePathMacroRecursively"));
        }
        if (text2.length() < path.length()) {
            return text2;
        }
        if (path.isEmpty()) {
            return text2;
        }
        StringBuilder newText = new StringBuilder();
        boolean isWindowsRoot = path.endsWith(":/");
        int i2 = 0;
        while (i2 < text2.length()) {
            int occurrenceOfPath;
            int n2 = occurrenceOfPath = caseSensitive ? text2.indexOf(path, i2) : StringUtil.indexOfIgnoreCase((String)text2, (String)path, (int)i2);
            if (occurrenceOfPath >= 0) {
                char prev;
                int endOfOccurrence = occurrenceOfPath + path.length();
                if (!isWindowsRoot && endOfOccurrence < text2.length() && text2.charAt(endOfOccurrence) != '/' && text2.charAt(endOfOccurrence) != '\"' && text2.charAt(endOfOccurrence) != ' ' && !text2.substring(endOfOccurrence).startsWith("!/")) {
                    newText.append(text2.substring(i2, endOfOccurrence));
                    i2 = endOfOccurrence;
                    continue;
                }
                if (occurrenceOfPath > 0 && (Character.isLetterOrDigit(prev = text2.charAt(occurrenceOfPath - 1)) || prev == '_')) {
                    newText.append(text2.substring(i2, endOfOccurrence));
                    i2 = endOfOccurrence;
                    continue;
                }
            }
            if (occurrenceOfPath < 0) {
                if (newText.length() == 0) {
                    return text2;
                }
                newText.append(text2.substring(i2));
                break;
            }
            newText.append(text2.substring(i2, occurrenceOfPath));
            newText.append(this.myMacroMap.get(path));
            i2 = occurrenceOfPath + path.length();
        }
        return newText.toString();
    }

    private static int getIndex(@NotNull Map.Entry<String, String> s2) {
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/application/options/ReplacePathToMacroMap", "getIndex"));
        }
        String replacement = s2.getValue();
        if (replacement.contains("..")) {
            return 1;
        }
        if (replacement.contains("$USER_HOME$")) {
            return 1;
        }
        if (replacement.contains("$APPLICATION_HOME_DIR$")) {
            return 1;
        }
        if (replacement.contains("$MODULE_DIR$")) {
            return 3;
        }
        if (replacement.contains("$PROJECT_DIR$")) {
            return 3;
        }
        return 2;
    }

    private static int stripPrefix(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/application/options/ReplacePathToMacroMap", "stripPrefix"));
        }
        key = StringUtil.trimStart((String)key, (String)"jar:");
        key = StringUtil.trimStart((String)key, (String)"file:");
        while (key.startsWith("/")) {
            key = key.substring(1);
        }
        return key.length();
    }

    @NotNull
    public List<String> getPathIndex() {
        if (this.myPathsIndex == null || this.myPathsIndex.size() != this.myMacroMap.size()) {
            ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.myMacroMap.entrySet());
            TObjectIntHashMap weights = new TObjectIntHashMap();
            for (Map.Entry entry2 : entries) {
                weights.put((Object)entry2, ReplacePathToMacroMap.getIndex(entry2) * 512 + ReplacePathToMacroMap.stripPrefix((String)entry2.getKey()));
            }
            ContainerUtil.sort(entries, (o1, o2) -> weights.get(o2) - weights.get(o1));
            this.myPathsIndex = ContainerUtil.map2List(entries, entry -> (String)entry.getKey());
        }
        List<String> list2 = this.myPathsIndex;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/ReplacePathToMacroMap", "getPathIndex"));
        }
        return list2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplacePathToMacroMap)) {
            return false;
        }
        return this.myMacroMap.equals(((ReplacePathToMacroMap)obj).myMacroMap);
    }

    @Override
    public int hashCode() {
        return this.myMacroMap.hashCode();
    }

    public void put(String path, String replacement) {
        this.myMacroMap.put(path, replacement);
    }

    static {
        ArrayList<String> protocols = new ArrayList<String>();
        protocols.add("file");
        protocols.add("jar");
        if (Extensions.getRootArea().hasExtensionPoint(PathMacroExpandableProtocolBean.EP_NAME.getName())) {
            for (PathMacroExpandableProtocolBean bean : (PathMacroExpandableProtocolBean[])PathMacroExpandableProtocolBean.EP_NAME.getExtensions()) {
                protocols.add(bean.protocol);
            }
        }
        PROTOCOLS = ArrayUtil.toStringArray(protocols);
    }
}

