/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesUIConfiguration;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CodeStyleSchemesActions
extends AbstractSchemeActions<CodeStyleScheme> {
    private static final String SHARED_IMPORT_SOURCE = ApplicationBundle.message((String)"import.scheme.shared", (Object[])new Object[0]);

    protected CodeStyleSchemesActions(@NotNull AbstractSchemesPanel<CodeStyleScheme, ?> schemesPanel) {
        if (schemesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesPanel", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "<init>"));
        }
        super(schemesPanel);
    }

    @Override
    protected void resetScheme(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "resetScheme"));
        }
        if (Messages.showOkCancelDialog((String)ApplicationBundle.message((String)"settings.code.style.reset.to.defaults.message", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"settings.code.style.reset.to.defaults.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            scheme2.resetToDefaults();
            this.getModel().fireSchemeChanged(scheme2);
        }
    }

    @Override
    protected void duplicateScheme(@NotNull CodeStyleScheme scheme2, @NotNull String newName) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "duplicateScheme"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "duplicateScheme"));
        }
        if (!this.getModel().isProjectScheme(scheme2)) {
            CodeStyleScheme newScheme = this.getModel().createNewScheme(newName, (CodeStyleScheme)this.getCurrentScheme());
            this.getModel().addScheme(newScheme, true);
        }
    }

    @Override
    protected void importScheme(@NotNull String importerName) {
        if (importerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importerName", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "importScheme"));
        }
        CodeStyleScheme currentScheme = (CodeStyleScheme)this.getCurrentScheme();
        if (currentScheme != null) {
            this.chooseAndImport(currentScheme, importerName);
        }
    }

    @Override
    protected void copyToIDE(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "copyToIDE"));
        }
        String name = SchemeNameGenerator.getUniqueName(this.getProjectName(), schemeName -> this.getModel().containsScheme((String)schemeName, false));
        CodeStyleScheme newScheme = this.getModel().exportProjectScheme(name);
        this.getModel().setUsePerProjectSettings(false);
        this.getModel().selectScheme(newScheme, null);
        this.getSchemesPanel().startEdit();
    }

    @NotNull
    private String getProjectName() {
        Project project2 = ProjectUtil.guessCurrentProject(this.getSchemesPanel());
        String string2 = project2.getName();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "getProjectName"));
        }
        return string2;
    }

    private void chooseAndImport(@NotNull CodeStyleScheme currentScheme, @NotNull String importerName) {
        if (currentScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentScheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "chooseAndImport"));
        }
        if (importerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importerName", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "chooseAndImport"));
        }
        if (importerName.equals(SHARED_IMPORT_SOURCE)) {
            new SchemesToImportPopup<CodeStyleScheme>(this.getSchemesPanel()){

                @Override
                protected void onSchemeSelected(CodeStyleScheme scheme2) {
                    if (scheme2 != null) {
                        CodeStyleSchemesActions.this.getModel().addScheme(scheme2, true);
                    }
                }
            }.show(this.getModel().getSchemes());
        } else {
            SchemeImporter<CodeStyleScheme> importer = SchemeImporterEP.getImporter(importerName, CodeStyleScheme.class);
            if (importer == null) {
                return;
            }
            try {
                CodeStyleScheme scheme2 = this.importExternalCodeStyle(importer, currentScheme);
                if (scheme2 != null) {
                    String additionalImportInfo = StringUtil.notNullize((String)importer.getAdditionalImportInfo((Scheme)scheme2));
                    this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"message.code.style.scheme.import.success", (Object[])new Object[]{importerName, scheme2.getName(), additionalImportInfo}), MessageType.INFO);
                }
            }
            catch (SchemeImportException e2) {
                if (e2.isWarning()) {
                    this.getSchemesPanel().showStatus(e2.getMessage(), MessageType.WARNING);
                    return;
                }
                String message2 = ApplicationBundle.message((String)"message.code.style.scheme.import.failure", (Object[])new Object[]{importerName, e2.getMessage()});
                this.getSchemesPanel().showStatus(message2, MessageType.ERROR);
            }
        }
    }

    @Nullable
    private CodeStyleScheme importExternalCodeStyle(SchemeImporter<CodeStyleScheme> importer, @NotNull CodeStyleScheme currentScheme) throws SchemeImportException {
        if (currentScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentScheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "importExternalCodeStyle"));
        }
        VirtualFile selectedFile = SchemeImportUtil.selectImportSource(importer.getSourceExtensions(), this.getSchemesPanel(), CodeStyleSchemesUIConfiguration.Util.getRecentImportFile(), null);
        if (selectedFile != null) {
            CodeStyleSchemesUIConfiguration.Util.setRecentImportFile(selectedFile);
            SchemeCreator schemeCreator = new SchemeCreator();
            CodeStyleScheme schemeImported = (CodeStyleScheme)importer.importScheme(this.getModel().getProject(), selectedFile, (Scheme)currentScheme, (SchemeFactory)schemeCreator);
            if (schemeImported != null) {
                if (schemeCreator.isSchemeWasCreated()) {
                    this.getModel().fireSchemeListChanged();
                } else {
                    this.getModel().fireSchemeChanged(schemeImported);
                }
                return schemeImported;
            }
        }
        return null;
    }

    @Override
    protected Class<CodeStyleScheme> getSchemeType() {
        return CodeStyleScheme.class;
    }

    @Override
    public void copyToProject(@NotNull CodeStyleScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "copyToProject"));
        }
        int copyToProjectConfirmation = Messages.showYesNoDialog((String)ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project.message", (Object[])new Object[]{scheme2.getName()}), (String)ApplicationBundle.message((String)"settings.editor.scheme.copy.to.project.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (copyToProjectConfirmation == 0) {
            this.getModel().copyToProject(scheme2);
            this.getModel().setUsePerProjectSettings(true, true);
        }
    }

    @Override
    protected void exportScheme(@NotNull CodeStyleScheme scheme2, @NotNull String exporterName) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "exportScheme"));
        }
        if (exporterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporterName", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "exportScheme"));
        }
        SchemeExporter<CodeStyleScheme> exporter = SchemeExporterEP.getExporter(exporterName, CodeStyleScheme.class);
        if (exporter != null) {
            String ext = exporter.getExtension();
            FileSaverDialog saver = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.title", (Object[])new Object[0]), ApplicationBundle.message((String)"scheme.exporter.ui.file.chooser.message", (Object[])new Object[0]), new String[]{ext}), this.getSchemesPanel());
            VirtualFileWrapper target = saver.save(null, scheme2.getName() + "." + ext);
            if (target != null) {
                MessageType messageType;
                String message2;
                VirtualFile targetFile = target.getVirtualFile(true);
                if (targetFile != null) {
                    try {
                        WriteAction.run(() -> {
                            if (scheme2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "lambda$exportScheme$1"));
                            }
                            try (OutputStream outputStream = targetFile.getOutputStream((Object)this);){
                                exporter.exportScheme((Scheme)scheme2, outputStream);
                            }
                        });
                        message2 = ApplicationBundle.message((String)"scheme.exporter.ui.code.style.exported.message", (Object[])new Object[]{scheme2.getName(), targetFile.getPresentableUrl()});
                        messageType = MessageType.INFO;
                    }
                    catch (Exception e2) {
                        message2 = ApplicationBundle.message((String)"scheme.exporter.ui.export.failed", (Object[])new Object[]{e2.getMessage()});
                        messageType = MessageType.ERROR;
                    }
                } else {
                    message2 = ApplicationBundle.message((String)"scheme.exporter.ui.cannot.write.message", (Object[])new Object[0]);
                    messageType = MessageType.ERROR;
                }
                this.getSchemesPanel().showStatus(message2, messageType);
            }
        }
    }

    @NotNull
    protected CodeStyleSchemesModel getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = (CodeStyleSchemesModel)super.getModel();
        if (codeStyleSchemesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/CodeStyleSchemesActions", "getModel"));
        }
        return codeStyleSchemesModel;
    }

    private class SchemeCreator
    implements SchemeFactory<CodeStyleScheme> {
        private boolean mySchemeWasCreated;

        private SchemeCreator() {
        }

        public CodeStyleScheme createNewScheme(@Nullable String targetName) {
            this.mySchemeWasCreated = true;
            if (targetName == null) {
                targetName = ApplicationBundle.message((String)"code.style.scheme.import.unnamed", (Object[])new Object[0]);
            }
            CodeStyleScheme newScheme = CodeStyleSchemesActions.this.getModel().createNewScheme(targetName, (CodeStyleScheme)CodeStyleSchemesActions.this.getCurrentScheme());
            CodeStyleSchemesActions.this.getModel().addScheme(newScheme, true);
            return newScheme;
        }

        public boolean isSchemeWasCreated() {
            return this.mySchemeWasCreated;
        }
    }
}

