/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CodeStyleSchemesActions;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesPanel
extends SimpleSchemesPanel<CodeStyleScheme> {
    private final CodeStyleSchemesModel myModel;
    private boolean myIsReset = false;

    public CodeStyleSchemesPanel(CodeStyleSchemesModel model2) {
        this.myModel = model2;
    }

    private void onCombo() {
        CodeStyleScheme selected = (CodeStyleScheme)this.getSelectedScheme();
        if (selected != null) {
            if (this.myModel.isProjectScheme(selected)) {
                this.myModel.setUsePerProjectSettings(true);
            } else {
                this.myModel.selectScheme(selected, this);
                this.myModel.setUsePerProjectSettings(false);
            }
        }
    }

    public void resetSchemesCombo() {
        this.myIsReset = true;
        try {
            ArrayList<CodeStyleScheme> schemes = new ArrayList<CodeStyleScheme>();
            schemes.addAll(this.myModel.getAllSortedSchemes());
            this.resetSchemes(schemes);
            if (this.myModel.isUsePerProjectSettings()) {
                this.selectScheme(this.myModel.getProjectScheme());
            } else {
                this.selectScheme(this.myModel.getSelectedGlobalScheme());
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void onSelectedSchemeChanged() {
        this.myIsReset = true;
        try {
            if (this.myModel.isUsePerProjectSettings()) {
                this.selectScheme(this.myModel.getProjectScheme());
            } else {
                this.selectScheme(this.myModel.getSelectedGlobalScheme());
            }
        }
        finally {
            this.myIsReset = false;
        }
    }

    public void usePerProjectSettingsOptionChanged() {
        if (this.myModel.isProjectScheme(this.myModel.getSelectedScheme())) {
            this.selectScheme(this.myModel.getProjectScheme());
        } else {
            this.selectScheme(this.myModel.getSelectedScheme());
        }
    }

    @Override
    protected AbstractSchemeActions<CodeStyleScheme> createSchemeActions() {
        return new CodeStyleSchemesActions(this){

            @Override
            protected void onSchemeChanged(@Nullable CodeStyleScheme scheme2) {
                if (!CodeStyleSchemesPanel.this.myIsReset) {
                    ApplicationManager.getApplication().invokeLater(() -> CodeStyleSchemesPanel.this.onCombo());
                }
            }

            @Override
            protected void renameScheme(@NotNull CodeStyleScheme scheme2, @NotNull String newName) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$1", "renameScheme"));
                }
                if (newName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel$1", "renameScheme"));
                }
                CodeStyleSchemeImpl newScheme = new CodeStyleSchemeImpl(newName, false, scheme2);
                CodeStyleSchemesPanel.this.myModel.addScheme(newScheme, false);
                CodeStyleSchemesPanel.this.myModel.removeScheme(scheme2);
                CodeStyleSchemesPanel.this.myModel.selectScheme(newScheme, null);
            }
        };
    }

    @Override
    @NotNull
    public SchemesModel<CodeStyleScheme> getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = this.myModel;
        if (codeStyleSchemesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/CodeStyleSchemesPanel", "getModel"));
        }
        return codeStyleSchemesModel;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return true;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }
}

