/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CommenterForm
implements CodeStyleSettingsCustomizable {
    private JPanel myCommenterPanel;
    private JBCheckBox myLineCommentAtFirstColumnCb;
    private JBCheckBox myLineCommentAddSpaceCb;
    private JBCheckBox myBlockCommentAtFirstJBCheckBox;
    private final Language myLanguage;

    public CommenterForm(Language language) {
        this.myLanguage = language;
        this.$$$setupUI$$$();
        this.myCommenterPanel.setBorder(IdeBorderFactory.createTitledBorder((String)ApplicationBundle.message((String)"title.naming.comment.code", (Object[])new Object[0])));
        this.myLineCommentAtFirstColumnCb.addActionListener(e2 -> {
            if (this.myLineCommentAtFirstColumnCb.isSelected()) {
                this.myLineCommentAddSpaceCb.setSelected(false);
            }
            this.myLineCommentAddSpaceCb.setEnabled(!this.myLineCommentAtFirstColumnCb.isSelected());
        });
        this.customizeSettings();
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/CommenterForm", "reset"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        this.myLineCommentAtFirstColumnCb.setSelected(langSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myBlockCommentAtFirstJBCheckBox.setSelected(langSettings.BLOCK_COMMENT_AT_FIRST_COLUMN);
        this.myLineCommentAddSpaceCb.setSelected(langSettings.LINE_COMMENT_ADD_SPACE && !langSettings.LINE_COMMENT_AT_FIRST_COLUMN);
        this.myLineCommentAddSpaceCb.setEnabled(!langSettings.LINE_COMMENT_AT_FIRST_COLUMN);
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/CommenterForm", "apply"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        langSettings.LINE_COMMENT_AT_FIRST_COLUMN = this.myLineCommentAtFirstColumnCb.isSelected();
        langSettings.BLOCK_COMMENT_AT_FIRST_COLUMN = this.myBlockCommentAtFirstJBCheckBox.isSelected();
        langSettings.LINE_COMMENT_ADD_SPACE = this.myLineCommentAddSpaceCb.isSelected();
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/codeStyle/CommenterForm", "isModified"));
        }
        CommonCodeStyleSettings langSettings = settings.getCommonSettings(this.myLanguage);
        return this.myLineCommentAtFirstColumnCb.isSelected() != langSettings.LINE_COMMENT_AT_FIRST_COLUMN || this.myBlockCommentAtFirstJBCheckBox.isSelected() != langSettings.BLOCK_COMMENT_AT_FIRST_COLUMN || this.myLineCommentAddSpaceCb.isSelected() != langSettings.LINE_COMMENT_ADD_SPACE;
    }

    public JPanel getCommenterPanel() {
        return this.myCommenterPanel;
    }

    public void showAllStandardOptions() {
        this.setAllOptionsVisible(true);
    }

    public void showStandardOptions(String ... optionNames) {
        for (String optionName : optionNames) {
            if (CodeStyleSettingsCustomizable.CommenterOption.LINE_COMMENT_ADD_SPACE.name().equals(optionName)) {
                this.myLineCommentAddSpaceCb.setVisible(true);
                continue;
            }
            if (CodeStyleSettingsCustomizable.WrappingOrBraceOption.LINE_COMMENT_AT_FIRST_COLUMN.name().equals(optionName)) {
                this.myLineCommentAtFirstColumnCb.setVisible(true);
                continue;
            }
            if (!CodeStyleSettingsCustomizable.WrappingOrBraceOption.BLOCK_COMMENT_AT_FIRST_COLUMN.name().equals(optionName)) continue;
            this.myBlockCommentAtFirstJBCheckBox.setVisible(true);
        }
    }

    private void setAllOptionsVisible(boolean isVisible) {
        this.myLineCommentAtFirstColumnCb.setVisible(isVisible);
        this.myLineCommentAddSpaceCb.setVisible(isVisible);
        this.myBlockCommentAtFirstJBCheckBox.setVisible(isVisible);
    }

    private void customizeSettings() {
        this.setAllOptionsVisible(false);
        LanguageCodeStyleSettingsProvider settingsProvider = LanguageCodeStyleSettingsProvider.forLanguage((Language)this.myLanguage);
        if (settingsProvider != null) {
            settingsProvider.customizeSettings((CodeStyleSettingsCustomizable)this, LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS);
            settingsProvider.customizeSettings((CodeStyleSettingsCustomizable)this, LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS);
        }
        this.myCommenterPanel.setVisible(this.myLineCommentAtFirstColumnCb.isVisible() || this.myLineCommentAddSpaceCb.isVisible() || this.myBlockCommentAtFirstJBCheckBox.isVisible());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel;
        this.myCommenterPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(null, ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.naming.comment.code"), 0, 0, null, null));
        this.myLineCommentAtFirstColumnCb = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.line.comment.at.first.column"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLineCommentAddSpaceCb = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.line.comment.add.space"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myBlockCommentAtFirstJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.block.comment.at.first.column"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myCommenterPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

