/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.CustomizableLanguageCodeStylePanel;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ClientPropertyHolder;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionTableWithPreviewPanel
extends CustomizableLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance((String)("#" + OptionTableWithPreviewPanel.class.getName()));
    protected TreeTable myTreeTable;
    private final JPanel myPanel = new JPanel();
    private final List<Option> myOptions = new ArrayList<Option>();
    private final List<Option> myCustomOptions = new ArrayList<Option>();
    private final Set<String> myAllowedOptions = new THashSet();
    private final Map<String, String> myRenamedFields = new THashMap();
    private boolean myShowAllStandardOptions;
    protected boolean isFirstUpdate = true;
    public final ColumnInfo TITLE = new ColumnInfo("TITLE"){

        public Object valueOf(Object o2) {
            if (o2 instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)o2;
                return node.getText();
            }
            return o2.toString();
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }
    };
    public final ColumnInfo VALUE = new ColumnInfo("VALUE"){
        private final TableCellEditor myEditor;
        private final TableCellRenderer myRenderer;
        {
            this.myEditor = new MyValueEditor();
            this.myRenderer = new MyValueRenderer();
        }

        public Object valueOf(Object o2) {
            if (o2 instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)o2;
                return node.getValue();
            }
            return null;
        }

        public TableCellRenderer getRenderer(Object o2) {
            return this.myRenderer;
        }

        public TableCellEditor getEditor(Object item) {
            return this.myEditor;
        }

        public boolean isCellEditable(Object o2) {
            return o2 instanceof MyTreeNode && ((MyTreeNode)o2).isEnabled();
        }

        public void setValue(Object o2, Object o1) {
            MyTreeNode node = (MyTreeNode)o2;
            node.setValue(o1);
        }
    };
    public final ColumnInfo[] COLUMNS = new ColumnInfo[]{this.TITLE, this.VALUE};
    private final TreeCellRenderer myTitleRenderer = new TreeCellRenderer(){
        private final JLabel myLabel = new JLabel();

        @Override
        @NotNull
        public Component getTreeCellRendererComponent(@NotNull JTree tree2, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$5", "getTreeCellRendererComponent"));
            }
            if (value2 instanceof MyTreeNode) {
                MyTreeNode node = (MyTreeNode)value2;
                this.myLabel.setText(OptionTableWithPreviewPanel.this.getRenamedTitle(node.getKey().field.getName(), node.getText()));
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(node.getKey().groupName == null ? 1 : 0));
                this.myLabel.setEnabled(node.isEnabled());
            } else {
                this.myLabel.setText(OptionTableWithPreviewPanel.this.getRenamedTitle(value2.toString(), value2.toString()));
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(1));
                this.myLabel.setEnabled(true);
            }
            Color foreground = selected ? UIUtil.getTableSelectionForeground() : UIUtil.getTableForeground();
            this.myLabel.setForeground(foreground);
            JLabel jLabel = this.myLabel;
            if (jLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$5", "getTreeCellRendererComponent"));
            }
            return jLabel;
        }
    };

    public OptionTableWithPreviewPanel(CodeStyleSettings settings) {
        super(settings);
    }

    @Override
    protected void init() {
        super.init();
        this.myPanel.setLayout(new GridBagLayout());
        this.initTables();
        this.myTreeTable = this.createOptionsTree(this.getSettings());
        this.myTreeTable.setBackground(UIUtil.getPanelBackground());
        this.myTreeTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable){

            public Dimension getMinimumSize() {
                return super.getPreferredSize();
            }
        };
        this.myPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel previewPanel = OptionTableWithPreviewPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
        this.isFirstUpdate = false;
        this.customizeSettings();
    }

    @Override
    protected void resetDefaultNames() {
        this.myRenamedFields.clear();
    }

    public void showAllStandardOptions() {
        this.myShowAllStandardOptions = true;
        for (Option each : this.myOptions) {
            each.setEnabled(true);
        }
        for (Option each : this.myCustomOptions) {
            each.setEnabled(false);
        }
    }

    public void showStandardOptions(String ... optionNames) {
        Collections.addAll(this.myAllowedOptions, optionNames);
        for (Option each : this.myOptions) {
            each.setEnabled(false);
            for (String optionName : optionNames) {
                if (!each.field.getName().equals(optionName)) continue;
                each.setEnabled(true);
            }
        }
        for (Option each : this.myCustomOptions) {
            each.setEnabled(false);
        }
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, Object ... options) {
        this.showCustomOption(settingsClass, fieldName, title, groupName, null, null, options);
    }

    public void showCustomOption(Class<? extends CustomCodeStyleSettings> settingsClass, String fieldName, String title, String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @Nullable String anchorFieldName, Object ... options) {
        if (this.isFirstUpdate) {
            Option option = options.length == 2 ? new SelectionOption(settingsClass, fieldName, title, groupName, anchor, anchorFieldName, (String[])options[0], (int[])options[1]) : new BooleanOption(settingsClass, fieldName, title, groupName, anchor, anchorFieldName);
            this.myCustomOptions.add(option);
            option.setEnabled(true);
        } else {
            for (Option each : this.myCustomOptions) {
                if (each.clazz != settingsClass || !each.field.getName().equals(fieldName)) continue;
                each.setEnabled(true);
            }
        }
    }

    public void renameStandardOption(String fieldName, String newTitle) {
        this.myRenamedFields.put(fieldName, newTitle);
    }

    protected TreeTable createOptionsTree(CodeStyleSettings settings) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        THashMap groupsMap = new THashMap();
        List sorted = this.sortOptions(ContainerUtil.concat(this.myOptions, this.myCustomOptions));
        for (Option each : sorted) {
            String groupName;
            if (!this.myCustomOptions.contains(each) && !this.myAllowedOptions.contains(each.field.getName()) && !this.myShowAllStandardOptions) continue;
            String group = each.groupName;
            MyTreeNode newNode = new MyTreeNode(each, each.title, settings);
            DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)groupsMap.get(group);
            if (groupNode != null) {
                groupNode.add(newNode);
                continue;
            }
            if (group == null) {
                groupName = each.title;
                groupNode = newNode;
            } else {
                groupName = group;
                groupNode = new DefaultMutableTreeNode(groupName);
                groupNode.add(newNode);
            }
            groupsMap.put(groupName, groupNode);
            rootNode.add(groupNode);
        }
        ListTreeTableModel model2 = new ListTreeTableModel((TreeNode)rootNode, this.COLUMNS);
        TreeTable treeTable2 = new TreeTable((TreeTableModel)model2){

            public TreeTableCellRenderer createTableRenderer(TreeTableModel treeTableModel) {
                TreeTableCellRenderer tableRenderer = super.createTableRenderer(treeTableModel);
                UIUtil.setLineStyleAngled((ClientPropertyHolder)tableRenderer);
                tableRenderer.setRootVisible(false);
                tableRenderer.setShowsRootHandles(true);
                return tableRenderer;
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellRenderer(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellRenderer renderer = OptionTableWithPreviewPanel.this.COLUMNS[column].getRenderer(node);
                return renderer == null ? super.getCellRenderer(row, column) : renderer;
            }

            public TableCellEditor getCellEditor(int row, int column) {
                TreePath treePath = this.getTree().getPathForRow(row);
                if (treePath == null) {
                    return super.getCellEditor(row, column);
                }
                Object node = treePath.getLastPathComponent();
                TableCellEditor editor = OptionTableWithPreviewPanel.this.COLUMNS[column].getEditor(node);
                return editor == null ? super.getCellEditor(row, column) : editor;
            }
        };
        new TreeTableSpeedSearch(treeTable2).setComparator(new SpeedSearchComparator(false));
        treeTable2.setRootVisible(false);
        TreeTableTree tree2 = treeTable2.getTree();
        tree2.setCellRenderer(this.myTitleRenderer);
        tree2.setShowsRootHandles(true);
        treeTable2.setSelectionMode(0);
        treeTable2.setTableHeader(null);
        TreeUtil.expandAll((JTree)tree2);
        treeTable2.getColumnModel().getSelectionModel().setAnchorSelectionIndex(1);
        treeTable2.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
        int maxWidth = tree2.getPreferredScrollableViewportSize().width + 10;
        TableColumn titleColumn = treeTable2.getColumnModel().getColumn(0);
        titleColumn.setPreferredWidth(maxWidth);
        titleColumn.setMinWidth(maxWidth);
        titleColumn.setMaxWidth(maxWidth);
        titleColumn.setResizable(false);
        Dimension valueSize = new JLabel(ApplicationBundle.message((String)"option.table.sizing.text", (Object[])new Object[0])).getPreferredSize();
        treeTable2.setPreferredScrollableViewportSize(new Dimension(maxWidth + valueSize.width + 10, 20));
        return treeTable2;
    }

    private String getRenamedTitle(String fieldOrGroupName, String defaultName) {
        String result2 = this.myRenamedFields.get(fieldOrGroupName);
        return result2 == null ? defaultName : result2;
    }

    protected abstract void initTables();

    private static void resetNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode) {
            ((MyTreeNode)node).reset(settings);
        }
        for (int j2 = 0; j2 < node.getChildCount(); ++j2) {
            TreeNode child = node.getChildAt(j2);
            OptionTableWithPreviewPanel.resetNode(child, settings);
        }
    }

    private static void applyNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode) {
            ((MyTreeNode)node).apply(settings);
        }
        for (int j2 = 0; j2 < node.getChildCount(); ++j2) {
            TreeNode child = node.getChildAt(j2);
            OptionTableWithPreviewPanel.applyNode(child, settings);
        }
    }

    private static boolean isModified(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyTreeNode && ((MyTreeNode)node).isModified(settings)) {
            return true;
        }
        for (int j2 = 0; j2 < node.getChildCount(); ++j2) {
            TreeNode child = node.getChildAt(j2);
            if (!OptionTableWithPreviewPanel.isModified(child, settings)) continue;
            return true;
        }
        return false;
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.addOption(fieldName, title, null);
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @NotNull String[] options, @NotNull int[] values) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.addOption(fieldName, title, null, options, values);
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, int minValue, int maxValue, int defaultValue, String defaultValueText) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.myOptions.add(new IntOption(null, fieldName, title, groupName, null, null, minValue, maxValue, defaultValue, defaultValueText));
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.myOptions.add(new BooleanOption(null, fieldName, title, groupName, null, null));
    }

    protected void addOption(@NotNull String fieldName, @NotNull String title, @Nullable String groupName, @NotNull String[] options, @NotNull int[] values) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel", "addOption"));
        }
        this.myOptions.add(new SelectionOption(null, fieldName, title, groupName, null, null, options, values));
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        OptionTableWithPreviewPanel.applyNode(root, settings);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        return OptionTableWithPreviewPanel.isModified(root, settings);
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        TreeModel treeModel = this.myTreeTable.getTree().getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        OptionTableWithPreviewPanel.resetNode(root, settings);
        ((DefaultTreeModel)treeModel).nodeChanged(root);
    }

    @Override
    public Set<String> processListOptions() {
        HashSet<String> options = new HashSet<String>();
        this.collectOptions(options, this.myOptions);
        this.collectOptions(options, this.myCustomOptions);
        return options;
    }

    private void collectOptions(Set<String> optionNames, List<Option> optionList) {
        for (Option option : optionList) {
            if (option.groupName != null) {
                optionNames.add(option.groupName);
            }
            optionNames.add(option.title);
        }
    }

    private class MyValueEditor
    extends AbstractTableCellEditor {
        private final JCheckBox myBooleanEditor = new JBCheckBox();
        private JBComboBoxTableCellEditorComponent myOptionsEditor = new JBComboBoxTableCellEditorComponent();
        private MyIntOptionEditor myIntOptionsEditor = new MyIntOptionEditor();
        private Component myCurrentEditor = null;
        private MyTreeNode myCurrentNode = null;

        public MyValueEditor() {
            ActionListener itemChoosen2 = new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent e2) {
                    if (e2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueEditor$1", "actionPerformed"));
                    }
                    if (MyValueEditor.this.myCurrentNode != null) {
                        MyValueEditor.this.myCurrentNode.setValue(MyValueEditor.this.getCellEditorValue());
                        OptionTableWithPreviewPanel.this.somethingChanged();
                    }
                }
            };
            this.myBooleanEditor.addActionListener(itemChoosen2);
            this.myOptionsEditor.addActionListener(itemChoosen2);
            this.myBooleanEditor.putClientProperty("JComponent.sizeVariant", "small");
            this.myOptionsEditor.putClientProperty((Object)"JComponent.sizeVariant", (Object)"small");
        }

        public Object getCellEditorValue() {
            if (this.myCurrentEditor == this.myOptionsEditor) {
                return this.myOptionsEditor.getEditorValue();
            }
            if (this.myCurrentEditor == this.myBooleanEditor) {
                return this.myBooleanEditor.isSelected();
            }
            if (this.myCurrentEditor == this.myIntOptionsEditor) {
                return this.myIntOptionsEditor.getPresentableValue();
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
            DefaultMutableTreeNode defaultNode = (DefaultMutableTreeNode)((TreeTable)table2).getTree().getPathForRow(row).getLastPathComponent();
            this.myCurrentEditor = null;
            this.myCurrentNode = null;
            if (defaultNode instanceof MyTreeNode) {
                MyTreeNode node;
                this.myCurrentNode = node = (MyTreeNode)defaultNode;
                if (node.getKey() instanceof BooleanOption) {
                    this.myCurrentEditor = this.myBooleanEditor;
                    this.myBooleanEditor.setSelected(node.getValue() == Boolean.TRUE);
                    this.myBooleanEditor.setEnabled(node.isEnabled());
                } else if (node.getKey() instanceof IntOption) {
                    IntOption intOption = (IntOption)node.getKey();
                    this.myCurrentEditor = this.myIntOptionsEditor;
                    this.myIntOptionsEditor.setText(intOption.isDefaultValue(node.getValue()) ? "" : node.getValue().toString());
                    this.myIntOptionsEditor.setMinValue(intOption.getMinValue());
                    this.myIntOptionsEditor.setMaxValue(intOption.getMaxValue());
                    this.myIntOptionsEditor.setDefaultValue(intOption.getDefaultValue());
                } else {
                    this.myCurrentEditor = this.myOptionsEditor;
                    this.myOptionsEditor.setCell(table2, row, column);
                    this.myOptionsEditor.setText(String.valueOf(node.getValue()));
                    this.myOptionsEditor.setOptions((Object[])((SelectionOption)node.getKey()).options);
                    this.myOptionsEditor.setDefaultValue(node.getValue());
                }
            }
            if (this.myCurrentEditor != null) {
                this.myCurrentEditor.setBackground(table2.getBackground());
            }
            return this.myCurrentEditor;
        }
    }

    private static class MyIntOptionEditor
    extends JTextField {
        private int myMinValue;
        private int myMaxValue;
        private int myDefaultValue;

        private MyIntOptionEditor() {
        }

        public Object getPresentableValue() {
            return this.validateAndGetIntOption();
        }

        private int validateAndGetIntOption() {
            try {
                int value2 = Integer.parseInt(this.getText());
                return value2 >= this.myMinValue && value2 <= this.myMaxValue ? value2 : this.myDefaultValue;
            }
            catch (NumberFormatException nfe) {
                return this.myDefaultValue;
            }
        }

        public void setMinValue(int minValue) {
            this.myMinValue = minValue;
        }

        public void setMaxValue(int maxValue) {
            this.myMaxValue = maxValue;
        }

        public void setDefaultValue(int defaultValue) {
            this.myDefaultValue = defaultValue;
        }
    }

    private static class MyValueRenderer
    implements TableCellRenderer {
        private JTable myTable;
        private int myRow;
        private int myColumn;
        private final OptionsLabel myComboBox = new OptionsLabel();
        private final JCheckBox myCheckBox = new JBCheckBox();
        private final JPanel myEmptyLabel = new JPanel();
        private final JLabel myIntLabel = new JLabel();

        private MyValueRenderer() {
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
            }
            this.myTable = table2;
            this.myRow = row;
            this.myColumn = column;
            boolean isEnabled = true;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)((TreeTable)table2).getTree().getPathForRow(row).getLastPathComponent();
            Option key = null;
            if (node instanceof MyTreeNode) {
                isEnabled = ((MyTreeNode)node).isEnabled();
                key = ((MyTreeNode)node).getKey();
            }
            if (!table2.isEnabled()) {
                isEnabled = false;
            }
            Color background = table2.getBackground();
            if (value2 instanceof Boolean) {
                this.myCheckBox.setSelected((Boolean)value2);
                this.myCheckBox.setBackground(background);
                this.myCheckBox.setEnabled(isEnabled);
                JCheckBox jCheckBox = this.myCheckBox;
                if (jCheckBox == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
                }
                return jCheckBox;
            }
            if (value2 instanceof String) {
                this.myComboBox.setText((String)value2);
                this.myComboBox.setBackground(background);
                this.myComboBox.setEnabled(isEnabled);
                OptionsLabel optionsLabel = this.myComboBox;
                if (optionsLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
                }
                return optionsLabel;
            }
            if (value2 instanceof Integer) {
                if (key instanceof IntOption && ((IntOption)key).isDefaultValue(value2)) {
                    this.myIntLabel.setText(((IntOption)key).getDefaultValueText());
                } else {
                    this.myIntLabel.setText(value2.toString());
                }
                JLabel jLabel = this.myIntLabel;
                if (jLabel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
                }
                return jLabel;
            }
            this.myCheckBox.putClientProperty("JComponent.sizeVariant", "small");
            this.myComboBox.putClientProperty("JComponent.sizeVariant", "small");
            this.myEmptyLabel.setBackground(background);
            JPanel jPanel = this.myEmptyLabel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$MyValueRenderer", "getTableCellRendererComponent"));
            }
            return jPanel;
        }

        protected class OptionsLabel
        extends JLabel {
            protected OptionsLabel() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleOptionsLabel();
                }
                return this.accessibleContext;
            }

            protected class AccessibleOptionsLabel
            extends JLabel.AccessibleJLabel
            implements AccessibleAction {
                protected AccessibleOptionsLabel() {
                    super(OptionsLabel.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PUSH_BUTTON;
                }

                @Override
                public AccessibleAction getAccessibleAction() {
                    return this;
                }

                @Override
                public int getAccessibleActionCount() {
                    return 1;
                }

                @Override
                public String getAccessibleActionDescription(int i2) {
                    if (i2 == 0) {
                        return UIManager.getString("AbstractButton.clickText");
                    }
                    return null;
                }

                @Override
                public boolean doAccessibleAction(int i2) {
                    if (i2 == 0) {
                        MyValueRenderer.this.myTable.editCellAt(MyValueRenderer.this.myRow, MyValueRenderer.this.myColumn);
                        return true;
                    }
                    return false;
                }
            }
        }
    }

    private static class MyTreeNode
    extends DefaultMutableTreeNode {
        private final Option myKey;
        private final String myText;
        private Object myValue;

        public MyTreeNode(Option key, String text2, CodeStyleSettings settings) {
            this.myKey = key;
            this.myText = text2;
            this.myValue = key.getValue(settings);
            this.setUserObject(this.myText);
        }

        public Option getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public Object getValue() {
            return this.myValue;
        }

        public void setValue(Object value2) {
            this.myValue = value2;
        }

        public void reset(CodeStyleSettings settings) {
            this.setValue(this.myKey.getValue(settings));
        }

        public boolean isModified(CodeStyleSettings settings) {
            return this.myValue != null && !this.myValue.equals(this.myKey.getValue(settings));
        }

        public void apply(CodeStyleSettings settings) {
            this.myKey.setValue(this.myValue, settings);
        }

        public boolean isEnabled() {
            return this.myKey.isEnabled();
        }
    }

    private class IntOption
    extends Option {
        private final int myMinValue;
        private final int myMaxValue;
        private final int myDefaultValue;
        @Nullable
        private String myDefaultValueText;

        public IntOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFiledName, int minValue, int maxValue, @Nullable int defaultValue, String defaultValueText) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$IntOption", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$IntOption", "<init>"));
            }
            super(clazz, fieldName, title, groupName, anchor, anchorFiledName);
            this.myMinValue = minValue;
            this.myMaxValue = maxValue;
            this.myDefaultValue = defaultValue;
            this.myDefaultValueText = defaultValueText;
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                return this.field.getInt(this.getSettings(settings));
            }
            catch (IllegalAccessException e2) {
                return null;
            }
        }

        @Override
        public void setValue(Object value2, CodeStyleSettings settings) {
            try {
                if (value2 instanceof Integer) {
                    this.field.setInt(this.getSettings(settings), (Integer)value2);
                } else {
                    this.field.setInt(this.getSettings(settings), this.myDefaultValue);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public int getMinValue() {
            return this.myMinValue;
        }

        public int getMaxValue() {
            return this.myMaxValue;
        }

        public int getDefaultValue() {
            return this.myDefaultValue;
        }

        public boolean isDefaultValue(Object value2) {
            return value2 instanceof Integer && (Integer)value2 == this.myDefaultValue;
        }

        @Nullable
        public String getDefaultValueText() {
            return this.myDefaultValueText;
        }
    }

    private class SelectionOption
    extends Option {
        @NotNull
        final String[] options;
        @NotNull
        final int[] values;

        public SelectionOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, @NotNull String anchorFiledName, @NotNull String[] options, int[] values) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$SelectionOption", "<init>"));
            }
            super(clazz, fieldName, title, groupName, anchor, anchorFiledName);
            this.options = options;
            this.values = values;
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                int value2 = this.field.getInt(this.getSettings(settings));
                for (int i2 = 0; i2 < this.values.length; ++i2) {
                    if (this.values[i2] != value2) continue;
                    return this.options[i2];
                }
                LOG.error("Invalid option value " + value2 + " for " + this.field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void setValue(Object value2, CodeStyleSettings settings) {
            try {
                for (int i2 = 0; i2 < this.values.length; ++i2) {
                    if (!this.options[i2].equals(value2)) continue;
                    this.field.setInt(this.getSettings(settings), this.values[i2]);
                    return;
                }
                LOG.error("Invalid option value " + value2 + " for " + this.field.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private class BooleanOption
    extends Option {
        private BooleanOption(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFiledName) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$BooleanOption", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$BooleanOption", "<init>"));
            }
            super(clazz, fieldName, title, groupName, anchor, anchorFiledName);
        }

        @Override
        public Object getValue(CodeStyleSettings settings) {
            try {
                return this.field.getBoolean(this.getSettings(settings));
            }
            catch (IllegalAccessException ignore) {
                return null;
            }
        }

        @Override
        public void setValue(Object value2, CodeStyleSettings settings) {
            try {
                this.field.setBoolean(this.getSettings(settings), (Boolean)value2);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private abstract class Option
    extends CustomizableLanguageCodeStylePanel.OrderedOption {
        @Nullable
        final Class<? extends CustomCodeStyleSettings> clazz;
        @NotNull
        final Field field;
        @NotNull
        final String title;
        @Nullable
        final String groupName;
        private boolean myEnabled;

        public Option(@NotNull Class<? extends CustomCodeStyleSettings> clazz, @NotNull String fieldName, @Nullable String title, @Nullable String groupName, @Nullable CodeStyleSettingsCustomizable.OptionAnchor anchor, String anchorFiledName) {
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$Option", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/codeStyle/OptionTableWithPreviewPanel$Option", "<init>"));
            }
            super(fieldName, anchor, anchorFiledName);
            this.myEnabled = false;
            this.clazz = clazz;
            this.title = title;
            this.groupName = groupName;
            try {
                Class styleSettingsClass = clazz == null ? CommonCodeStyleSettings.class : clazz;
                this.field = styleSettingsClass.getField(fieldName);
            }
            catch (NoSuchFieldException e2) {
                throw new RuntimeException(e2);
            }
        }

        public void setEnabled(boolean enabled) {
            this.myEnabled = enabled;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public abstract Object getValue(CodeStyleSettings var1);

        public abstract void setValue(Object var1, CodeStyleSettings var2);

        protected Object getSettings(CodeStyleSettings settings) {
            if (this.clazz != null) {
                return settings.getCustomSettings(this.clazz);
            }
            return settings.getCommonSettings(OptionTableWithPreviewPanel.this.getDefaultLanguage());
        }
    }
}

