/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.additional;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.OptionGroup;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceArrangementPanel {
    @NotNull
    private final JComboBox myForceRearrangeComboBox = new JComboBox();
    @NotNull
    private final JPanel myPanel;

    public ForceArrangementPanel() {
        this.myForceRearrangeComboBox.setModel(new EnumComboBoxModel(SelectedMode.class));
        this.myForceRearrangeComboBox.setMaximumSize(this.myForceRearrangeComboBox.getPreferredSize());
        this.myPanel = this.createPanel();
    }

    public int getRearrangeMode() {
        return this.getSelectedMode().rearrangeMode;
    }

    public void setSelectedMode(@NotNull SelectedMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel", "setSelectedMode"));
        }
        this.myForceRearrangeComboBox.setSelectedItem((Object)mode);
    }

    public void setSelectedMode(int mode) {
        SelectedMode toSetUp = SelectedMode.getByMode(mode);
        assert (toSetUp != null);
        this.setSelectedMode(toSetUp);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel", "getPanel"));
        }
        return jPanel;
    }

    @NotNull
    private JPanel createPanel() {
        OptionGroup group = new OptionGroup(ApplicationBundle.message((String)"arrangement.settings.additional.title", (Object[])new Object[0]));
        JPanel textWithComboPanel = new JPanel();
        textWithComboPanel.setLayout(new BoxLayout(textWithComboPanel, 2));
        textWithComboPanel.add(new JLabel(ApplicationBundle.message((String)"arrangement.settings.additional.force.combobox.name", (Object[])new Object[0])));
        textWithComboPanel.add(Box.createRigidArea((Dimension)JBUI.size((int)5, (int)0)));
        textWithComboPanel.add(this.myForceRearrangeComboBox);
        group.add((JComponent)textWithComboPanel);
        JPanel jPanel = group.createPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel", "createPanel"));
        }
        return jPanel;
    }

    @NotNull
    private SelectedMode getSelectedMode() {
        SelectedMode selectedMode = (SelectedMode)((Object)this.myForceRearrangeComboBox.getSelectedItem());
        if (selectedMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel", "getSelectedMode"));
        }
        return selectedMode;
    }

    private static enum SelectedMode {
        FROM_DIALOG(ApplicationBundle.message((String)"arrangement.settings.additional.force.rearrange.according.to.dialog", (Object[])new Object[0]), CommonCodeStyleSettings.REARRANGE_ACCORDIND_TO_DIALOG),
        ALWAYS(ApplicationBundle.message((String)"arrangement.settings.additional.force.rearrange.always", (Object[])new Object[0]), CommonCodeStyleSettings.REARRANGE_ALWAYS),
        NEVER(ApplicationBundle.message((String)"arrangement.settings.additional.force.rearrange.never", (Object[])new Object[0]), CommonCodeStyleSettings.REARRANGE_NEVER);

        public final int rearrangeMode;
        @NotNull
        private final String myName;

        private SelectedMode(String name, int mode) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel$SelectedMode", "<init>"));
            }
            this.myName = name;
            this.rearrangeMode = mode;
        }

        @Nullable
        private static SelectedMode getByMode(int mode) {
            for (SelectedMode currentMode : SelectedMode.values()) {
                if (currentMode.rearrangeMode != mode) continue;
                return currentMode;
            }
            return null;
        }

        @NotNull
        public String toString() {
            String string2 = this.myName;
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/additional/ForceArrangementPanel$SelectedMode", "toString"));
            }
            return string2;
        }
    }
}

