/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementEditorComponent;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchNodeComponentFactory;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.EmptyArrangementRuleComponent;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.application.options.codeStyle.arrangement.util.ArrangementListRowDecorator;
import com.intellij.application.options.codeStyle.arrangement.util.IntObjectMap;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ArrangementMatchingRulesControl
extends JBTable {
    @NotNull
    private static final JLabel EMPTY_RENDERER = new JLabel(ApplicationBundle.message((String)"arrangement.text.empty.rule", (Object[])new Object[0]));
    @NotNull
    protected final IntObjectMap<ArrangementListRowDecorator> myComponents;
    @NotNull
    private final TIntArrayList mySelectedRows;
    @NotNull
    private final ArrangementMatchNodeComponentFactory myFactory;
    @NotNull
    protected ArrangementMatchingRuleEditor myEditor;
    @NotNull
    private final RepresentationCallback myRepresentationCallback;
    @NotNull
    private final MatchingRulesRendererBase myRenderer;
    private ArrangementMatchingRulesValidator myValidator;
    private final int myMinRowHeight;
    private int myRowUnderMouse;
    private int myEditorRow;
    private boolean mySkipSelectionChange;

    public ArrangementMatchingRulesControl(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull RepresentationCallback callback) {
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "<init>"));
        }
        super((TableModel)new ArrangementMatchingRulesModel());
        this.myComponents = new IntObjectMap();
        this.mySelectedRows = new TIntArrayList();
        this.myRowUnderMouse = -1;
        this.myEditorRow = -1;
        this.myRepresentationCallback = callback;
        this.myFactory = new ArrangementMatchNodeComponentFactory(settingsManager, colorsProvider, this);
        this.myRenderer = this.createRender();
        this.setDefaultRenderer(Object.class, this.myRenderer);
        this.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new MyEditor()));
        this.setSelectionMode(2);
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setBorder(IdeBorderFactory.createBorder());
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ArrangementAtomMatchCondition condition = new ArrangementAtomMatchCondition(StdArrangementTokens.EntryType.CLASS);
        StdArrangementMatchRule rule = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)condition));
        ArrangementUiComponent component = this.myFactory.getComponent((ArrangementMatchCondition)condition, rule, true);
        this.myMinRowHeight = new ArrangementListRowDecorator((ArrangementUiComponent)component, (ArrangementMatchingRulesControl)this).getPreferredSize().height;
        this.myEditor = new ArrangementMatchingRuleEditor(settingsManager, colorsProvider, this);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e2) {
                ArrangementMatchingRulesControl.this.onMouseMoved(e2);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                ArrangementMatchingRulesControl.this.onSelectionChange(e2);
            }
        });
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e2) {
                ArrangementMatchingRulesControl.this.onTableChange(e2);
            }
        });
    }

    protected MatchingRulesRendererBase createRender() {
        return new MatchingRulesRendererBase();
    }

    @NotNull
    protected ArrangementMatchingRulesValidator createValidator() {
        ArrangementMatchingRulesValidator arrangementMatchingRulesValidator = new ArrangementMatchingRulesValidator(this.getModel());
        if (arrangementMatchingRulesValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "createValidator"));
        }
        return arrangementMatchingRulesValidator;
    }

    private ArrangementMatchingRulesValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = this.createValidator();
        }
        return this.myValidator;
    }

    @NotNull
    public ArrangementMatchingRulesModel getModel() {
        ArrangementMatchingRulesModel arrangementMatchingRulesModel = (ArrangementMatchingRulesModel)super.getModel();
        if (arrangementMatchingRulesModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "getModel"));
        }
        return arrangementMatchingRulesModel;
    }

    protected void processMouseEvent(MouseEvent e2) {
        int id = e2.getID();
        switch (id) {
            case 504: {
                this.onMouseEntered(e2);
                break;
            }
            case 505: {
                this.onMouseExited();
                break;
            }
            case 502: {
                this.onMouseReleased(e2);
                break;
            }
            case 500: {
                this.onMouseClicked(e2);
            }
        }
        if (!e2.isConsumed()) {
            super.processMouseEvent(e2);
        }
    }

    private void onMouseClicked(@NotNull MouseEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onMouseClicked"));
        }
        int count = e2.getClickCount();
        if (count != 2) {
            return;
        }
        TIntArrayList rows = this.getSelectedModelRows();
        if (rows.size() != 1) {
            return;
        }
        int row = rows.get(0);
        this.showEditor(row);
        this.scrollRowToVisible(row);
    }

    private void onMouseMoved(@NotNull MouseEvent e2) {
        ArrangementListRowDecorator decorator;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onMouseMoved"));
        }
        int i2 = this.rowAtPoint(e2.getPoint());
        if (i2 != this.myRowUnderMouse) {
            this.onMouseExited();
        }
        if (i2 < 0) {
            return;
        }
        if (i2 != this.myRowUnderMouse) {
            this.onMouseEntered(e2);
        }
        if ((decorator = this.myComponents.get(i2)) == null) {
            return;
        }
        Rectangle rectangle = decorator.onMouseMove(e2);
        if (rectangle != null) {
            this.repaintScreenBounds(rectangle);
        }
    }

    private void repaintScreenBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "repaintScreenBounds"));
        }
        Point location = bounds.getLocation();
        SwingUtilities.convertPointFromScreen(location, (Component)((Object)this));
        int x2 = location.x;
        int width = bounds.width;
        this.repaint(x2, location.y, width, bounds.height);
    }

    private void onMouseReleased(@NotNull MouseEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onMouseReleased"));
        }
        int i2 = this.rowAtPoint(e2.getPoint());
        if (i2 < 0) {
            return;
        }
        ArrangementListRowDecorator decorator = this.myComponents.get(i2);
        if (decorator != null) {
            decorator.onMouseRelease(e2);
        }
        if (!e2.isConsumed() && this.myEditorRow > 0 && this.myEditorRow == i2 + 1) {
            this.hideEditor();
        }
    }

    private void onMouseExited() {
        if (this.myRowUnderMouse < 0) {
            return;
        }
        ArrangementListRowDecorator decorator = this.myComponents.get(this.myRowUnderMouse);
        if (decorator != null) {
            decorator.onMouseExited();
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
        this.myRowUnderMouse = -1;
    }

    private void onMouseEntered(@NotNull MouseEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onMouseEntered"));
        }
        this.myRowUnderMouse = this.rowAtPoint(e2.getPoint());
        ArrangementListRowDecorator decorator = this.myComponents.get(this.myRowUnderMouse);
        if (decorator != null) {
            decorator.onMouseEntered(e2);
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
    }

    public void runOperationIgnoreSelectionChange(@NotNull Runnable task2) {
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "runOperationIgnoreSelectionChange"));
        }
        this.mySkipSelectionChange = true;
        try {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            task2.run();
        }
        finally {
            this.mySkipSelectionChange = false;
            this.refreshEditor();
        }
    }

    private void onSelectionChange(@NotNull ListSelectionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onSelectionChange"));
        }
        if (this.mySkipSelectionChange || e2.getValueIsAdjusting()) {
            return;
        }
        this.refreshEditor();
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < this.myEditorRow) {
            this.hideEditor();
        }
        this.getModel().removeRow(rowIndex);
    }

    public void refreshEditor() {
        ArrangementMatchingRulesModel model2 = this.getModel();
        if (this.myEditorRow >= model2.getSize()) {
            this.myEditorRow = -1;
            int max = model2.getSize();
            for (int i2 = 0; i2 < max; ++i2) {
                if (!(model2.getElementAt(i2) instanceof ArrangementEditorComponent)) continue;
                this.myEditorRow = i2;
                break;
            }
        }
        if (this.myEditorRow < 0) {
            return;
        }
        ListSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.hideEditor();
            return;
        }
        int selectedRow = selectionModel.getMinSelectionIndex();
        if (selectedRow != selectionModel.getMaxSelectionIndex()) {
            this.hideEditor();
            return;
        }
        if (selectedRow != this.myEditorRow && selectedRow != this.myEditorRow - 1) {
            this.hideEditor();
        }
    }

    public void hideEditor() {
        TableCellEditor editor;
        if (this.myEditorRow < 0) {
            return;
        }
        if (this.isEditing() && (editor = this.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        this.mySkipSelectionChange = true;
        try {
            ArrangementMatchingRulesModel model2 = this.getModel();
            model2.removeRow(this.myEditorRow);
            if (this.myEditorRow > 0 && model2.getElementAt(this.myEditorRow - 1) instanceof EmptyArrangementRuleComponent) {
                model2.removeRow(this.myEditorRow - 1);
            }
        }
        finally {
            this.mySkipSelectionChange = false;
        }
        this.myEditorRow = -1;
    }

    private void onTableChange(@NotNull TableModelEvent e2) {
        int signum;
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "onTableChange"));
        }
        switch (e2.getType()) {
            case 1: {
                signum = 1;
                break;
            }
            case -1: {
                signum = -1;
                for (int i2 = e2.getLastRow(); i2 >= e2.getFirstRow(); --i2) {
                    this.myComponents.remove(i2);
                }
                break;
            }
            default: {
                return;
            }
        }
        int shift = Math.abs(e2.getFirstRow() - e2.getLastRow() + 1) * signum;
        this.myComponents.shiftKeys(e2.getFirstRow(), shift);
        if (this.myRowUnderMouse >= e2.getFirstRow()) {
            this.myRowUnderMouse = -1;
        }
        if (this.getModel().getSize() > 0) {
            this.repaintRows(0, this.getModel().getSize() - 1, false);
        }
    }

    public void showEditor(int rowToEdit) {
        this.showEditor(this.myEditor, rowToEdit);
    }

    public void scrollRowToVisible(int row) {
        Rectangle rect = this.getCellRect(row, 0, false);
        if (row != this.getEditingRow() - 1) {
            this.scrollRectToVisible(rect);
        } else {
            Rectangle editorRect = this.getCellRect(row + 1, 0, false);
            if (!rect.isEmpty() && !editorRect.isEmpty()) {
                int height = (int)(rect.getHeight() + editorRect.getHeight());
                Rectangle visibleRect = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), height);
                this.scrollRectToVisible(visibleRect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEditor(@NotNull ArrangementMatchingRuleEditor editor, int rowToEdit) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "showEditor"));
        }
        if (this.myEditorRow == rowToEdit + 1) {
            return;
        }
        if (this.myEditorRow >= 0) {
            if (this.myEditorRow < rowToEdit) {
                --rowToEdit;
            }
            this.hideEditor();
        }
        this.myEditorRow = rowToEdit + 1;
        ArrangementEditorComponent editorComponent = new ArrangementEditorComponent(this, this.myEditorRow, editor);
        int width = this.getBounds().width;
        JScrollPane scrollPane = JBScrollPane.findScrollPane((Component)this.getParent());
        if (scrollPane != null) {
            width -= scrollPane.getVerticalScrollBar().getWidth();
        }
        editorComponent.applyAvailableWidth(width);
        editor.reset(rowToEdit);
        this.mySkipSelectionChange = true;
        try {
            this.getModel().insertRow(this.myEditorRow, new Object[]{editorComponent});
        }
        finally {
            this.mySkipSelectionChange = false;
        }
        Rectangle bounds = this.getRowsBounds(rowToEdit, this.myEditorRow);
        if (bounds != null) {
            this.myRepresentationCallback.ensureVisible(bounds);
        }
        editorComponent.expand();
        this.repaintRows(rowToEdit, this.getModel().getRowCount() - 1, false);
        this.editCellAt(this.myEditorRow, 0);
    }

    public void repaintRows(int first, int last, boolean rowStructureChanged) {
        for (int i2 = first; i2 <= last; ++i2) {
            if (rowStructureChanged) {
                this.myComponents.remove(i2);
                continue;
            }
            this.setRowHeight(i2, this.myRenderer.getRendererComponent((int)i2).getPreferredSize().height);
        }
        this.getModel().fireTableRowsUpdated(first, last);
    }

    private Rectangle getRowsBounds(int first, int last) {
        Rectangle firstRect = this.getCellRect(first, 0, true);
        Rectangle lastRect = this.getCellRect(last, 0, true);
        return new Rectangle(firstRect.x, firstRect.y, lastRect.width, lastRect.y + lastRect.height - firstRect.y);
    }

    @NotNull
    public TIntArrayList getSelectedModelRows() {
        this.mySelectedRows.clear();
        int min = this.selectionModel.getMinSelectionIndex();
        if (min >= 0) {
            for (int i2 = this.selectionModel.getMaxSelectionIndex(); i2 >= min; --i2) {
                if ((this.myEditorRow < 0 || i2 != this.myEditorRow - 1) && (i2 == this.myEditorRow || !this.selectionModel.isSelectedIndex(i2))) continue;
                this.mySelectedRows.add(i2);
            }
        } else if (this.myEditorRow > 0) {
            this.mySelectedRows.add(this.myEditorRow - 1);
        }
        TIntArrayList tIntArrayList = this.mySelectedRows;
        if (tIntArrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "getSelectedModelRows"));
        }
        return tIntArrayList;
    }

    public int getRowByRenderer(@NotNull ArrangementListRowDecorator renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "getRowByRenderer"));
        }
        int max = this.getModel().getSize();
        for (int i2 = 0; i2 < max; ++i2) {
            if (this.myComponents.get(i2) != renderer) continue;
            return i2;
        }
        return -1;
    }

    public int getEmptyRowHeight() {
        return this.myMinRowHeight;
    }

    @NotNull
    private JComponent adjustHeight(@NotNull JComponent component, int row) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "adjustHeight"));
        }
        int height = component.getPreferredSize().height;
        if (height < this.myMinRowHeight) {
            height = this.myMinRowHeight;
        }
        this.setRowHeight(row, height);
        JComponent jComponent = component;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl", "adjustHeight"));
        }
        return jComponent;
    }

    public static interface RepresentationCallback {
        public void ensureVisible(@NotNull Rectangle var1);
    }

    private class MyEditor
    extends AbstractTableCellEditor {
        private int myRow;

        private MyEditor() {
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
            if (value2 instanceof ArrangementEditorAware) {
                this.myRow = row;
                return ((ArrangementEditorAware)value2).getComponent();
            }
            return null;
        }

        public Object getCellEditorValue() {
            return this.myRow < ArrangementMatchingRulesControl.this.getModel().getSize() ? ArrangementMatchingRulesControl.this.getModel().getElementAt(this.myRow) : null;
        }
    }

    protected class MatchingRulesRendererBase
    implements TableCellRenderer {
        protected MatchingRulesRendererBase() {
        }

        public Component getRendererComponent(int row) {
            return this.getTableCellRendererComponent((JTable)((Object)ArrangementMatchingRulesControl.this), ArrangementMatchingRulesControl.this.getModel().getElementAt(row), false, false, row, 0);
        }

        public boolean allowModifications(StdArrangementMatchRule rule) {
            return true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (ArrangementMatchingRulesControl.this.isEditing() && ArrangementMatchingRulesControl.this.getEditingRow() == row) {
                return EMPTY_RENDERER;
            }
            if (value2 instanceof ArrangementRepresentationAware) {
                return ArrangementMatchingRulesControl.this.adjustHeight(((ArrangementRepresentationAware)value2).getComponent(), row);
            }
            ArrangementListRowDecorator component = ArrangementMatchingRulesControl.this.myComponents.get(row);
            if (component == null) {
                if (!(value2 instanceof StdArrangementMatchRule)) {
                    return EMPTY_RENDERER;
                }
                StdArrangementMatchRule rule = (StdArrangementMatchRule)value2;
                boolean allowModifications = this.allowModifications(rule);
                ArrangementUiComponent ruleComponent = ArrangementMatchingRulesControl.this.myFactory.getComponent(rule.getMatcher().getCondition(), rule, allowModifications);
                component = new ArrangementListRowDecorator(ruleComponent, ArrangementMatchingRulesControl.this);
                component.setError(ArrangementMatchingRulesControl.this.getValidator().validate(row));
                ArrangementMatchingRulesControl.this.myComponents.set(row, component);
            }
            component.setUnderMouse(ArrangementMatchingRulesControl.this.myRowUnderMouse == row);
            component.setRowIndex(ArrangementMatchingRulesControl.this.myEditorRow >= 0 && row > ArrangementMatchingRulesControl.this.myEditorRow ? row : row + 1);
            component.setSelected(ArrangementMatchingRulesControl.this.getSelectionModel().isSelectedIndex(row) || ArrangementMatchingRulesControl.this.myEditorRow >= 0 && row == ArrangementMatchingRulesControl.this.myEditorRow - 1);
            component.setBeingEdited(ArrangementMatchingRulesControl.this.myEditorRow >= 0 && ArrangementMatchingRulesControl.this.myEditorRow == row + 1);
            boolean showSortIcon = value2 instanceof StdArrangementMatchRule && StdArrangementTokens.Order.BY_NAME.equals((Object)((StdArrangementMatchRule)value2).getOrderType());
            component.setShowSortIcon(showSortIcon);
            return component.getUiComponent();
        }
    }
}

