/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesControl;
import com.intellij.application.options.codeStyle.arrangement.util.TitleWithToolbar;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementMatchingRulesPanel
extends JPanel
implements DataProvider {
    @NotNull
    protected final ArrangementSectionRulesControl myControl;

    public ArrangementMatchingRulesPanel(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "<init>"));
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "<init>"));
        }
        super(new GridBagLayout());
        JBScrollPane scrollPane = new JBScrollPane();
        final JViewport viewport = scrollPane.getViewport();
        ArrangementMatchingRulesControl.RepresentationCallback callback = new ArrangementMatchingRulesControl.RepresentationCallback(){

            @Override
            public void ensureVisible(@NotNull Rectangle r2) {
                if (r2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel$1", "ensureVisible"));
                }
                Rectangle visibleRect = viewport.getViewRect();
                if (r2.y <= visibleRect.y) {
                    return;
                }
                int excessiveHeight = r2.y + r2.height - (visibleRect.y + visibleRect.height);
                if (excessiveHeight <= 0) {
                    return;
                }
                int verticalShift = Math.min(r2.y - visibleRect.y, excessiveHeight);
                if (verticalShift > 0) {
                    viewport.setViewPosition(new Point(visibleRect.x, visibleRect.y + verticalShift));
                }
            }
        };
        this.myControl = this.createRulesControl(language, settingsManager, colorsProvider, callback);
        scrollPane.setViewportView((Component)((Object)this.myControl));
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myControl), "Arrangement.Rule.Match.Control.Context.Menu", "Arrangement.Rule.Match.Control.Place");
        TitleWithToolbar top = new TitleWithToolbar(ApplicationBundle.message((String)"arrangement.settings.section.match", (Object[])new Object[0]), "Arrangement.Rule.Match.Control.ToolBar", "Arrangement.Rule.Match.Control.ToolBar.Place", (JComponent)((Object)this.myControl));
        this.add((Component)top, new GridBag().coverLine().fillCellHorizontally().weightx(1.0));
        this.add((Component)scrollPane, new GridBag().fillCell().weightx(1.0).weighty(1.0).insets(0, 8, 0, 0));
    }

    protected ArrangementSectionRulesControl createRulesControl(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementMatchingRulesControl.RepresentationCallback callback) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "createRulesControl"));
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "createRulesControl"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "createRulesControl"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "createRulesControl"));
        }
        return new ArrangementSectionRulesControl(language, settingsManager, colorsProvider, callback);
    }

    @NotNull
    public List<ArrangementSectionRule> getSections() {
        List<ArrangementSectionRule> list2 = this.myControl.getSections();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesPanel", "getSections"));
        }
        return list2;
    }

    public void setSections(@Nullable List<ArrangementSectionRule> rules) {
        this.myControl.setSections(rules);
    }

    @Nullable
    public Collection<StdArrangementRuleAliasToken> getRulesAliases() {
        return this.myControl.getRulesAliases();
    }

    public void setRulesAliases(@Nullable Collection<StdArrangementRuleAliasToken> aliases) {
        this.myControl.setRulesAliases(aliases);
    }

    public void hideEditor() {
        this.myControl.hideEditor();
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (ArrangementSectionRulesControl.KEY.is(dataId)) {
            return this.myControl;
        }
        return null;
    }
}

