/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match.tokens;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedItemsListEditor;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import gnu.trove.Equality;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Verifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementRuleAliasesListEditor
extends NamedItemsListEditor<StdArrangementRuleAliasToken> {
    private static final Namer<StdArrangementRuleAliasToken> NAMER = new Namer<StdArrangementRuleAliasToken>(){

        public String getName(StdArrangementRuleAliasToken token) {
            return token.getName();
        }

        public boolean canRename(StdArrangementRuleAliasToken item) {
            return false;
        }

        public void setName(StdArrangementRuleAliasToken token, String name) {
            token.setTokenName(name.replaceAll("\\s+", " "));
        }
    };
    private static final Factory<StdArrangementRuleAliasToken> FACTORY = () -> new StdArrangementRuleAliasToken("");
    private static final Cloner<StdArrangementRuleAliasToken> CLONER = new Cloner<StdArrangementRuleAliasToken>(){

        public StdArrangementRuleAliasToken cloneOf(StdArrangementRuleAliasToken original) {
            return this.copyOf(original);
        }

        public StdArrangementRuleAliasToken copyOf(StdArrangementRuleAliasToken original) {
            return new StdArrangementRuleAliasToken(original.getName(), original.getDefinitionRules());
        }
    };
    private static final Equality<StdArrangementRuleAliasToken> COMPARER = new Equality<StdArrangementRuleAliasToken>(){

        public boolean equals(StdArrangementRuleAliasToken o1, StdArrangementRuleAliasToken o2) {
            return Comparing.equal((String)o1.getId(), (String)o2.getId());
        }
    };
    @NotNull
    private Set<String> myUsedTokenIds;
    @NotNull
    private ArrangementStandardSettingsManager mySettingsManager;
    @NotNull
    private ArrangementColorsProvider myColorsProvider;

    protected ArrangementRuleAliasesListEditor(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull List<StdArrangementRuleAliasToken> items2, @NotNull Set<String> usedTokenIds) {
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesListEditor", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesListEditor", "<init>"));
        }
        if (items2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesListEditor", "<init>"));
        }
        if (usedTokenIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedTokenIds", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesListEditor", "<init>"));
        }
        super(NAMER, FACTORY, CLONER, COMPARER, items2, false);
        this.mySettingsManager = settingsManager;
        this.myColorsProvider = colorsProvider;
        this.myUsedTokenIds = usedTokenIds;
        this.reset();
        this.initTree();
    }

    protected UnnamedConfigurable createConfigurable(StdArrangementRuleAliasToken item) {
        return new ArrangementRuleAliasConfigurable(this.mySettingsManager, this.myColorsProvider, item);
    }

    protected boolean canDelete(StdArrangementRuleAliasToken item) {
        return !this.myUsedTokenIds.contains(item.getId());
    }

    @Nls
    public String getDisplayName() {
        return "Custom Composite Tokens";
    }

    @Nullable
    public String askForProfileName(String titlePattern) {
        String title = MessageFormat.format(titlePattern, this.subjDisplayName());
        return Messages.showInputDialog((String)("New " + this.subjDisplayName() + " name:"), (String)title, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String s2) {
                return s2.length() > 0 && ArrangementRuleAliasesListEditor.this.findByName(s2) == null && Verifier.checkElementName((String)s2) == null;
            }

            public boolean canClose(String s2) {
                return this.checkInput(s2);
            }
        });
    }
}

