/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match.tokens;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesControl;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasControl;
import com.intellij.application.options.codeStyle.arrangement.util.TitleWithToolbar;
import com.intellij.ide.ui.customization.CustomizationUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementRuleAliasesPanel
extends JPanel
implements DataProvider {
    @NotNull
    protected final ArrangementRuleAliasControl myControl;

    public ArrangementRuleAliasesPanel(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider) {
        if (settingsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsManager", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesPanel", "<init>"));
        }
        if (colorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsProvider", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesPanel", "<init>"));
        }
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JBScrollPane scrollPane = new JBScrollPane();
        final JViewport viewport = scrollPane.getViewport();
        ArrangementMatchingRulesControl.RepresentationCallback callback = new ArrangementMatchingRulesControl.RepresentationCallback(){

            @Override
            public void ensureVisible(@NotNull Rectangle r2) {
                if (r2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesPanel$1", "ensureVisible"));
                }
                Rectangle visibleRect = viewport.getViewRect();
                if (r2.y <= visibleRect.y) {
                    return;
                }
                int excessiveHeight = r2.y + r2.height - (visibleRect.y + visibleRect.height);
                if (excessiveHeight <= 0) {
                    return;
                }
                int verticalShift = Math.min(r2.y - visibleRect.y, excessiveHeight);
                if (verticalShift > 0) {
                    viewport.setViewPosition(new Point(visibleRect.x, visibleRect.y + verticalShift));
                }
            }
        };
        this.myControl = new ArrangementRuleAliasControl(settingsManager, colorsProvider, callback);
        scrollPane.setViewportView((Component)((Object)this.myControl));
        CustomizationUtil.installPopupHandler((JComponent)((Object)this.myControl), "Arrangement.Alias.Rule.Context.Menu", "Arrangement.Alias.Rule.Control.Place");
        TitleWithToolbar top = new TitleWithToolbar(ApplicationBundle.message((String)"arrangement.settings.section.rule.sequence", (Object[])new Object[0]), "Arrangement.Alias.Rule.ToolBar", "Arrangement.Alias.Rule.ToolBar.Place", (JComponent)((Object)this.myControl));
        this.add((Component)top, new GridBag().coverLine().fillCellHorizontally().weightx(1.0));
        this.add((Component)scrollPane, new GridBag().fillCell().weightx(1.0).weighty(1.0).insets(0, 8, 0, 0));
    }

    @NotNull
    public List<StdArrangementMatchRule> getRuleSequences() {
        List<StdArrangementMatchRule> list2 = this.myControl.getRuleSequences();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesPanel", "getRuleSequences"));
        }
        return list2;
    }

    public void setRuleSequences(@Nullable Collection<StdArrangementMatchRule> rules) {
        this.myControl.setRuleSequences(rules);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (ArrangementRuleAliasControl.KEY.is(dataId)) {
            return this.myControl;
        }
        return null;
    }
}

