/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.util;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CalloutBorder
implements Border {
    @NotNull
    private static final Insets INSETS = new Insets(10, 8, 4, 8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        Color oldColor = g2.getColor();
        g2.setColor(UIUtil.getBorderColor());
        Graphics2D g22 = (Graphics2D)g2;
        Object oldHint = g22.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            CalloutBorder.doPaint(c2, g2, x2, y2, width, height);
        }
        finally {
            g2.setColor(oldColor);
            g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
        }
    }

    private static void doPaint(Component c2, Graphics g2, int x2, int y2, int width, int height) {
        g2.drawLine(x2 + CalloutBorder.INSETS.left - 1, y2 + CalloutBorder.INSETS.top - 1, x2 + CalloutBorder.INSETS.left - 1, y2 + height - CalloutBorder.INSETS.bottom - 1);
        g2.drawLine(x2 + CalloutBorder.INSETS.left - 1, y2 + height - CalloutBorder.INSETS.bottom, x2 + width - CalloutBorder.INSETS.right, y2 + height - CalloutBorder.INSETS.bottom);
        g2.drawLine(x2 + width - CalloutBorder.INSETS.right, y2 + height - CalloutBorder.INSETS.bottom - 1, x2 + width - CalloutBorder.INSETS.right, y2 + CalloutBorder.INSETS.top - 1);
        int calloutWidth = CalloutBorder.INSETS.top * 3 / 2;
        if (calloutWidth % 2 != 0) {
            ++calloutWidth;
        }
        int hPadding = CalloutBorder.INSETS.left + CalloutBorder.INSETS.right;
        int leftTopWidth = (width - hPadding - calloutWidth) / 2;
        g2.drawLine(x2 + CalloutBorder.INSETS.left - 1, y2 + CalloutBorder.INSETS.top - 1, x2 + CalloutBorder.INSETS.left - 1 + leftTopWidth, y2 + CalloutBorder.INSETS.top - 1);
        int rightTopWidth = width - leftTopWidth - hPadding - calloutWidth;
        g2.drawLine(x2 + width - rightTopWidth - CalloutBorder.INSETS.right, y2 + CalloutBorder.INSETS.top - 1, x2 + width - CalloutBorder.INSETS.right, y2 + CalloutBorder.INSETS.top - 1);
        g2.drawLine(x2 + CalloutBorder.INSETS.left - 1 + leftTopWidth, y2 + CalloutBorder.INSETS.top - 1, x2 + CalloutBorder.INSETS.left - 1 + leftTopWidth + calloutWidth / 2, 0);
        g2.drawLine(x2 + CalloutBorder.INSETS.left - 1 + leftTopWidth + calloutWidth / 2, 0, x2 + width - rightTopWidth - CalloutBorder.INSETS.right, y2 + CalloutBorder.INSETS.top - 1);
    }

    @Override
    public Insets getBorderInsets(Component c2) {
        return (Insets)INSETS.clone();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

