/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ImportHandler;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemesPanel;
import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ColorSchemeActions
extends AbstractSchemeActions<EditorColorsScheme> {
    protected ColorSchemeActions(@NotNull AbstractSchemesPanel<EditorColorsScheme, ?> schemesPanel) {
        if (schemesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesPanel", "com/intellij/application/options/colors/ColorSchemeActions", "<init>"));
        }
        super(schemesPanel);
    }

    @Override
    protected Collection<String> getSchemeImportersNames() {
        ArrayList<String> importersNames = new ArrayList<String>();
        for (ImportHandler importHandler : (ImportHandler[])Extensions.getExtensions(ImportHandler.EP_NAME)) {
            importersNames.add(importHandler.getTitle());
        }
        importersNames.addAll(super.getSchemeImportersNames());
        return importersNames;
    }

    @Override
    protected void importScheme(@NotNull String importerName) {
        VirtualFile importSource;
        if (importerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importerName", "com/intellij/application/options/colors/ColorSchemeActions", "importScheme"));
        }
        if (this.tryImportWithImportHandler(importerName)) {
            return;
        }
        SchemeImporter<EditorColorsScheme> importer = SchemeImporterEP.getImporter(importerName, EditorColorsScheme.class);
        if (importer != null && (importSource = SchemeImportUtil.selectImportSource(importer.getSourceExtensions(), this.getSchemesPanel(), null, "Choose " + importerName)) != null) {
            try {
                EditorColorsScheme imported = (EditorColorsScheme)importer.importScheme(DefaultProjectFactory.getInstance().getDefaultProject(), importSource, (Scheme)this.getOptions().getSelectedScheme(), name -> {
                    String newName = SchemeNameGenerator.getUniqueName(name != null ? name : "Unnamed", candidate -> this.getSchemesPanel().getModel().containsScheme((String)candidate, false));
                    EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(EmptyColorScheme.INSTANCE);
                    newScheme.setName(newName);
                    newScheme.setDefaultMetaInfo(EmptyColorScheme.INSTANCE);
                    return newScheme;
                });
                if (imported != null) {
                    this.getOptions().addImportedScheme(imported);
                    this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"settings.editor.scheme.import.success", (Object[])new Object[]{importSource.getPresentableUrl(), imported.getName()}), MessageType.INFO);
                }
            }
            catch (SchemeImportException e2) {
                this.getSchemesPanel().showStatus(ApplicationBundle.message((String)"settings.editor.scheme.import.failure", (Object[])new Object[]{importSource.getPresentableUrl()}), MessageType.ERROR);
            }
        }
    }

    private boolean tryImportWithImportHandler(@NotNull String importerName) {
        if (importerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importerName", "com/intellij/application/options/colors/ColorSchemeActions", "tryImportWithImportHandler"));
        }
        for (ImportHandler importHandler : (ImportHandler[])Extensions.getExtensions(ImportHandler.EP_NAME)) {
            if (!importerName.equals(importHandler.getTitle())) continue;
            importHandler.performImport(this.getSchemesPanel().getToolbar(), (Consumer<EditorColorsScheme>)((Consumer)scheme2 -> {
                if (scheme2 != null) {
                    this.getOptions().addImportedScheme((EditorColorsScheme)scheme2);
                }
            }));
            return true;
        }
        return false;
    }

    @Override
    protected void resetScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorSchemeActions", "resetScheme"));
        }
        if (Messages.showOkCancelDialog((String)ApplicationBundle.message((String)"color.scheme.reset.message", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"color.scheme.reset.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            this.getOptions().resetSchemeToOriginal(scheme2.getName());
        }
    }

    @Override
    protected void duplicateScheme(@NotNull EditorColorsScheme scheme2, @NotNull String newName) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorSchemeActions", "duplicateScheme"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/application/options/colors/ColorSchemeActions", "duplicateScheme"));
        }
        this.getOptions().saveSchemeAs(scheme2, newName);
    }

    @Override
    protected void exportScheme(@NotNull EditorColorsScheme scheme2, @NotNull String exporterName) {
        if (scheme2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/ColorSchemeActions", "exportScheme"));
        }
        if (exporterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporterName", "com/intellij/application/options/colors/ColorSchemeActions", "exportScheme"));
        }
    }

    @Override
    protected Class<EditorColorsScheme> getSchemeType() {
        return EditorColorsScheme.class;
    }

    @NotNull
    protected abstract ColorAndFontOptions getOptions();
}

