/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class FileStatusColorsPageFactory
implements ColorAndFontPanelFactory {
    FileStatusColorsPageFactory() {
    }

    @Override
    @NotNull
    public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/FileStatusColorsPageFactory", "createPanel"));
        }
        NewColorAndFontPanel panel2 = NewColorAndFontPanel.create(new PreviewPanel.Empty(), ColorAndFontOptions.FILE_STATUS_GROUP, options, FileStatusColorsPageFactory.collectFileTypes(), null);
        panel2.setEmptyText("Not available", "File status options are not available for the scheme.\nChoose 'Default' or 'Darcula'.");
        NewColorAndFontPanel newColorAndFontPanel = panel2;
        if (newColorAndFontPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/FileStatusColorsPageFactory", "createPanel"));
        }
        return newColorAndFontPanel;
    }

    @Override
    @NotNull
    public String getPanelDisplayName() {
        String string2 = ColorAndFontOptions.FILE_STATUS_GROUP;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/FileStatusColorsPageFactory", "getPanelDisplayName"));
        }
        return string2;
    }

    private static Collection<String> collectFileTypes() {
        FileStatus[] statuses;
        ArrayList<String> result2 = new ArrayList<String>();
        for (FileStatus status : statuses = FileStatusFactory.getInstance().getAllFileStatuses()) {
            result2.add(status.getText());
        }
        return result2;
    }
}

