/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.RainbowAttributeDescriptor;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class RainbowDescriptionPanel
extends JPanel
implements OptionsPanelImpl.ColorDescriptionPanel {
    private final EventDispatcher<OptionsPanelImpl.ColorDescriptionPanel.Listener> myDispatcher;
    protected JPanel myPanel;
    private JTextPane myGradientLabel;
    private JBLabel myLStop1;
    private JBLabel myLStop2;
    private JBLabel myLStop3;
    private JBLabel myLStop4;
    private JBLabel myLStop5;
    private JBLabel[] myLStops;
    protected ColorPanel myStop1;
    protected ColorPanel myStop2;
    protected ColorPanel myStop3;
    protected ColorPanel myStop4;
    protected ColorPanel myStop5;
    private ColorPanel[] myStops;
    private JBCheckBox myRainbow;
    private JTextPane myInheritanceLabel;
    private JBCheckBox myInheritAttributesBox;
    private final String myInheritedMessage;
    private final String myOverrideMessage;
    private final String myInheritedMessageTooltip;

    public RainbowDescriptionPanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(OptionsPanelImpl.ColorDescriptionPanel.Listener.class);
        this.myLStops = new JBLabel[]{this.myLStop1, this.myLStop2, this.myLStop3, this.myLStop4, this.myLStop5};
        this.myStops = new ColorPanel[]{this.myStop1, this.myStop2, this.myStop3, this.myStop4, this.myStop5};
        this.add((Component)this.myPanel, "Center");
        this.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)4, (int)4));
        ActionListener actionListener = e2 -> ((OptionsPanelImpl.ColorDescriptionPanel.Listener)this.myDispatcher.getMulticaster()).onSettingsChanged(e2);
        for (JBCheckBox jBCheckBox : new JBCheckBox[]{this.myRainbow, this.myInheritAttributesBox}) {
            jBCheckBox.addActionListener(actionListener);
        }
        for (JBCheckBox jBCheckBox : new ColorPanel[]{this.myStop1, this.myStop2, this.myStop3, this.myStop4, this.myStop5}) {
            jBCheckBox.addActionListener(actionListener);
        }
        String languageDefaultPageID = OptionsBundle.message((String)"options.language.defaults.display.name", (Object[])new Object[0]);
        String rainbowOptionsID = ApplicationBundle.message((String)"rainbow.option.panel.display.name", (Object[])new Object[0]);
        this.myInheritedMessage = ApplicationBundle.message((String)"label.inherited.gradient", (Object[])new Object[]{rainbowOptionsID, languageDefaultPageID});
        this.myInheritedMessageTooltip = RainbowDescriptionPanel.checkRightArrow(ApplicationBundle.message((String)"label.inherited.gradient.tooltip", (Object[])new Object[]{rainbowOptionsID, languageDefaultPageID}));
        this.myOverrideMessage = ApplicationBundle.message((String)"label.override.gradient", (Object[])new Object[0]);
        HyperlinkListener listener2 = e2 -> ((OptionsPanelImpl.ColorDescriptionPanel.Listener)this.myDispatcher.getMulticaster()).onHyperLinkClicked(e2);
        Messages.configureMessagePaneUi((JTextPane)this.myGradientLabel, (String)this.myOverrideMessage, null);
        this.myGradientLabel.addHyperlinkListener(listener2);
        Messages.configureMessagePaneUi((JTextPane)this.myInheritanceLabel, (String)RainbowDescriptionPanel.checkRightArrow(ApplicationBundle.message((String)"label.rainbow.inheritance", (Object[])new Object[]{rainbowOptionsID, rainbowOptionsID, languageDefaultPageID})), null);
        this.myInheritanceLabel.setToolTipText(RainbowDescriptionPanel.checkRightArrow(ApplicationBundle.message((String)"label.rainbow.inheritance.tooltip", (Object[])new Object[]{rainbowOptionsID, languageDefaultPageID})));
        this.myInheritanceLabel.addHyperlinkListener(listener2);
        this.myInheritanceLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)4, (int)4));
    }

    @NotNull
    private static String checkRightArrow(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/application/options/colors/RainbowDescriptionPanel", "checkRightArrow"));
        }
        String string2 = str.replaceAll("->", FontUtil.rightArrow((Font)UIUtil.getLabelFont()));
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/RainbowDescriptionPanel", "checkRightArrow"));
        }
        return string2;
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        RainbowDescriptionPanel rainbowDescriptionPanel = this;
        if (rainbowDescriptionPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/RainbowDescriptionPanel", "getPanel"));
        }
        return rainbowDescriptionPanel;
    }

    @Override
    public void resetDefault() {
    }

    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor attributeDescriptor) {
        boolean isEnable;
        if (attributeDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeDescriptor", "com/intellij/application/options/colors/RainbowDescriptionPanel", "reset"));
        }
        if (!(attributeDescriptor instanceof RainbowAttributeDescriptor)) {
            return;
        }
        RainbowAttributeDescriptor descriptor2 = (RainbowAttributeDescriptor)attributeDescriptor;
        EditorColorsScheme editedColorsScheme = descriptor2.getScheme();
        Boolean rainbowOn = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)editedColorsScheme, descriptor2.getLanguage());
        boolean isInherited = false;
        boolean isDefaultLanguage = descriptor2.getLanguage() == null;
        boolean bl = isEnable = !ColorAndFontOptions.isReadOnly(editedColorsScheme);
        if (rainbowOn == null) {
            isInherited = true;
            rainbowOn = RainbowHighlighter.isRainbowEnabled((TextAttributesScheme)editedColorsScheme, null);
        }
        this.myRainbow.setEnabled(isEnable && !isInherited);
        this.myRainbow.setSelected(rainbowOn.booleanValue());
        for (int i2 = 0; i2 < this.myLStops.length; ++i2) {
            this.myLStops[i2].setEnabled(isEnable && isDefaultLanguage);
            this.myStops[i2].setEnabled(rainbowOn.booleanValue());
            this.myStops[i2].setEditable(isEnable && isDefaultLanguage);
            this.myStops[i2].setSelectedColor(editedColorsScheme.getAttributes(RainbowHighlighter.RAINBOW_COLOR_KEYS[i2]).getForegroundColor());
        }
        this.myInheritanceLabel.setVisible(!isDefaultLanguage);
        this.myInheritAttributesBox.setEnabled(isEnable);
        this.myInheritAttributesBox.setSelected(isInherited);
        this.myInheritAttributesBox.setVisible(!isDefaultLanguage);
        this.myGradientLabel.setText(isDefaultLanguage ? this.myOverrideMessage : this.myInheritedMessage);
        this.myGradientLabel.setToolTipText(isDefaultLanguage ? null : this.myInheritedMessageTooltip);
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor attributeDescriptor, EditorColorsScheme scheme2) {
        if (attributeDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeDescriptor", "com/intellij/application/options/colors/RainbowDescriptionPanel", "apply"));
        }
        if (!(attributeDescriptor instanceof RainbowAttributeDescriptor)) {
            return;
        }
        RainbowAttributeDescriptor descriptor2 = (RainbowAttributeDescriptor)attributeDescriptor;
        boolean isDefaultLanguage = descriptor2.getLanguage() == null;
        RainbowHighlighter.setRainbowEnabled((SchemeMetaInfo)scheme2, descriptor2.getLanguage(), (Boolean)(isDefaultLanguage ? Boolean.valueOf(this.myRainbow.isSelected()) : (this.myInheritAttributesBox.isSelected() ? null : Boolean.valueOf(this.myRainbow.isSelected()))));
        for (int i2 = 0; i2 < this.myStops.length; ++i2) {
            scheme2.setAttributes(RainbowHighlighter.RAINBOW_COLOR_KEYS[i2], RainbowHighlighter.createRainbowAttribute(this.myStops[i2].getSelectedColor()));
        }
        descriptor2.apply(scheme2);
    }

    @Override
    public void addListener(@NotNull OptionsPanelImpl.ColorDescriptionPanel.Listener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/application/options/colors/RainbowDescriptionPanel", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JTextPane jTextPane;
        JBCheckBox jBCheckBox;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        ColorPanel colorPanel3;
        ColorPanel colorPanel4;
        ColorPanel colorPanel5;
        JTextPane jTextPane2;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 10, 10, 10), -1, -1, false, false));
        this.myRainbow = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setVerticalTextPosition(1);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.rainbow"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 3, 9, 0, 0, 0, null, null, null));
        this.myGradientLabel = jTextPane2 = new JTextPane();
        jTextPane2.setText(ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.override.gradient"));
        jPanel.add((Component)jTextPane2, new GridConstraints(1, 0, 1, 3, 9, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myStop1 = colorPanel5 = new ColorPanel();
        jPanel.add((Component)colorPanel5, new GridConstraints(2, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myStop2 = colorPanel4 = new ColorPanel();
        jPanel.add((Component)colorPanel4, new GridConstraints(3, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myStop3 = colorPanel3 = new ColorPanel();
        jPanel.add((Component)colorPanel3, new GridConstraints(4, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myStop4 = colorPanel2 = new ColorPanel();
        jPanel.add((Component)colorPanel2, new GridConstraints(5, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myStop5 = colorPanel = new ColorPanel();
        jPanel.add((Component)colorPanel, new GridConstraints(6, 2, 1, 1, 4, 2, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(7, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(30, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(7, 0, 1, 3, 0, 3, 0, 0, null, null, null, 0, true));
        this.myInheritAttributesBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.inherit.attributes"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInheritanceLabel = jTextPane = new JTextPane();
        jTextPane.setText("labl");
        jPanel2.add((Component)jTextPane, new GridConstraints(1, 1, 1, 1, 0, 3, 0, 0, null, null, null));
        this.myLStop1 = jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.1"));
        jPanel.add((Component)jBLabel5, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLStop2 = jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.2"));
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLStop3 = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.3"));
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLStop4 = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.4"));
        jPanel.add((Component)jBLabel2, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLStop5 = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.stop.5"));
        jPanel.add((Component)jBLabel, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

