/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.application.options.colors.highlighting.InlineElementData;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class HighlightsExtractor {
    private final Map<String, TextAttributesKey> myTags;
    private final Map<String, TextAttributesKey> myInlineElements;
    private int myStartOffset;
    private int myEndOffset;
    private int mySkippedLen;
    private int myIndex;
    private boolean myIsOpeningTag;
    private List<TextRange> mySkipped = new ArrayList<TextRange>();

    public HighlightsExtractor(@Nullable Map<String, TextAttributesKey> tags) {
        this(tags, null);
    }

    public HighlightsExtractor(@Nullable Map<String, TextAttributesKey> tags, @Nullable Map<String, TextAttributesKey> inlineElements) {
        this.myTags = tags;
        this.myInlineElements = inlineElements;
    }

    public String extractHighlights(String text2, List<HighlightData> highlights) {
        String tagName2;
        this.mySkipped.clear();
        if (ContainerUtil.isEmpty(this.myTags) && ContainerUtil.isEmpty(this.myInlineElements)) {
            return text2;
        }
        this.resetIndices();
        Stack highlightsStack = new Stack();
        while ((tagName2 = this.findTagName(text2)) != null && this.myIndex >= 0) {
            HighlightData highlightData;
            String tagNameWithoutParameters = StringUtil.substringBefore((String)tagName2, (String)" ");
            if (this.myInlineElements != null && tagNameWithoutParameters != null && this.myInlineElements.containsKey(tagNameWithoutParameters)) {
                this.mySkippedLen += tagName2.length() + 2;
                String hintText = tagName2.substring(tagNameWithoutParameters.length()).trim();
                highlights.add(new InlineElementData(this.myStartOffset - this.mySkippedLen, this.myInlineElements.get(tagNameWithoutParameters), hintText));
                continue;
            }
            if (this.myTags == null || !this.myTags.containsKey(tagName2)) continue;
            if (this.myIsOpeningTag) {
                this.mySkippedLen += tagName2.length() + 2;
                highlightData = new HighlightData(this.myStartOffset - this.mySkippedLen, this.myTags.get(tagName2));
                highlightsStack.push((Object)highlightData);
                continue;
            }
            highlightData = (HighlightData)highlightsStack.pop();
            highlightData.setEndOffset(this.myEndOffset - this.mySkippedLen);
            this.mySkippedLen += tagName2.length() + 3;
            highlights.add(highlightData);
        }
        return this.cutDefinedTags(text2);
    }

    private String findTagName(String text2) {
        this.myIsOpeningTag = true;
        int openTag = text2.indexOf(60, this.myIndex);
        if (openTag == -1) {
            return null;
        }
        while (text2.charAt(openTag + 1) == '<') {
            ++openTag;
        }
        if (text2.charAt(openTag + 1) == '/') {
            this.myIsOpeningTag = false;
            ++openTag;
        }
        if (!HighlightsExtractor.isValidTagFirstChar(text2.charAt(openTag + 1))) {
            this.myIndex = openTag + 1;
            return "";
        }
        int closeTag = text2.indexOf(62, openTag + 1);
        if (closeTag == -1) {
            return null;
        }
        int i2 = text2.indexOf(60, openTag + 1);
        if (i2 != -1 && i2 < closeTag) {
            this.myIndex = i2;
            return "";
        }
        String tagName2 = text2.substring(openTag + 1, closeTag);
        if (this.myIsOpeningTag) {
            this.myStartOffset = openTag + tagName2.length() + 2;
            if (this.myTags != null && this.myTags.containsKey(tagName2) || this.myInlineElements != null && this.myInlineElements.containsKey(StringUtil.substringBefore((String)tagName2, (String)" "))) {
                this.mySkipped.add(TextRange.from((int)openTag, (int)(tagName2.length() + 2)));
            }
        } else {
            this.myEndOffset = openTag - 1;
            if (this.myTags != null && this.myTags.containsKey(tagName2)) {
                this.mySkipped.add(TextRange.from((int)(openTag - 1), (int)(tagName2.length() + 3)));
            }
        }
        this.myIndex = Math.max(this.myStartOffset, this.myEndOffset + 1);
        return tagName2;
    }

    private static boolean isValidTagFirstChar(char c2) {
        return Character.isLetter(c2) || c2 == '_';
    }

    private String cutDefinedTags(String text2) {
        StringBuilder builder = new StringBuilder(text2);
        for (int i2 = this.mySkipped.size() - 1; i2 >= 0; --i2) {
            TextRange range = this.mySkipped.get(i2);
            builder.delete(range.getStartOffset(), range.getEndOffset());
        }
        return builder.toString();
    }

    private void resetIndices() {
        this.myIndex = 0;
        this.myStartOffset = 0;
        this.myEndOffset = 0;
        this.mySkippedLen = 0;
    }
}

