/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors.highlighting;

import com.intellij.application.options.colors.highlighting.HighlightData;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class InlineElementData
extends HighlightData {
    private final String myText;
    private boolean myAddBorder;

    public InlineElementData(int offset, TextAttributesKey attributesKey, String text2) {
        this(offset, attributesKey, text2, false);
    }

    private InlineElementData(int offset, TextAttributesKey attributesKey, String text2, boolean highlighted) {
        super(offset, offset, attributesKey);
        this.myText = text2;
        this.myAddBorder = highlighted;
    }

    public String getText() {
        return this.myText;
    }

    @Override
    public void addHighlToView(Editor view2, EditorColorsScheme scheme2, Map<TextAttributesKey, String> displayText) {
        int offset = this.getStartOffset();
        ParameterHintsPresentationManager.getInstance().addHint(view2, offset, this.myText, false);
        List inlays = view2.getInlayModel().getInlineElementsInRange(offset, offset);
        for (Inlay inlay : inlays) {
            EditorCustomElementRenderer renderer = inlay.getRenderer();
            if (renderer instanceof RendererWrapper) continue;
            Disposer.dispose((Disposable)inlay);
            RendererWrapper wrapper = new RendererWrapper(renderer);
            wrapper.drawBorder = this.myAddBorder;
            view2.getInlayModel().addInlineElement(offset, (EditorCustomElementRenderer)wrapper);
        }
    }

    @Override
    public void addToCollection(@NotNull Collection<HighlightData> list2, boolean highlighted) {
        if (list2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/application/options/colors/highlighting/InlineElementData", "addToCollection"));
        }
        list2.add(new InlineElementData(this.getStartOffset(), this.getHighlightKey(), this.myText, highlighted));
    }

    public static class RendererWrapper
    implements EditorCustomElementRenderer {
        private final EditorCustomElementRenderer myDelegate;
        private boolean drawBorder;

        public RendererWrapper(EditorCustomElementRenderer delegate2) {
            this.myDelegate = delegate2;
        }

        public int calcWidthInPixels(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/application/options/colors/highlighting/InlineElementData$RendererWrapper", "calcWidthInPixels"));
            }
            return this.myDelegate.calcWidthInPixels(editor);
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g2, @NotNull Rectangle r2) {
            TextAttributes attributes;
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/application/options/colors/highlighting/InlineElementData$RendererWrapper", "paint"));
            }
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/application/options/colors/highlighting/InlineElementData$RendererWrapper", "paint"));
            }
            if (r2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/application/options/colors/highlighting/InlineElementData$RendererWrapper", "paint"));
            }
            this.myDelegate.paint(editor, g2, r2);
            if (this.drawBorder && (attributes = editor.getColorsScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES)) != null && attributes.getEffectColor() != null) {
                g2.setColor(attributes.getEffectColor());
                g2.drawRect(r2.x, r2.y, r2.width, r2.height);
            }
        }
    }
}

