/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconsConfigurable
implements Configurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private CheckBoxList<GutterIconDescriptor> myList;
    private JBCheckBox myShowGutterIconsJBCheckBox;
    private List<GutterIconDescriptor> myDescriptors;
    private Map<GutterIconDescriptor, PluginDescriptor> myFirstDescriptors;

    public GutterIconsConfigurable() {
        this.$$$setupUI$$$();
        this.myFirstDescriptors = new HashMap<GutterIconDescriptor, PluginDescriptor>();
    }

    @Nls
    public String getDisplayName() {
        return "Gutter Icons";
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.editor.gutter.icons";
    }

    @Nullable
    public JComponent createComponent() {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.codeInsight.lineMarkerProvider");
        LanguageExtensionPoint[] extensions = (LanguageExtensionPoint[])point.getExtensions();
        NullableFunction function2 = point1 -> {
            LineMarkerProvider instance2 = (LineMarkerProvider)point1.getInstance();
            return instance2 instanceof LineMarkerProviderDescriptor && ((LineMarkerProviderDescriptor)instance2).getName() != null ? point1.getPluginDescriptor() : null;
        };
        MultiMap map2 = ContainerUtil.groupBy(Arrays.asList(extensions), (NullableFunction)function2);
        HashMap pluginDescriptorMap = ContainerUtil.newHashMap();
        HashSet ids = new HashSet();
        this.myDescriptors = new ArrayList<GutterIconDescriptor>();
        for (PluginDescriptor descriptor2 : map2.keySet()) {
            Collection points = map2.get((Object)descriptor2);
            for (LanguageExtensionPoint extensionPoint : points) {
                GutterIconDescriptor instance2 = (GutterIconDescriptor)extensionPoint.getInstance();
                if (instance2.getOptions().length > 0) {
                    for (GutterIconDescriptor.Option option : instance2.getOptions()) {
                        if (ids.add(option.getId())) {
                            this.myDescriptors.add((GutterIconDescriptor)option);
                        }
                        pluginDescriptorMap.put(option, descriptor2);
                    }
                    continue;
                }
                if (ids.add(instance2.getId())) {
                    this.myDescriptors.add(instance2);
                }
                pluginDescriptorMap.put(instance2, descriptor2);
            }
        }
        this.myDescriptors.sort((o1, o2) -> {
            if (pluginDescriptorMap.get(o1) != pluginDescriptorMap.get(o2)) {
                return 0;
            }
            return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        });
        PluginDescriptor current = null;
        for (GutterIconDescriptor descriptor3 : this.myDescriptors) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)pluginDescriptorMap.get(descriptor3);
            if (pluginDescriptor == current) continue;
            this.myFirstDescriptors.put(descriptor3, pluginDescriptor);
            current = pluginDescriptor;
        }
        this.myList.setItems(this.myDescriptors, GutterIconDescriptor::getName);
        this.myShowGutterIconsJBCheckBox.addChangeListener(e2 -> this.myList.setEnabled(this.myShowGutterIconsJBCheckBox.isSelected()));
        return this.myPanel;
    }

    public boolean isModified() {
        for (GutterIconDescriptor descriptor2 : this.myDescriptors) {
            if (this.myList.isItemSelected((Object)descriptor2) == LineMarkerSettings.getSettings().isEnabled(descriptor2)) continue;
            return true;
        }
        return this.myShowGutterIconsJBCheckBox.isSelected() != EditorSettingsExternalizable.getInstance().areGutterIconsShown();
    }

    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        if (this.myShowGutterIconsJBCheckBox.isSelected() != editorSettings.areGutterIconsShown()) {
            editorSettings.setGutterIconsShown(this.myShowGutterIconsJBCheckBox.isSelected());
            EditorOptionsPanel.reinitAllEditors();
        }
        for (GutterIconDescriptor descriptor2 : this.myDescriptors) {
            LineMarkerSettings.getSettings().setEnabled(descriptor2, this.myList.isItemSelected((Object)descriptor2));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
    }

    public void reset() {
        for (GutterIconDescriptor descriptor2 : this.myDescriptors) {
            this.myList.setItemSelected((Object)descriptor2, LineMarkerSettings.getSettings().isEnabled(descriptor2));
        }
        boolean gutterIconsShown = EditorSettingsExternalizable.getInstance().areGutterIconsShown();
        this.myShowGutterIconsJBCheckBox.setSelected(gutterIconsShown);
        this.myList.setEnabled(gutterIconsShown);
    }

    public void disposeUIResources() {
        for (ChangeListener listener2 : this.myShowGutterIconsJBCheckBox.getChangeListeners()) {
            this.myShowGutterIconsJBCheckBox.removeChangeListener(listener2);
        }
    }

    private void createUIComponents() {
        this.myList = new CheckBoxList<GutterIconDescriptor>(){

            protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox2, int index, boolean selected, boolean hasFocus) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setBorder(BorderFactory.createEmptyBorder());
                GutterIconDescriptor descriptor2 = (GutterIconDescriptor)GutterIconsConfigurable.this.myList.getItemAt(index);
                Icon icon = descriptor2 == null ? null : descriptor2.getIcon();
                JLabel label = new JLabel(icon == null ? EmptyIcon.ICON_16 : icon);
                label.setOpaque(true);
                label.setPreferredSize(new Dimension(25, -1));
                label.setHorizontalAlignment(0);
                panel2.add((Component)label, "West");
                panel2.add((Component)checkBox2, "Center");
                panel2.setBackground(this.getBackground(false));
                label.setBackground(this.getBackground(selected));
                if (!checkBox2.isOpaque()) {
                    checkBox2.setOpaque(true);
                }
                checkBox2.setBorder(null);
                PluginDescriptor pluginDescriptor = (PluginDescriptor)GutterIconsConfigurable.this.myFirstDescriptors.get(descriptor2);
                if (pluginDescriptor instanceof IdeaPluginDescriptor) {
                    SeparatorWithText separator = new SeparatorWithText();
                    String name = ((IdeaPluginDescriptor)pluginDescriptor).getName();
                    separator.setCaption("IDEA CORE".equals(name) ? "Common" : name);
                    panel2.add((Component)separator, "North");
                }
                return panel2;
            }

            @Nullable
            protected Point findPointRelativeToCheckBox(int x2, int y2, @NotNull JCheckBox checkBox2, int index) {
                if (checkBox2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/intellij/application/options/editor/GutterIconsConfigurable$1", "findPointRelativeToCheckBox"));
                }
                return super.findPointRelativeToCheckBoxWithAdjustedRendering(x2, y2, checkBox2, index);
            }
        };
        this.myList.setSelectionMode(2);
        this.myList.setBorder(BorderFactory.createEmptyBorder());
    }

    public List<GutterIconDescriptor> getDescriptors() {
        return this.myDescriptors;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        CheckBoxList<GutterIconDescriptor> checkBoxList = this.myList;
        jBScrollPane.setViewportView((Component)checkBoxList);
        this.myShowGutterIconsJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.gutter.icons"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

