/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.application.options.schemes.AbstractDescriptionAwareSchemesPanel;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Scheme;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DescriptionAwareSchemeActions<T extends Scheme>
extends AbstractSchemeActions<T> {
    protected DescriptionAwareSchemeActions(@NotNull AbstractDescriptionAwareSchemesPanel<T> schemesPanel) {
        if (schemesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemesPanel", "com/intellij/application/options/schemes/DescriptionAwareSchemeActions", "<init>"));
        }
        super(schemesPanel);
    }

    @Nullable
    public abstract String getDescription(@NotNull T var1);

    protected abstract void setDescription(@NotNull T var1, @NotNull String var2);

    @Override
    protected void addAdditionalActions(@NotNull List<AnAction> defaultActions) {
        if (defaultActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultActions", "com/intellij/application/options/schemes/DescriptionAwareSchemeActions", "addAdditionalActions"));
        }
        defaultActions.add(new AnAction("Edit description"){

            public void update(AnActionEvent e2) {
                Object scheme2 = DescriptionAwareSchemeActions.this.getSchemesPanel().getSelectedScheme();
                if (scheme2 == null) {
                    e2.getPresentation().setEnabledAndVisible(false);
                    return;
                }
                String text2 = DescriptionAwareSchemeActions.this.getDescription(scheme2) == null ? "Add Description..." : "Edit Description...";
                e2.getPresentation().setEnabledAndVisible(true);
                e2.getPresentation().setText(text2);
            }

            public void actionPerformed(AnActionEvent e2) {
                ((AbstractDescriptionAwareSchemesPanel)DescriptionAwareSchemeActions.this.mySchemesPanel).editDescription(DescriptionAwareSchemeActions.this.getDescription(DescriptionAwareSchemeActions.this.getSchemesPanel().getSelectedScheme()));
            }
        });
    }

    @Override
    protected void onSchemeChanged(@Nullable T scheme2) {
        if (scheme2 != null) {
            ((AbstractDescriptionAwareSchemesPanel)this.mySchemesPanel).showDescription();
        }
    }
}

