/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.buildfiles;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForcedBuildFileAttribute {
    private static final Logger LOG = Logger.getInstance((String)("#" + ForcedBuildFileAttribute.class.getName()));
    private static final FileAttribute FRAMEWORK_FILE_ATTRIBUTE = new FileAttribute("forcedBuildFileFrameworkAttribute", 2, false);
    private static final Key<String> FRAMEWORK_FILE_MARKER = Key.create((String)"forcedBuildFileFrameworkAttribute");

    private ForcedBuildFileAttribute() {
    }

    public static boolean belongsToFramework(VirtualFile file2, @NotNull String frameworkId) {
        if (frameworkId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkId", "com/intellij/buildfiles/ForcedBuildFileAttribute", "belongsToFramework"));
        }
        return frameworkId.equals(ForcedBuildFileAttribute.getFrameworkIdOfBuildFile(file2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getFrameworkIdOfBuildFile(VirtualFile file2) {
        if (!(file2 instanceof NewVirtualFile)) return (String)file2.getUserData(FRAMEWORK_FILE_MARKER);
        DataInputStream is = FRAMEWORK_FILE_ATTRIBUTE.readAttribute(file2);
        if (is == null) return "";
        try {
            try {
                if (is.available() == 0) {
                    String string2 = null;
                    return string2;
                }
                String string3 = IOUtil.readString((DataInput)is);
                return string3;
            }
            finally {
                is.close();
            }
        }
        catch (IOException e2) {
            LOG.error(file2.getPath(), (Throwable)e2);
        }
        return "";
    }

    public static void forceFileToFramework(VirtualFile file2, String frameworkId, boolean value2) {
        String existingFrameworkId = ForcedBuildFileAttribute.getFrameworkIdOfBuildFile(file2);
        if (!StringUtil.isEmpty((String)existingFrameworkId) && !frameworkId.equals(existingFrameworkId)) {
            return;
        }
        if (value2) {
            ForcedBuildFileAttribute.forceBuildFile(file2, frameworkId);
        } else {
            ForcedBuildFileAttribute.forceBuildFile(file2, null);
        }
    }

    private static void forceBuildFile(VirtualFile file2, @Nullable String value2) {
        if (file2 instanceof NewVirtualFile) {
            DataOutputStream os = FRAMEWORK_FILE_ATTRIBUTE.writeAttribute(file2);
            try {
                try {
                    IOUtil.writeString((String)StringUtil.notNullize((String)value2), (DataOutput)os);
                }
                finally {
                    os.close();
                }
            }
            catch (IOException e2) {
                LOG.error((Throwable)e2);
            }
        } else {
            file2.putUserData(FRAMEWORK_FILE_MARKER, (Object)value2);
        }
    }
}

