/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.OptionGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class ExportToHTMLDialog
extends DialogWrapper {
    private JRadioButton myRbCurrentFile;
    private JRadioButton myRbSelectedText;
    private JRadioButton myRbCurrentPackage;
    private JCheckBox myCbIncludeSubpackages;
    private JCheckBox myCbLineNumbers;
    private JCheckBox myCbOpenInBrowser;
    private TextFieldWithBrowseButton myTargetDirectoryField;
    private final String myFileName;
    private final String myDirectoryName;
    private final boolean myIsSelectedTextEnabled;
    private final Project myProject;
    private final List<UnnamedConfigurable> myExtensions;

    public ExportToHTMLDialog(String fileName, String directoryName, boolean isSelectedTextEnabled, Project project2) {
        super(project2, true);
        this.myProject = project2;
        this.setOKButtonText(CodeEditorBundle.message("export.to.html.save.button", new Object[0]));
        this.myFileName = fileName;
        this.myDirectoryName = directoryName;
        this.myIsSelectedTextEnabled = isSelectedTextEnabled;
        this.setTitle(CodeEditorBundle.message("export.to.html.title", new Object[0]));
        this.myExtensions = new ArrayList<UnnamedConfigurable>();
        for (PrintOption extension : (PrintOption[])Extensions.getExtensions(PrintOption.EP_NAME)) {
            this.myExtensions.add(extension.createConfigurable());
        }
        this.init();
    }

    protected JComponent createNorthPanel() {
        OptionGroup optionGroup = new OptionGroup();
        this.myRbCurrentFile = new JRadioButton(CodeEditorBundle.message("export.to.html.file.name.radio", this.myFileName != null ? this.myFileName : ""));
        optionGroup.add((JComponent)this.myRbCurrentFile);
        this.myRbSelectedText = new JRadioButton(CodeEditorBundle.message("export.to.html.selected.text.radio", new Object[0]));
        optionGroup.add((JComponent)this.myRbSelectedText);
        this.myRbCurrentPackage = new JRadioButton(CodeEditorBundle.message("export.to.html.all.files.in.directory.radio", this.myDirectoryName != null ? this.myDirectoryName : ""));
        optionGroup.add((JComponent)this.myRbCurrentPackage);
        this.myCbIncludeSubpackages = new JCheckBox(CodeEditorBundle.message("export.to.html.include.subdirectories.checkbox", new Object[0]));
        optionGroup.add((JComponent)this.myCbIncludeSubpackages, true);
        FileTextField field = FileChooserFactory.getInstance().createFileTextField(FileChooserDescriptorFactory.createSingleFolderDescriptor(), this.myDisposable);
        this.myTargetDirectoryField = new TextFieldWithBrowseButton(field.getField());
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent = ExportToHTMLDialog.assignLabel(this.myTargetDirectoryField, this.myProject);
        optionGroup.add(labeledComponent);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbCurrentFile);
        buttonGroup2.add(this.myRbSelectedText);
        buttonGroup2.add(this.myRbCurrentPackage);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                ExportToHTMLDialog.this.myCbIncludeSubpackages.setEnabled(ExportToHTMLDialog.this.myRbCurrentPackage.isSelected());
            }
        };
        this.myRbCurrentFile.addActionListener(actionListener);
        this.myRbSelectedText.addActionListener(actionListener);
        this.myRbCurrentPackage.addActionListener(actionListener);
        return optionGroup.createPanel();
    }

    public static LabeledComponent<TextFieldWithBrowseButton> assignLabel(TextFieldWithBrowseButton targetDirectoryField, Project project2) {
        LabeledComponent labeledComponent = new LabeledComponent();
        labeledComponent.setText(CodeEditorBundle.message("export.to.html.output.directory.label", new Object[0]));
        targetDirectoryField.addBrowseFolderListener(CodeEditorBundle.message("export.to.html.select.output.directory.title", new Object[0]), CodeEditorBundle.message("export.to.html.select.output.directory.description", new Object[0]), project2, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        labeledComponent.setComponent((JComponent)targetDirectoryField);
        return labeledComponent;
    }

    protected JComponent createCenterPanel() {
        OptionGroup optionGroup = new OptionGroup(CodeEditorBundle.message("export.to.html.options.group", new Object[0]));
        this.myCbLineNumbers = new JCheckBox(CodeEditorBundle.message("export.to.html.options.show.line.numbers.checkbox", new Object[0]));
        optionGroup.add((JComponent)this.myCbLineNumbers);
        for (UnnamedConfigurable printOption : this.myExtensions) {
            optionGroup.add(printOption.createComponent());
        }
        this.myCbOpenInBrowser = new JCheckBox(CodeEditorBundle.message("export.to.html.open.generated.html.checkbox", new Object[0]));
        optionGroup.add((JComponent)this.myCbOpenInBrowser);
        return optionGroup.createPanel();
    }

    public void reset() {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myProject);
        this.myRbSelectedText.setEnabled(this.myIsSelectedTextEnabled);
        this.myRbSelectedText.setSelected(this.myIsSelectedTextEnabled);
        this.myRbCurrentFile.setEnabled(this.myFileName != null);
        this.myRbCurrentFile.setSelected(this.myFileName != null && !this.myIsSelectedTextEnabled);
        this.myRbCurrentPackage.setEnabled(this.myDirectoryName != null);
        this.myRbCurrentPackage.setSelected(this.myDirectoryName != null && !this.myIsSelectedTextEnabled && this.myFileName == null);
        this.myCbIncludeSubpackages.setSelected(exportToHTMLSettings.isIncludeSubdirectories());
        this.myCbIncludeSubpackages.setEnabled(this.myRbCurrentPackage.isSelected());
        this.myCbLineNumbers.setSelected(exportToHTMLSettings.PRINT_LINE_NUMBERS);
        this.myCbOpenInBrowser.setSelected(exportToHTMLSettings.OPEN_IN_BROWSER);
        this.myTargetDirectoryField.setText(exportToHTMLSettings.OUTPUT_DIRECTORY);
        for (UnnamedConfigurable printOption : this.myExtensions) {
            printOption.reset();
        }
    }

    protected void dispose() {
        for (UnnamedConfigurable extension : this.myExtensions) {
            extension.disposeUIResources();
        }
        super.dispose();
    }

    public void apply() throws ConfigurationException {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myProject);
        if (this.myRbCurrentFile.isSelected()) {
            exportToHTMLSettings.setPrintScope(1);
        } else if (this.myRbSelectedText.isSelected()) {
            exportToHTMLSettings.setPrintScope(2);
        } else if (this.myRbCurrentPackage.isSelected()) {
            exportToHTMLSettings.setPrintScope(4);
        }
        exportToHTMLSettings.setIncludeSubpackages(this.myCbIncludeSubpackages.isSelected());
        exportToHTMLSettings.PRINT_LINE_NUMBERS = this.myCbLineNumbers.isSelected();
        exportToHTMLSettings.OPEN_IN_BROWSER = this.myCbOpenInBrowser.isSelected();
        exportToHTMLSettings.OUTPUT_DIRECTORY = this.myTargetDirectoryField.getText();
        for (UnnamedConfigurable printOption : this.myExtensions) {
            printOption.apply();
        }
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeEditor/printing/ExportToHTMLDialog", "createActions"));
        }
        return actionArray;
    }

    public void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.file.exportToHtml");
    }
}

