/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.PageSizes;
import com.intellij.codeEditor.printing.PrintSettings;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.MappingListCellRenderer;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class PrintDialog
extends DialogWrapper {
    private JRadioButton myRbCurrentFile = null;
    private JRadioButton myRbSelectedText = null;
    private JRadioButton myRbCurrentPackage = null;
    private JCheckBox myCbIncludeSubpackages = null;
    private JComboBox myPaperSizeCombo = null;
    private JCheckBox myCbColorPrinting = null;
    private JCheckBox myCbSyntaxPrinting = null;
    private JCheckBox myCbPrintAsGraphics = null;
    private JRadioButton myRbPortrait = null;
    private JRadioButton myRbLandscape = null;
    private FontComboBox myFontNameCombo = null;
    private JComboBox myFontSizeCombo = null;
    private JCheckBox myCbLineNumbers = null;
    private JRadioButton myRbNoWrap = null;
    private JRadioButton myRbWrapAtWordBreaks = null;
    private JTextField myTopMarginField = null;
    private JTextField myBottomMarginField = null;
    private JTextField myLeftMarginField = null;
    private JTextField myRightMarginField = null;
    private JCheckBox myCbDrawBorder = null;
    private JCheckBox myCbEvenNumberOfPages = null;
    private JTextField myLineTextField1 = null;
    private JComboBox myLinePlacementCombo1 = null;
    private JComboBox myLineAlignmentCombo1 = null;
    private JTextField myLineTextField2 = null;
    private JComboBox myLinePlacementCombo2 = null;
    private JComboBox myLineAlignmentCombo2 = null;
    private JComboBox myFooterFontSizeCombo = null;
    private FontComboBox myFooterFontNameCombo = null;
    private String myFileName = null;
    private String myDirectoryName = null;
    private final boolean isSelectedTextEnabled;
    private final int mySelectedFileCount;
    private static final Map<Object, String> PLACEMENT_MAP = new HashMap<Object, String>();
    private static final Map<Object, String> ALIGNMENT_MAP = new HashMap<Object, String>();
    private final String mySelectedText;

    public PrintDialog(String fileName, String directoryName, String selectedText, int selectedFileCount, Project project2) {
        super(project2, true);
        this.mySelectedText = selectedText;
        this.setOKButtonText(CodeEditorBundle.message("print.print.button", new Object[0]));
        this.myFileName = fileName;
        this.myDirectoryName = directoryName;
        this.isSelectedTextEnabled = selectedText != null;
        this.mySelectedFileCount = selectedFileCount;
        this.setTitle(CodeEditorBundle.message("print.title", new Object[0]));
        this.init();
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 4));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        this.myRbCurrentFile = new JRadioButton(this.mySelectedFileCount > 1 ? CodeEditorBundle.message("print.files.radio", this.mySelectedFileCount) : CodeEditorBundle.message("print.file.name.radio", this.myFileName != null ? this.myFileName : ""));
        panel2.add((Component)this.myRbCurrentFile, gbConstraints);
        this.myRbSelectedText = new JRadioButton(this.mySelectedText != null ? this.mySelectedText : CodeEditorBundle.message("print.selected.text.radio", new Object[0]));
        ++gbConstraints.gridy;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        panel2.add((Component)this.myRbSelectedText, gbConstraints);
        this.myRbCurrentPackage = new JRadioButton(CodeEditorBundle.message("print.all.files.in.directory.radio", this.myDirectoryName != null ? this.myDirectoryName : ""));
        ++gbConstraints.gridy;
        gbConstraints.insets = new Insets(0, 0, 0, 0);
        panel2.add((Component)this.myRbCurrentPackage, gbConstraints);
        this.myCbIncludeSubpackages = new JCheckBox(CodeEditorBundle.message("print.include.subdirectories.checkbox", new Object[0]));
        ++gbConstraints.gridy;
        gbConstraints.insets = new Insets(0, 20, 0, 0);
        panel2.add((Component)this.myCbIncludeSubpackages, gbConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbCurrentFile);
        buttonGroup2.add(this.myRbSelectedText);
        buttonGroup2.add(this.myRbCurrentPackage);
        ActionListener actionListener = e2 -> this.updateDependentComponents();
        this.myRbCurrentFile.addActionListener(actionListener);
        this.myRbSelectedText.addActionListener(actionListener);
        this.myRbCurrentPackage.addActionListener(actionListener);
        return panel2;
    }

    private void updateDependentComponents() {
        this.myCbIncludeSubpackages.setEnabled(this.myRbCurrentPackage.isSelected());
        this.myCbEvenNumberOfPages.setVisible(this.myRbCurrentFile.isSelected() && this.mySelectedFileCount > 1 || this.myRbCurrentPackage.isSelected());
    }

    protected JComponent createCenterPanel() {
        TabbedPaneWrapper tabbedPaneWrapper = new TabbedPaneWrapper(this.myDisposable);
        tabbedPaneWrapper.addTab(CodeEditorBundle.message("print.settings.tab", new Object[0]), this.createPrintSettingsPanel());
        tabbedPaneWrapper.addTab(CodeEditorBundle.message("print.header.footer.tab", new Object[0]), this.createHeaderAndFooterPanel());
        tabbedPaneWrapper.addTab(CodeEditorBundle.message("print.advanced.tab", new Object[0]), this.createAdvancedPanel());
        return tabbedPaneWrapper.getComponent();
    }

    private JPanel createPrintSettingsPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 4, 4));
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.insets = new Insets(0, 8, 6, 4);
        gbConstraints.fill = 1;
        MyLabel paperSizeLabel = new MyLabel(CodeEditorBundle.message("print.settings.paper.size.label", new Object[0]));
        panel2.add((Component)paperSizeLabel, gbConstraints);
        this.myPaperSizeCombo = PrintDialog.createPageSizesCombo();
        gbConstraints.gridx = 1;
        gbConstraints.gridwidth = 2;
        panel2.add((Component)this.myPaperSizeCombo, gbConstraints);
        MyLabel fontLabel = new MyLabel(CodeEditorBundle.message("print.settings.font.label", new Object[0]));
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        ++gbConstraints.gridy;
        panel2.add((Component)fontLabel, gbConstraints);
        this.myFontNameCombo = new FontComboBox(true);
        gbConstraints.gridx = 1;
        panel2.add((Component)((Object)this.myFontNameCombo), gbConstraints);
        this.myFontSizeCombo = PrintDialog.createFontSizesComboBox();
        gbConstraints.gridx = 2;
        panel2.add((Component)this.myFontSizeCombo, gbConstraints);
        this.myCbLineNumbers = new JCheckBox(CodeEditorBundle.message("print.settings.show.line.numbers.checkbox", new Object[0]));
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 3;
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbLineNumbers, gbConstraints);
        this.myCbDrawBorder = new JCheckBox(CodeEditorBundle.message("print.settings.draw.border.checkbox", new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbDrawBorder, gbConstraints);
        this.myCbEvenNumberOfPages = new JCheckBox(CodeEditorBundle.message("print.settings.even.number.of.pages", new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbEvenNumberOfPages, gbConstraints);
        gbConstraints.insets = new Insets(0, 0, 6, 4);
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 3;
        ++gbConstraints.gridy;
        panel2.add((Component)this.createStyleAndLayoutPanel(), gbConstraints);
        ++gbConstraints.gridy;
        gbConstraints.weighty = 1.0;
        panel2.add((Component)new MyTailPanel(), gbConstraints);
        return panel2;
    }

    private JPanel createAdvancedPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 4, 4));
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = new Insets(0, 0, 6, 4);
        panel2.add((Component)this.createWrappingPanel(), gbConstraints);
        ++gbConstraints.gridy;
        panel2.add((Component)this.createMarginsPanel(), gbConstraints);
        ++gbConstraints.gridy;
        gbConstraints.weighty = 1.0;
        panel2.add((Component)new MyTailPanel(), gbConstraints);
        return panel2;
    }

    private JPanel createStyleAndLayoutPanel() {
        JPanel panel2 = new JPanel(new GridLayout(1, 2));
        panel2.add(this.createOrientationPanel());
        panel2.add(this.createStylePanel());
        return panel2;
    }

    private JPanel createOrientationPanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CodeEditorBundle.message("print.orientation.group", new Object[0]), (boolean)true));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myRbPortrait = new JRadioButton(CodeEditorBundle.message("print.orientation.portrait.radio", new Object[0]));
        panel2.add((Component)this.myRbPortrait, gbConstraints);
        this.myRbLandscape = new JRadioButton(CodeEditorBundle.message("print.orientation.landscape.radio", new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myRbLandscape, gbConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbPortrait);
        buttonGroup2.add(this.myRbLandscape);
        return panel2;
    }

    private JPanel createStylePanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CodeEditorBundle.message("print.style.group", new Object[0]), (boolean)true));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbColorPrinting = new JCheckBox(CodeEditorBundle.message("print.style.color.printing.checkbox", new Object[0]));
        panel2.add((Component)this.myCbColorPrinting, gbConstraints);
        this.myCbSyntaxPrinting = new JCheckBox(CodeEditorBundle.message("print.style.syntax.printing.checkbox", new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbSyntaxPrinting, gbConstraints);
        this.myCbPrintAsGraphics = new JCheckBox(CodeEditorBundle.message("print.style.print.as.graphics.checkbox", new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myCbPrintAsGraphics, gbConstraints);
        return panel2;
    }

    private JPanel createWrappingPanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CodeEditorBundle.message("print.wrapping.group", new Object[0]), (boolean)true));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myRbNoWrap = new JRadioButton(CodeEditorBundle.message("print.wrapping.none.radio", new Object[0]));
        panel2.add((Component)this.myRbNoWrap, gbConstraints);
        this.myRbWrapAtWordBreaks = new JRadioButton(CodeEditorBundle.message("print.wrapping.word.breaks.radio", new Object[0]));
        ++gbConstraints.gridy;
        panel2.add((Component)this.myRbWrapAtWordBreaks, gbConstraints);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbNoWrap);
        buttonGroup2.add(this.myRbWrapAtWordBreaks);
        return panel2;
    }

    private JPanel createMarginsPanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CodeEditorBundle.message("print.margins.group", new Object[0]), (boolean)true));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        panel2.add((Component)new MyLabel(CodeEditorBundle.message("print.margins.top.label", new Object[0])), gbConstraints);
        this.myTopMarginField = new MyTextField(6);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 1;
        panel2.add((Component)this.myTopMarginField, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 2;
        panel2.add((Component)new MyLabel(CodeEditorBundle.message("print.margins.bottom.label", new Object[0])), gbConstraints);
        this.myBottomMarginField = new MyTextField(6);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 3;
        panel2.add((Component)this.myBottomMarginField, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        panel2.add((Component)new MyLabel(CodeEditorBundle.message("print.margins.left.label", new Object[0])), gbConstraints);
        this.myLeftMarginField = new MyTextField(6);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 1;
        panel2.add((Component)this.myLeftMarginField, gbConstraints);
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 2;
        panel2.add((Component)new MyLabel(CodeEditorBundle.message("print.margins.right.label", new Object[0])), gbConstraints);
        this.myRightMarginField = new MyTextField(6);
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 3;
        panel2.add((Component)this.myRightMarginField, gbConstraints);
        return panel2;
    }

    private JPanel createHeaderAndFooterPanel() {
        JPanel panel2 = new JPanel();
        panel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 4, 4));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = new Insets(0, 0, 6, 4);
        gbConstraints.gridwidth = 3;
        this.myLineTextField1 = new MyTextField(30);
        this.myLinePlacementCombo1 = new ComboBox();
        this.myLineAlignmentCombo1 = new ComboBox();
        JPanel linePanel1 = PrintDialog.createLinePanel(CodeEditorBundle.message("print.header.line.1.label", new Object[0]), this.myLineTextField1, this.myLinePlacementCombo1, this.myLineAlignmentCombo1);
        panel2.add((Component)linePanel1, gbConstraints);
        this.myLineTextField2 = new MyTextField(30);
        this.myLinePlacementCombo2 = new ComboBox();
        this.myLineAlignmentCombo2 = new ComboBox();
        JPanel linePanel2 = PrintDialog.createLinePanel(CodeEditorBundle.message("print.header.line.2.label", new Object[0]), this.myLineTextField2, this.myLinePlacementCombo2, this.myLineAlignmentCombo2);
        ++gbConstraints.gridy;
        panel2.add((Component)linePanel2, gbConstraints);
        gbConstraints.insets = new Insets(0, 8, 6, 4);
        ++gbConstraints.gridy;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        panel2.add((Component)new MyLabel(CodeEditorBundle.message("print.header.font.label", new Object[0])), gbConstraints);
        this.myFooterFontNameCombo = new FontComboBox(true);
        gbConstraints.gridx = 1;
        panel2.add((Component)((Object)this.myFooterFontNameCombo), gbConstraints);
        this.myFooterFontSizeCombo = PrintDialog.createFontSizesComboBox();
        gbConstraints.gridx = 2;
        panel2.add((Component)this.myFooterFontSizeCombo, gbConstraints);
        return panel2;
    }

    private static JPanel createLinePanel(String name, JTextField lineTextField, JComboBox linePlacementCombo, JComboBox lineAlignmentCombo) {
        JPanel panel2 = new JPanel();
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)name, (boolean)true));
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 1;
        gbConstraints.gridheight = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.fill = 1;
        gbConstraints.insets = new Insets(0, 0, 6, 0);
        panel2.add((Component)new MyLabel(CodeEditorBundle.message("print.header.text.line.editbox", new Object[0])), gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.gridwidth = 4;
        gbConstraints.weightx = 1.0;
        panel2.add((Component)lineTextField, gbConstraints);
        gbConstraints.gridwidth = 1;
        ++gbConstraints.gridy;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 0.0;
        panel2.add((Component)new MyLabel(CodeEditorBundle.message("print.header.placement.combobox", new Object[0])), gbConstraints);
        linePlacementCombo.addItem("Header");
        linePlacementCombo.addItem("Footer");
        linePlacementCombo.setRenderer(new MappingListCellRenderer(linePlacementCombo.getRenderer(), PLACEMENT_MAP));
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 0.0;
        panel2.add((Component)linePlacementCombo, gbConstraints);
        gbConstraints.gridx = 2;
        gbConstraints.weightx = 1.0;
        panel2.add((Component)new MyTailPanel(), gbConstraints);
        gbConstraints.gridx = 3;
        gbConstraints.weightx = 0.0;
        panel2.add((Component)new MyLabel(CodeEditorBundle.message("print.header.alignment.combobox", new Object[0])), gbConstraints);
        linePlacementCombo.setRenderer(new MappingListCellRenderer(linePlacementCombo.getRenderer(), ALIGNMENT_MAP));
        lineAlignmentCombo.addItem("Left");
        lineAlignmentCombo.addItem("Center");
        lineAlignmentCombo.addItem("Right");
        gbConstraints.gridx = 4;
        gbConstraints.weightx = 0.0;
        panel2.add((Component)lineAlignmentCombo, gbConstraints);
        return panel2;
    }

    private static JComboBox createFontSizesComboBox() {
        ComboBox comboBox = new ComboBox();
        for (int i2 = 6; i2 < 40; ++i2) {
            comboBox.addItem(String.valueOf(i2));
        }
        return comboBox;
    }

    private static JComboBox createPageSizesCombo() {
        String[] names;
        ComboBox pageSizesCombo = new ComboBox();
        for (String name : names = PageSizes.getNames()) {
            pageSizesCombo.addItem(PageSizes.getItem(name));
        }
        return pageSizesCombo;
    }

    public void reset() {
        PrintSettings printSettings = PrintSettings.getInstance();
        this.myRbSelectedText.setEnabled(this.isSelectedTextEnabled);
        this.myRbSelectedText.setSelected(this.isSelectedTextEnabled);
        this.myRbCurrentFile.setEnabled(this.myFileName != null || this.mySelectedFileCount > 1);
        this.myRbCurrentFile.setSelected(this.myFileName != null && !this.isSelectedTextEnabled || this.mySelectedFileCount > 1);
        this.myRbCurrentPackage.setEnabled(this.myDirectoryName != null);
        this.myRbCurrentPackage.setSelected(this.myDirectoryName != null && !this.isSelectedTextEnabled && this.myFileName == null);
        this.myCbIncludeSubpackages.setSelected(printSettings.isIncludeSubdirectories());
        this.updateDependentComponents();
        Object selectedPageSize = PageSizes.getItem(printSettings.PAPER_SIZE);
        if (selectedPageSize != null) {
            this.myPaperSizeCombo.setSelectedItem(selectedPageSize);
        }
        this.myCbColorPrinting.setSelected(printSettings.COLOR_PRINTING);
        this.myCbSyntaxPrinting.setSelected(printSettings.SYNTAX_PRINTING);
        this.myCbPrintAsGraphics.setSelected(printSettings.PRINT_AS_GRAPHICS);
        if (printSettings.PORTRAIT_LAYOUT) {
            this.myRbPortrait.setSelected(true);
        } else {
            this.myRbLandscape.setSelected(true);
        }
        this.myFontNameCombo.setFontName(printSettings.FONT_NAME);
        this.myFontSizeCombo.setSelectedItem(String.valueOf(printSettings.FONT_SIZE));
        this.myCbLineNumbers.setSelected(printSettings.PRINT_LINE_NUMBERS);
        if (printSettings.WRAP) {
            this.myRbWrapAtWordBreaks.setSelected(true);
        } else {
            this.myRbNoWrap.setSelected(true);
        }
        this.myTopMarginField.setText(String.valueOf(printSettings.TOP_MARGIN));
        this.myBottomMarginField.setText(String.valueOf(printSettings.BOTTOM_MARGIN));
        this.myLeftMarginField.setText(String.valueOf(printSettings.LEFT_MARGIN));
        this.myRightMarginField.setText(String.valueOf(printSettings.RIGHT_MARGIN));
        this.myCbDrawBorder.setSelected(printSettings.DRAW_BORDER);
        this.myCbEvenNumberOfPages.setSelected(printSettings.EVEN_NUMBER_OF_PAGES);
        this.myLineTextField1.setText(printSettings.FOOTER_HEADER_TEXT1);
        this.myLinePlacementCombo1.setSelectedItem(printSettings.FOOTER_HEADER_PLACEMENT1);
        this.myLineAlignmentCombo1.setSelectedItem(printSettings.FOOTER_HEADER_ALIGNMENT1);
        this.myLineTextField2.setText(printSettings.FOOTER_HEADER_TEXT2);
        this.myLinePlacementCombo2.setSelectedItem(printSettings.FOOTER_HEADER_PLACEMENT2);
        this.myLineAlignmentCombo2.setSelectedItem(printSettings.FOOTER_HEADER_ALIGNMENT2);
        this.myFooterFontSizeCombo.setSelectedItem(String.valueOf(printSettings.FOOTER_HEADER_FONT_SIZE));
        this.myFooterFontNameCombo.setFontName(printSettings.FOOTER_HEADER_FONT_NAME);
    }

    public void apply() {
        PrintSettings printSettings = PrintSettings.getInstance();
        if (this.myRbCurrentFile.isSelected()) {
            printSettings.setPrintScope(1);
        } else if (this.myRbSelectedText.isSelected()) {
            printSettings.setPrintScope(2);
        } else if (this.myRbCurrentPackage.isSelected()) {
            printSettings.setPrintScope(4);
        }
        printSettings.setIncludeSubdirectories(this.myCbIncludeSubpackages.isSelected());
        printSettings.PAPER_SIZE = PageSizes.getName(this.myPaperSizeCombo.getSelectedItem());
        printSettings.COLOR_PRINTING = this.myCbColorPrinting.isSelected();
        printSettings.SYNTAX_PRINTING = this.myCbSyntaxPrinting.isSelected();
        printSettings.PRINT_AS_GRAPHICS = this.myCbPrintAsGraphics.isSelected();
        printSettings.PORTRAIT_LAYOUT = this.myRbPortrait.isSelected();
        printSettings.FONT_NAME = this.myFontNameCombo.getFontName();
        try {
            String fontSizeStr = (String)this.myFontSizeCombo.getSelectedItem();
            printSettings.FONT_SIZE = Integer.parseInt(fontSizeStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        printSettings.PRINT_LINE_NUMBERS = this.myCbLineNumbers.isSelected();
        printSettings.WRAP = this.myRbWrapAtWordBreaks.isSelected();
        try {
            printSettings.TOP_MARGIN = Float.parseFloat(this.myTopMarginField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            printSettings.BOTTOM_MARGIN = Float.parseFloat(this.myBottomMarginField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            printSettings.LEFT_MARGIN = Float.parseFloat(this.myLeftMarginField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            printSettings.RIGHT_MARGIN = Float.parseFloat(this.myRightMarginField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        printSettings.DRAW_BORDER = this.myCbDrawBorder.isSelected();
        printSettings.EVEN_NUMBER_OF_PAGES = this.myCbEvenNumberOfPages.isSelected();
        printSettings.FOOTER_HEADER_TEXT1 = this.myLineTextField1.getText();
        printSettings.FOOTER_HEADER_ALIGNMENT1 = (String)this.myLineAlignmentCombo1.getSelectedItem();
        printSettings.FOOTER_HEADER_PLACEMENT1 = (String)this.myLinePlacementCombo1.getSelectedItem();
        printSettings.FOOTER_HEADER_TEXT2 = this.myLineTextField2.getText();
        printSettings.FOOTER_HEADER_ALIGNMENT2 = (String)this.myLineAlignmentCombo2.getSelectedItem();
        printSettings.FOOTER_HEADER_PLACEMENT2 = (String)this.myLinePlacementCombo2.getSelectedItem();
        try {
            printSettings.FOOTER_HEADER_FONT_SIZE = Integer.parseInt((String)this.myFooterFontSizeCombo.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        printSettings.FOOTER_HEADER_FONT_NAME = this.myFooterFontNameCombo.getFontName();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeEditor/printing/PrintDialog", "createActions"));
        }
        return actionArray;
    }

    public void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.file.print");
    }

    static {
        PLACEMENT_MAP.put("Header", CodeEditorBundle.message("print.header.placement.header", new Object[0]));
        PLACEMENT_MAP.put("Footer", CodeEditorBundle.message("print.header.placement.footer", new Object[0]));
        ALIGNMENT_MAP.put("Left", CodeEditorBundle.message("print.header.alignment.left", new Object[0]));
        ALIGNMENT_MAP.put("Center", CodeEditorBundle.message("print.header.alignment.center", new Object[0]));
        ALIGNMENT_MAP.put("Right", CodeEditorBundle.message("print.header.alignment.right", new Object[0]));
    }

    private static class MyLabel
    extends JLabel {
        public MyLabel(String text2) {
            super(text2);
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }
    }

    private static class MyTextField
    extends JTextField {
        public MyTextField(int size) {
            super(size);
        }

        @Override
        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }
    }

    class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            this.putValue("Name", CodeEditorBundle.message("print.apply.button", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            PrintDialog.this.apply();
        }
    }

    private static class MyTailPanel
    extends JPanel {
        public MyTailPanel() {
            this.setFocusable(false);
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.emptySize();
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.emptySize();
        }
    }
}

