/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.BasePainter;
import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.FileSeparatorProvider;
import com.intellij.codeEditor.printing.LineWrapper;
import com.intellij.codeEditor.printing.PrintSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class TextPainter
extends BasePainter {
    private final DocumentEx myDocument;
    private RangeMarker myRangeToPrint;
    private int myOffset;
    private int myLineNumber;
    private float myLineHeight;
    private float myDescent;
    private double myCharWidth;
    private final Font myPlainFont;
    private final Font myBoldFont;
    private final Font myItalicFont;
    private final Font myBoldItalicFont;
    private final Font myHeaderFont;
    private final EditorHighlighter myHighlighter;
    private final PrintSettings myPrintSettings;
    private final String myFullFileName;
    private final String myShortFileName;
    private int myPageIndex;
    private int myNumberOfPages;
    private int mySegmentEnd;
    private final LineMarkerInfo[] myMethodSeparators;
    private int myCurrentMethodSeparator;
    private final CodeStyleSettings myCodeStyleSettings;
    private final FileType myFileType;
    private boolean myPerformActualDrawing;
    private final String myPrintDate;
    private final String myPrintTime;
    @NonNls
    private static final String DEFAULT_MEASURE_HEIGHT_TEXT = "A";
    @NonNls
    private static final String DEFAULT_MEASURE_WIDTH_TEXT = "w";
    @NonNls
    private static final String HEADER_TOKEN_PAGE = "PAGE";
    @NonNls
    private static final String HEADER_TOKEN_TOTALPAGES = "TOTALPAGES";
    @NonNls
    private static final String HEADER_TOKEN_FILE = "FILE";
    @NonNls
    private static final String HEADER_TOKEN_FILENAME = "FILENAME";
    @NonNls
    private static final String HEADER_TOKEN_DATE = "DATE";
    @NonNls
    private static final String HEADER_TOKEN_TIME = "TIME";
    @NonNls
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    @NonNls
    private static final String TIME_FORMAT = "HH:mm:ss";
    boolean isPrintingPass;

    public TextPainter(@NotNull DocumentEx editorDocument, EditorHighlighter highlighter2, String fullFileName, String shortFileName, @NotNull PsiFile psiFile, FileType fileType) {
        if (editorDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorDocument", "com/intellij/codeEditor/printing/TextPainter", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeEditor/printing/TextPainter", "<init>"));
        }
        this(editorDocument, highlighter2, fullFileName, shortFileName, psiFile.getProject(), fileType, FileSeparatorProvider.getFileSeparators(psiFile, editorDocument));
    }

    public TextPainter(@NotNull DocumentEx editorDocument, EditorHighlighter highlighter2, String fullFileName, String shortFileName, Project project2, FileType fileType, List<LineMarkerInfo> separators) {
        if (editorDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorDocument", "com/intellij/codeEditor/printing/TextPainter", "<init>"));
        }
        this.myOffset = 0;
        this.myLineNumber = 1;
        this.myLineHeight = -1.0f;
        this.myDescent = -1.0f;
        this.myCharWidth = -1.0;
        this.myPageIndex = -1;
        this.myNumberOfPages = -1;
        this.isPrintingPass = true;
        this.myCodeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
        this.myDocument = editorDocument;
        this.myPrintSettings = PrintSettings.getInstance();
        String fontName = this.myPrintSettings.FONT_NAME;
        int fontSize = this.myPrintSettings.FONT_SIZE;
        this.myPlainFont = new Font(fontName, 0, fontSize);
        this.myBoldFont = new Font(fontName, 1, fontSize);
        this.myItalicFont = new Font(fontName, 2, fontSize);
        this.myBoldItalicFont = new Font(fontName, 3, fontSize);
        this.myHighlighter = highlighter2;
        this.myHeaderFont = new Font(this.myPrintSettings.FOOTER_HEADER_FONT_NAME, 0, this.myPrintSettings.FOOTER_HEADER_FONT_SIZE);
        this.myFullFileName = fullFileName;
        this.myShortFileName = shortFileName;
        this.myRangeToPrint = editorDocument.createRangeMarker(0, this.myDocument.getTextLength());
        this.myFileType = fileType;
        this.myMethodSeparators = separators != null ? separators.toArray(new LineMarkerInfo[separators.size()]) : new LineMarkerInfo[]{};
        this.myCurrentMethodSeparator = 0;
        Date date = new Date();
        this.myPrintDate = new SimpleDateFormat(DATE_FORMAT).format(date);
        this.myPrintTime = new SimpleDateFormat(TIME_FORMAT).format(date);
    }

    public void setSegment(int segmentStart, int segmentEnd) {
        this.setSegment(this.myDocument.createRangeMarker(segmentStart, segmentEnd));
    }

    private void setSegment(RangeMarker marker) {
        if (this.myRangeToPrint != null) {
            this.myRangeToPrint.dispose();
        }
        this.myRangeToPrint = marker;
    }

    private float getLineHeight(Graphics g2) {
        if (this.myLineHeight >= 0.0f) {
            return this.myLineHeight;
        }
        FontRenderContext fontRenderContext = ((Graphics2D)g2).getFontRenderContext();
        LineMetrics lineMetrics = this.myPlainFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
        this.myLineHeight = lineMetrics.getHeight();
        return this.myLineHeight;
    }

    private float getDescent(Graphics g2) {
        if (this.myDescent >= 0.0f) {
            return this.myDescent;
        }
        FontRenderContext fontRenderContext = ((Graphics2D)g2).getFontRenderContext();
        LineMetrics lineMetrics = this.myPlainFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
        this.myDescent = lineMetrics.getDescent();
        return this.myDescent;
    }

    private Font getFont(int type) {
        if (type == 1) {
            return this.myBoldFont;
        }
        if (type == 2) {
            return this.myItalicFont;
        }
        if (type == 3) {
            return this.myBoldItalicFont;
        }
        return this.myPlainFont;
    }

    @Override
    public int print(Graphics g2, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.myPerformActualDrawing = false;
        if (this.myProgress.isCanceled()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g2;
        if (this.myNumberOfPages < 0) {
            this.myProgress.setText(CodeEditorBundle.message("print.file.calculating.number.of.pages.progress", new Object[0]));
            if (!this.calculateNumberOfPages(g2d, pageFormat)) {
                return 1;
            }
        }
        if (pageIndex >= this.myNumberOfPages) {
            return 1;
        }
        boolean bl = this.isPrintingPass = !this.isPrintingPass;
        if (!this.isPrintingPass) {
            while (++this.myPageIndex < pageIndex) {
                if (this.printPageInReadAction(g2d, pageFormat, "print.skip.page.progress")) continue;
                return 1;
            }
            return (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                public Integer compute() {
                    return TextPainter.isValidRange(TextPainter.this.myRangeToPrint) ? 0 : 1;
                }
            });
        }
        this.myPerformActualDrawing = true;
        this.printPageInReadAction(g2d, pageFormat, "print.file.page.progress");
        return 0;
    }

    private boolean printPageInReadAction(final Graphics2D g2d, final PageFormat pageFormat, final String progressMessageKey) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                if (!TextPainter.isValidRange(TextPainter.this.myRangeToPrint)) {
                    return false;
                }
                TextPainter.this.myProgress.setText(CodeEditorBundle.message(progressMessageKey, TextPainter.this.myShortFileName, TextPainter.this.myPageIndex + 1, TextPainter.this.myNumberOfPages));
                TextPainter.this.setSegment(TextPainter.this.printPage(g2d, pageFormat, TextPainter.this.myRangeToPrint));
                return true;
            }
        });
    }

    private boolean calculateNumberOfPages(final Graphics2D g2d, final PageFormat pageFormat) {
        this.myNumberOfPages = 0;
        final Ref firstPage = new Ref((Object)Boolean.TRUE);
        final Ref tmpMarker = new Ref();
        while (((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                RangeMarker range;
                if (((Boolean)firstPage.get()).booleanValue()) {
                    if (!TextPainter.isValidRange(TextPainter.this.myRangeToPrint)) {
                        return false;
                    }
                    tmpMarker.set((Object)TextPainter.this.myDocument.createRangeMarker(TextPainter.this.myRangeToPrint.getStartOffset(), TextPainter.this.myRangeToPrint.getEndOffset()));
                    firstPage.set((Object)Boolean.FALSE);
                }
                if (!TextPainter.isValidRange(range = (RangeMarker)tmpMarker.get())) {
                    return false;
                }
                tmpMarker.set((Object)TextPainter.this.printPage(g2d, pageFormat, range));
                range.dispose();
                return true;
            }
        })).booleanValue()) {
            if (this.myProgress.isCanceled()) {
                return false;
            }
            ++this.myNumberOfPages;
        }
        if (!tmpMarker.isNull()) {
            ((RangeMarker)tmpMarker.get()).dispose();
        }
        return true;
    }

    private static boolean isValidRange(RangeMarker range) {
        return range != null && range.isValid() && range.getStartOffset() < range.getEndOffset();
    }

    private RangeMarker printPage(Graphics2D g2d, PageFormat pageFormat, RangeMarker range) {
        assert (TextPainter.isValidRange(range));
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        this.myOffset = startOffset;
        this.mySegmentEnd = endOffset;
        this.myLineNumber = this.myDocument.getLineNumber(this.myOffset) + 1;
        Rectangle2D.Double clip = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.draw(g2d, clip);
        return this.myOffset > startOffset && this.myOffset < endOffset ? this.myDocument.createRangeMarker(this.myOffset, endOffset) : null;
    }

    private void draw(Graphics2D g2D, Rectangle2D.Double clip) {
        double headerHeight = this.drawHeader(g2D, clip);
        clip.y += headerHeight;
        clip.height -= headerHeight;
        double footerHeight = this.drawFooter(g2D, clip);
        clip.height -= footerHeight;
        Rectangle2D.Double border = (Rectangle2D.Double)clip.clone();
        clip.x += this.getCharWidth(g2D) / 2.0;
        clip.width -= this.getCharWidth(g2D);
        if (this.myPrintSettings.PRINT_LINE_NUMBERS) {
            double numbersStripWidth = this.calcNumbersStripWidth(g2D, clip) + this.getCharWidth(g2D) / 2.0;
            clip.x += numbersStripWidth;
            clip.width -= numbersStripWidth;
        }
        clip.x += this.getCharWidth(g2D) / 2.0;
        clip.width -= this.getCharWidth(g2D);
        this.drawText(g2D, clip);
        this.drawBorder(g2D, border);
    }

    private void drawBorder(Graphics2D g2, Rectangle2D clip) {
        if (this.myPrintSettings.DRAW_BORDER && this.myPerformActualDrawing) {
            Color save2 = g2.getColor();
            g2.setColor(Color.black);
            g2.draw(clip);
            g2.setColor(save2);
        }
    }

    private double getCharWidth(Graphics2D g2) {
        if (this.myCharWidth < 0.0) {
            FontRenderContext fontRenderContext = g2.getFontRenderContext();
            this.myCharWidth = this.myPlainFont.getStringBounds(DEFAULT_MEASURE_WIDTH_TEXT, fontRenderContext).getWidth();
        }
        return this.myCharWidth;
    }

    private void setForegroundColor(Graphics2D g2, Color color) {
        if (color == null || !this.myPrintSettings.COLOR_PRINTING || !this.myPrintSettings.SYNTAX_PRINTING) {
            color = Color.black;
        }
        g2.setColor(color);
    }

    private void setBackgroundColor(Graphics2D g2, Color color) {
        if (color == null || !this.myPrintSettings.COLOR_PRINTING || !this.myPrintSettings.SYNTAX_PRINTING) {
            color = Color.white;
        }
        g2.setColor(color);
    }

    private void setFont(Graphics2D g2, Font font) {
        if (!this.myPrintSettings.SYNTAX_PRINTING) {
            font = this.myPlainFont;
        }
        g2.setFont(font);
    }

    private void drawText(Graphics2D g2, Rectangle2D clip) {
        float lineHeight = this.getLineHeight(g2);
        HighlighterIterator hIterator = this.myHighlighter.createIterator(this.myOffset);
        if (hIterator.atEnd()) {
            this.myOffset = this.mySegmentEnd;
            return;
        }
        LineIterator lIterator = this.myDocument.createLineIterator();
        lIterator.start(this.myOffset);
        if (lIterator.atEnd()) {
            this.myOffset = this.mySegmentEnd;
            return;
        }
        TextAttributes attributes = hIterator.getTextAttributes();
        Color currentColor = attributes.getForegroundColor();
        Color backColor = attributes.getBackgroundColor();
        Color underscoredColor = attributes.getEffectColor();
        Font currentFont = this.getFont(attributes.getFontType());
        this.setForegroundColor(g2, currentColor);
        this.setFont(g2, currentFont);
        g2.translate(clip.getX(), 0.0);
        Point2D.Double position = new Point2D.Double(0.0, clip.getY());
        double lineY = ((Point2D)position).getY();
        if (this.myPerformActualDrawing) {
            this.getMethodSeparator(lIterator.getLineNumber());
        }
        char[] text2 = this.myDocument.getCharsSequence().toString().toCharArray();
        while (!hIterator.atEnd() && !lIterator.atEnd()) {
            int hEnd = hIterator.getEnd();
            int lEnd = lIterator.getEnd();
            int lStart = lIterator.getStart();
            if (hEnd >= lEnd) {
                LineMarkerInfo marker;
                if (!this.drawString(g2, text2, lEnd - lIterator.getSeparatorLength(), this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                    this.drawLineNumber(g2, 0.0, lineY);
                    break;
                }
                this.drawLineNumber(g2, 0.0, lineY);
                lIterator.advance();
                ++this.myLineNumber;
                ((Point2D)position).setLocation(0.0, ((Point2D)position).getY() + (double)lineHeight);
                lineY = ((Point2D)position).getY();
                this.myOffset = lEnd;
                if (this.myPerformActualDrawing && (marker = this.getMethodSeparator(lIterator.getLineNumber())) != null) {
                    Color save2 = g2.getColor();
                    this.setForegroundColor(g2, marker.separatorColor);
                    UIUtil.drawLine((Graphics)g2, (int)0, (int)((int)lineY), (int)((int)clip.getWidth()), (int)((int)lineY));
                    this.setForegroundColor(g2, save2);
                }
                if (!(((Point2D)position).getY() > clip.getY() + clip.getHeight() - (double)lineHeight)) continue;
                break;
            }
            if (hEnd > lEnd - lIterator.getSeparatorLength()) {
                if (!this.drawString(g2, text2, lEnd - lIterator.getSeparatorLength(), this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                    this.drawLineNumber(g2, 0.0, lineY);
                    break;
                }
            } else if (!this.drawString(g2, text2, hEnd, this.myOffset == lStart, position, clip, backColor, underscoredColor)) {
                this.drawLineNumber(g2, 0.0, lineY);
                break;
            }
            hIterator.advance();
            attributes = hIterator.getTextAttributes();
            Color color = attributes.getForegroundColor();
            if (color == null) {
                color = Color.black;
            }
            if (color != currentColor) {
                this.setForegroundColor(g2, color);
                currentColor = color;
            }
            backColor = attributes.getBackgroundColor();
            underscoredColor = attributes.getEffectColor();
            Font font = this.getFont(attributes.getFontType());
            if (font != currentFont) {
                this.setFont(g2, font);
                currentFont = font;
            }
            this.myOffset = hEnd;
        }
        g2.translate(-clip.getX(), 0.0);
    }

    private LineMarkerInfo getMethodSeparator(int line) {
        LineMarkerInfo tmpMarker;
        LineMarkerInfo marker = null;
        while (this.myCurrentMethodSeparator < this.myMethodSeparators.length && (tmpMarker = this.myMethodSeparators[this.myCurrentMethodSeparator]) != null && FileSeparatorProvider.getDisplayLine(tmpMarker, this.myDocument) <= line) {
            marker = tmpMarker;
            ++this.myCurrentMethodSeparator;
        }
        return marker;
    }

    private double drawHeader(Graphics2D g2, Rectangle2D clip) {
        String headerText2;
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g2);
        double w2 = clip.getWidth();
        double x2 = clip.getX();
        double y2 = clip.getY();
        double h2 = 0.0;
        boolean wasDrawn = false;
        String headerText1 = this.myPrintSettings.FOOTER_HEADER_TEXT1;
        if (headerText1 != null && headerText1.length() > 0 && "Header".equals(this.myPrintSettings.FOOTER_HEADER_PLACEMENT1)) {
            h2 = this.drawHeaderOrFooterLine(g2, x2, y2, w2, headerText1, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1);
            wasDrawn = true;
            y2 += h2;
        }
        if ((headerText2 = this.myPrintSettings.FOOTER_HEADER_TEXT2) != null && headerText2.length() > 0 && "Header".equals(this.myPrintSettings.FOOTER_HEADER_PLACEMENT2)) {
            if ("Left".equals(this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1) && "Right".equals(this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2) && wasDrawn) {
                y2 -= h2;
            }
            h2 = this.drawHeaderOrFooterLine(g2, x2, y2, w2, headerText2, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2);
            y2 += h2;
            wasDrawn = true;
        }
        return wasDrawn ? y2 - clip.getY() + (double)(lineMetrics.getHeight() / 3.0f) : 0.0;
    }

    private double drawFooter(Graphics2D g2, Rectangle2D clip) {
        String headerText1;
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g2);
        double w2 = clip.getWidth();
        double x2 = clip.getX();
        double y2 = clip.getY() + clip.getHeight();
        boolean wasDrawn = false;
        double h2 = 0.0;
        y2 -= (double)lineMetrics.getHeight();
        String headerText2 = this.myPrintSettings.FOOTER_HEADER_TEXT2;
        if (headerText2 != null && headerText2.length() > 0 && "Footer".equals(this.myPrintSettings.FOOTER_HEADER_PLACEMENT2)) {
            h2 = this.drawHeaderOrFooterLine(g2, x2, y2, w2, headerText2, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2);
            wasDrawn = true;
        }
        if ((headerText1 = this.myPrintSettings.FOOTER_HEADER_TEXT1) != null && headerText1.length() > 0 && "Footer".equals(this.myPrintSettings.FOOTER_HEADER_PLACEMENT1)) {
            y2 -= (double)lineMetrics.getHeight();
            if ("Left".equals(this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1) && "Right".equals(this.myPrintSettings.FOOTER_HEADER_ALIGNMENT2) && wasDrawn) {
                y2 += h2;
            }
            this.drawHeaderOrFooterLine(g2, x2, y2, w2, headerText1, this.myPrintSettings.FOOTER_HEADER_ALIGNMENT1);
            wasDrawn = true;
        }
        return wasDrawn ? clip.getY() + clip.getHeight() - y2 + (double)(lineMetrics.getHeight() / 4.0f) : 0.0;
    }

    private double drawHeaderOrFooterLine(Graphics2D g2, double x2, double y2, double w2, String headerText, String alignment) {
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        LineMetrics lineMetrics = this.getHeaderFooterLineMetrics(g2);
        float lineHeight = lineMetrics.getHeight();
        if (this.myPerformActualDrawing) {
            headerText = this.convertHeaderText(headerText);
            g2.setFont(this.myHeaderFont);
            g2.setColor(Color.black);
            float descent = lineMetrics.getDescent();
            double width = this.myHeaderFont.getStringBounds(headerText, fontRenderContext).getWidth() + this.getCharWidth(g2);
            float yPos = (float)((double)(lineHeight - descent) + y2);
            if ("Left".equals(alignment)) {
                this.drawStringToGraphics(g2, headerText, x2, yPos);
            } else if ("Center".equals(alignment)) {
                this.drawStringToGraphics(g2, headerText, (float)(x2 + (w2 - width) / 2.0), yPos);
            } else if ("Right".equals(alignment)) {
                this.drawStringToGraphics(g2, headerText, (float)(x2 + w2 - width), yPos);
            }
        }
        return lineHeight;
    }

    private String convertHeaderText(String s2) {
        StringBuilder result2 = new StringBuilder("");
        int start2 = 0;
        boolean isExpression = false;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 != '$') continue;
            String token = s2.substring(start2, i2);
            if (isExpression) {
                if (HEADER_TOKEN_PAGE.equals(token)) {
                    result2.append(this.myPageIndex + 1);
                } else if (HEADER_TOKEN_TOTALPAGES.equals(token)) {
                    result2.append(this.myNumberOfPages);
                } else if (HEADER_TOKEN_FILE.equals(token)) {
                    result2.append(this.myFullFileName);
                } else if (HEADER_TOKEN_FILENAME.equals(token)) {
                    result2.append(this.myShortFileName);
                } else if (HEADER_TOKEN_DATE.equals(token)) {
                    result2.append(this.myPrintDate);
                } else if (HEADER_TOKEN_TIME.equals(token)) {
                    result2.append(this.myPrintTime);
                }
            } else {
                result2.append(token);
            }
            isExpression = !isExpression;
            start2 = i2 + 1;
        }
        if (!isExpression && start2 < s2.length()) {
            result2.append(s2.substring(start2, s2.length()));
        }
        return result2.toString();
    }

    private LineMetrics getHeaderFooterLineMetrics(Graphics2D g2) {
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        return this.myHeaderFont.getLineMetrics(DEFAULT_MEASURE_HEIGHT_TEXT, fontRenderContext);
    }

    private double calcNumbersStripWidth(Graphics2D g2, Rectangle2D clip) {
        if (!this.myPrintSettings.PRINT_LINE_NUMBERS) {
            return 0.0;
        }
        int maxLineNumber = this.myLineNumber + (int)(clip.getHeight() / (double)this.getLineHeight(g2));
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        double numbersStripWidth = 0.0;
        for (int i2 = this.myLineNumber; i2 < maxLineNumber; ++i2) {
            double width = this.myPlainFont.getStringBounds(String.valueOf(i2), fontRenderContext).getWidth();
            if (!(numbersStripWidth < width)) continue;
            numbersStripWidth = width;
        }
        return numbersStripWidth;
    }

    private void drawLineNumber(Graphics2D g2, double x2, double y2) {
        if (!this.myPrintSettings.PRINT_LINE_NUMBERS || !this.myPerformActualDrawing) {
            return;
        }
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        double width = this.myPlainFont.getStringBounds(String.valueOf(this.myLineNumber), fontRenderContext).getWidth() + this.getCharWidth(g2);
        Color savedColor = g2.getColor();
        Font savedFont = g2.getFont();
        g2.setColor(Color.black);
        g2.setFont(this.myPlainFont);
        this.drawStringToGraphics(g2, String.valueOf(this.myLineNumber), x2 - width, (double)(this.getLineHeight(g2) - this.getDescent(g2)) + y2);
        g2.setColor(savedColor);
        g2.setFont(savedFont);
    }

    private boolean drawString(Graphics2D g2, char[] text2, int end, boolean lineStart, Point2D position, Rectangle2D clip, Color backColor, Color underscoredColor) {
        boolean isInClip;
        boolean toContinue = true;
        if (end >= this.mySegmentEnd) {
            end = this.mySegmentEnd;
            toContinue = false;
        }
        if (this.myOffset >= end) {
            return toContinue;
        }
        boolean bl = isInClip = (double)this.getLineHeight(g2) + position.getY() >= clip.getY() && position.getY() <= clip.getY() + clip.getHeight();
        if (!isInClip) {
            return toContinue;
        }
        if (this.myPrintSettings.WRAP) {
            double w2 = this.getTextSegmentWidth(text2, this.myOffset, end - this.myOffset, position.getX(), g2);
            if (position.getX() + w2 > clip.getWidth()) {
                IntArrayList breakOffsets = LineWrapper.calcBreakOffsets(text2, this.myOffset, end, lineStart, position.getX(), clip.getWidth(), (t2, start2, count, x2) -> this.getTextSegmentWidth(t2, start2, count, x2, g2));
                for (int i2 = 0; i2 < breakOffsets.size(); ++i2) {
                    int breakOffset = breakOffsets.get(i2);
                    this.drawTabbedString(g2, text2, breakOffset - this.myOffset, position, backColor, underscoredColor);
                    position.setLocation(0.0, position.getY() + (double)this.getLineHeight(g2));
                    if (!(position.getY() > clip.getY() + clip.getHeight() - (double)this.getLineHeight(g2))) continue;
                    return false;
                }
            }
        }
        this.drawTabbedString(g2, text2, end - this.myOffset, position, backColor, underscoredColor);
        return toContinue;
    }

    private void drawTabbedString(Graphics2D g2, char[] text2, int length, Point2D position, Color backColor, Color underscoredColor) {
        ProgressManager.checkCanceled();
        if (length <= 0) {
            return;
        }
        double xStart = position.getX();
        double x2 = position.getX();
        double y2 = (double)(this.getLineHeight(g2) - this.getDescent(g2)) + position.getY();
        if (backColor != null && this.myPerformActualDrawing) {
            Color savedColor = g2.getColor();
            this.setBackgroundColor(g2, backColor);
            double w2 = this.getTextSegmentWidth(text2, this.myOffset, length, position.getX(), g2);
            g2.fill(new Area(new Rectangle2D.Double(position.getX(), y2 - (double)this.getLineHeight(g2) + (double)this.getDescent(g2), w2, this.getLineHeight(g2))));
            g2.setColor(savedColor);
        }
        int start2 = this.myOffset;
        for (int i2 = this.myOffset; i2 < this.myOffset + length; ++i2) {
            if (text2[i2] != '\t') continue;
            if (i2 > start2) {
                String s2 = new String(text2, start2, i2 - start2);
                x2 += this.drawStringToGraphics(g2, s2, x2, y2);
            }
            x2 = this.nextTabStop(g2, x2);
            start2 = i2 + 1;
        }
        if (this.myOffset + length > start2) {
            String s3 = new String(text2, start2, this.myOffset + length - start2);
            x2 += this.drawStringToGraphics(g2, s3, x2, y2);
        }
        if (underscoredColor != null && this.myPerformActualDrawing) {
            Color savedColor = g2.getColor();
            this.setForegroundColor(g2, underscoredColor);
            double w3 = this.getTextSegmentWidth(text2, this.myOffset, length, position.getX(), g2);
            UIUtil.drawLine((Graphics)g2, (int)((int)position.getX()), (int)((int)y2 + 1), (int)((int)(xStart + w3)), (int)((int)(y2 + 1.0)));
            g2.setColor(savedColor);
        }
        position.setLocation(x2, position.getY());
        this.myOffset += length;
    }

    private double drawStringToGraphics(Graphics2D g2, String s2, double x2, double y2) {
        if (!this.myPrintSettings.PRINT_AS_GRAPHICS) {
            if (this.myPerformActualDrawing) {
                g2.drawString(s2, (float)x2, (float)y2);
            }
            return g2.getFontMetrics().stringWidth(s2);
        }
        GlyphVector v2 = g2.getFont().createGlyphVector(g2.getFontRenderContext(), s2);
        if (this.myPerformActualDrawing) {
            g2.translate(x2, y2);
            g2.fill(v2.getOutline());
            g2.translate(-x2, -y2);
        }
        return v2.getLogicalBounds().getWidth();
    }

    private double getTextSegmentWidth(char[] text2, int offset, int length, double x2, Graphics2D g2) {
        int start2 = offset;
        double startX = x2;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            if (text2[i2] != '\t') continue;
            if (i2 > start2) {
                x2 += TextPainter.getStringWidth(g2, text2, start2, i2 - start2);
            }
            x2 = this.nextTabStop(g2, x2);
            start2 = i2 + 1;
        }
        if (offset + length > start2) {
            x2 += TextPainter.getStringWidth(g2, text2, start2, offset + length - start2);
        }
        return x2 - startX;
    }

    private static double getStringWidth(Graphics2D g2, char[] text2, int start2, int count) {
        String s2 = new String(text2, start2, count);
        GlyphVector v2 = g2.getFont().createGlyphVector(g2.getFontRenderContext(), s2);
        return v2.getLogicalBounds().getWidth();
    }

    public double nextTabStop(Graphics2D g2, double x2) {
        double tabSize = this.myCodeStyleSettings.getTabSize(this.myFileType);
        if (tabSize <= 0.0) {
            tabSize = 1.0;
        }
        int nTabs = (int)(x2 / (tabSize *= g2.getFont().getStringBounds(" ", g2.getFontRenderContext()).getWidth()));
        return (double)(nTabs + 1) * tabSize;
    }

    @Override
    void dispose() {
        this.setSegment(null);
    }
}

