/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.ColorGenerator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.SchemeMetaInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.UIBundle;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RainbowHighlighter {
    private static final JBColor[] RAINBOW_JB_COLORS_DEFAULT = new JBColor[]{new JBColor(10173290, 5414226), new JBColor(1133943, 12480624), new JBColor(12355152, 4028022), new JBColor(22800, 12491120), new JBColor(12341584, 10310268)};
    public static final TextAttributesKey[] RAINBOW_COLOR_KEYS = new TextAttributesKey[RAINBOW_JB_COLORS_DEFAULT.length];
    private static final int RAINBOW_COLORS_BETWEEN = 4;
    private static final String UNIT_TEST_COLORS = "#000001,#000002,#000003,#000004";
    private static final String INHERITED = "inherited";
    public static final String RAINBOW_TYPE = "rainbow";
    private static final String RAINBOW_TEMP_PREF = "RAINBOW_TEMP_";
    public static final TextAttributesKey RAINBOW_ANCHOR;
    public static final TextAttributesKey RAINBOW_GRADIENT_DEMO;
    public static final Boolean DEFAULT_RAINBOW_ON;
    @NotNull
    private final TextAttributesScheme myColorsScheme;
    @NotNull
    private final Color[] myRainbowColors;
    public static final HighlightInfoType RAINBOW_ELEMENT;
    private static final TextAttributesKey[] RAINBOW_TEMP_KEYS;

    public RainbowHighlighter(@Nullable TextAttributesScheme colorsScheme) {
        this.myColorsScheme = colorsScheme != null ? colorsScheme : EditorColorsManager.getInstance().getGlobalScheme();
        this.myRainbowColors = RainbowHighlighter.generateColorSequence(this.myColorsScheme);
    }

    @Nullable
    @Contract(value="_, null -> !null")
    public static Boolean isRainbowEnabled(@Nullable TextAttributesScheme colorsScheme, @Nullable Language language) {
        if (colorsScheme instanceof SchemeMetaInfo) {
            String value2 = ((SchemeMetaInfo)colorsScheme).getMetaProperties().getProperty(RainbowHighlighter.getKey(language), INHERITED);
            if (String.valueOf(true).equals(value2)) {
                return Boolean.TRUE;
            }
            if (String.valueOf(false).equals(value2)) {
                return Boolean.FALSE;
            }
            return language == null ? DEFAULT_RAINBOW_ON : null;
        }
        return false;
    }

    public static boolean isRainbowEnabledWithInheritance(@Nullable TextAttributesScheme colorsScheme, @Nullable Language language) {
        Boolean rainbowEnabled = RainbowHighlighter.isRainbowEnabled(colorsScheme, language);
        return rainbowEnabled != null ? rainbowEnabled : RainbowHighlighter.isRainbowEnabled(colorsScheme, null);
    }

    public static void setRainbowEnabled(@NotNull SchemeMetaInfo colorsScheme, @Nullable Language language, @Nullable Boolean enabled) {
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeHighlighting/RainbowHighlighter", "setRainbowEnabled"));
        }
        Properties properties = colorsScheme.getMetaProperties();
        String key = RainbowHighlighter.getKey(language);
        if (enabled == null || language == null && enabled == DEFAULT_RAINBOW_ON) {
            properties.remove(key);
        } else {
            properties.setProperty(key, String.valueOf(enabled));
        }
    }

    @NotNull
    private static String getKey(@Nullable Language language) {
        String string2 = "rainbow " + (language == null ? UIBundle.message((String)"color.settings.common.default.language", (Object[])new Object[0]) : language.getID());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "getKey"));
        }
        return string2;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isRainbowKey(@Nullable Object key) {
        return key instanceof String && ((String)key).startsWith(RAINBOW_TYPE);
    }

    public static void transferRainbowState(@NotNull SchemeMetaInfo dst, @NotNull SchemeMetaInfo src) {
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/codeHighlighting/RainbowHighlighter", "transferRainbowState"));
        }
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/codeHighlighting/RainbowHighlighter", "transferRainbowState"));
        }
        Properties dstProps = dst.getMetaProperties();
        dstProps.entrySet().removeIf(entry -> RainbowHighlighter.isRainbowKey(entry.getKey()));
        src.getMetaProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value2) -> {
            if (RainbowHighlighter.isRainbowKey(key) && value2 instanceof String) {
                dstProps.setProperty((String)key, (String)value2);
            }
        }));
    }

    @NotNull
    public static String generatePaletteExample(@NotNull String indent) {
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indent", "com/intellij/codeHighlighting/RainbowHighlighter", "generatePaletteExample"));
        }
        int stopCount = RAINBOW_COLOR_KEYS.length;
        StringBuilder sb2 = new StringBuilder();
        sb2.append(indent).append(UIBundle.message((String)"color.settings.rainbow.demo.header.1", (Object[])new Object[0])).append(indent).append(UIBundle.message((String)"color.settings.rainbow.demo.header.2", (Object[])new Object[0])).append(indent);
        String tagRainbow = RAINBOW_GRADIENT_DEMO.getExternalName();
        boolean needLineBreak = true;
        for (int i2 = 0; i2 < RAINBOW_TEMP_KEYS.length; ++i2) {
            sb2.append(" ");
            sb2.append("<").append(tagRainbow).append(">");
            String anchor = String.valueOf(i2 / stopCount + 1);
            String minor = String.valueOf(i2 % stopCount);
            sb2.append(i2 % stopCount == 0 ? "Color#" + anchor : "SC" + anchor + "." + minor);
            sb2.append("</").append(tagRainbow).append(">");
            if (!needLineBreak || i2 != RAINBOW_TEMP_KEYS.length / 2) continue;
            sb2.append(indent);
            needLineBreak = false;
            --i2;
        }
        String string2 = sb2.toString();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "generatePaletteExample"));
        }
        return string2;
    }

    @NotNull
    @Contract(pure=true)
    private Color calculateForeground(int colorIndex) {
        Color color = this.myRainbowColors[colorIndex];
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "calculateForeground"));
        }
        return color;
    }

    public int getColorsCount() {
        return this.myRainbowColors.length;
    }

    @NotNull
    private static Color[] generateColorSequence(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeHighlighting/RainbowHighlighter", "generateColorSequence"));
        }
        String colorDump = ApplicationManager.getApplication().isUnitTestMode() ? UNIT_TEST_COLORS : Registry.get((String)"rainbow.highlighter.colors").asString();
        List registryColors = StringUtil.split((String)colorDump, (String)",");
        if (!registryColors.isEmpty()) {
            Color[] colorArray = (Color[])registryColors.stream().map(s2 -> ColorUtil.fromHex((String)s2.trim())).toArray(Color[]::new);
            if (colorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "generateColorSequence"));
            }
            return colorArray;
        }
        List stopColors = ContainerUtil.map((Object[])RAINBOW_COLOR_KEYS, key -> {
            if (colorsScheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeHighlighting/RainbowHighlighter", "lambda$generateColorSequence$4"));
            }
            return colorsScheme.getAttributes(key).getForegroundColor();
        });
        List<Color> colors = ColorGenerator.generateLinearColorSequence(stopColors, 4);
        Color[] colorArray = colors.toArray(new Color[colors.size()]);
        if (colorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "generateColorSequence"));
        }
        return colorArray;
    }

    @NotNull
    public TextAttributesKey[] getRainbowTempKeys() {
        TextAttributesKey[] keys = new TextAttributesKey[this.myRainbowColors.length];
        for (int i2 = 0; i2 < this.myRainbowColors.length; ++i2) {
            TextAttributesKey key = TextAttributesKey.createTextAttributesKey((String)(RAINBOW_TEMP_PREF + i2), (TextAttributes)new TextAttributes());
            key.getDefaultAttributes().setForegroundColor(this.myRainbowColors[i2]);
            keys[i2] = key;
        }
        if (keys == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "getRainbowTempKeys"));
        }
        return keys;
    }

    public static boolean isRainbowTempKey(TextAttributesKey key) {
        return key.getExternalName().startsWith(RAINBOW_TEMP_PREF);
    }

    public HighlightInfo getInfo(int colorIndex, @Nullable PsiElement id, @Nullable TextAttributesKey colorKey) {
        return id == null ? null : this.getInfoBuilder(colorIndex, colorKey).range(id).create();
    }

    public HighlightInfo getInfo(int colorIndex, int start2, int end, @Nullable TextAttributesKey colorKey) {
        return this.getInfoBuilder(colorIndex, colorKey).range(start2, end).create();
    }

    @NotNull
    protected HighlightInfo.Builder getInfoBuilder(int colorIndex, @Nullable TextAttributesKey colorKey) {
        if (colorKey == null) {
            colorKey = DefaultLanguageHighlighterColors.LOCAL_VARIABLE;
        }
        HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(RAINBOW_ELEMENT).textAttributes(TextAttributes.fromFlyweight((AttributesFlyweight)this.myColorsScheme.getAttributes(colorKey).getFlyweight().withForeground(this.calculateForeground(colorIndex))));
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "getInfoBuilder"));
        }
        return builder;
    }

    @NotNull
    public static TextAttributes createRainbowAttribute(@Nullable Color color) {
        TextAttributes ret = new TextAttributes();
        ret.setForegroundColor(color);
        TextAttributes textAttributes = ret;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "createRainbowAttribute"));
        }
        return textAttributes;
    }

    public static Map<String, TextAttributesKey> createRainbowHLM() {
        HashMap<String, TextAttributesKey> hashMap = new HashMap<String, TextAttributesKey>();
        hashMap.put(RAINBOW_ANCHOR.getExternalName(), RAINBOW_ANCHOR);
        hashMap.put(RAINBOW_GRADIENT_DEMO.getExternalName(), RAINBOW_GRADIENT_DEMO);
        for (TextAttributesKey key : RAINBOW_TEMP_KEYS) {
            hashMap.put(key.getExternalName(), key);
        }
        return hashMap;
    }

    static {
        for (int i2 = 0; i2 < RAINBOW_JB_COLORS_DEFAULT.length; ++i2) {
            RainbowHighlighter.RAINBOW_COLOR_KEYS[i2] = TextAttributesKey.createTextAttributesKey((String)("RAINBOW_COLOR" + i2), (TextAttributes)RainbowHighlighter.createRainbowAttribute((Color)RAINBOW_JB_COLORS_DEFAULT[i2]));
        }
        RAINBOW_ANCHOR = TextAttributesKey.createTextAttributesKey((String)RAINBOW_TYPE, (TextAttributes)new TextAttributes());
        RAINBOW_GRADIENT_DEMO = TextAttributesKey.createTextAttributesKey((String)"rainbow_demo", (TextAttributes)new TextAttributes());
        DEFAULT_RAINBOW_ON = Boolean.FALSE;
        RAINBOW_ELEMENT = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, DefaultLanguageHighlighterColors.CONSTANT);
        RAINBOW_TEMP_KEYS = new RainbowHighlighter(null).getRainbowTempKeys();
    }
}

