/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementEvaluator;
import com.intellij.codeInsight.TargetElementEvaluatorEx;
import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.TargetElementUtilExtender;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetElementUtil
extends TargetElementUtilBase {
    public static final int REFERENCED_ELEMENT_ACCEPTED = 1;
    public static final int ELEMENT_NAME_ACCEPTED = 2;
    public static final int LOOKUP_ITEM_ACCEPTED = 8;
    protected final LanguageExtension<TargetElementEvaluator> targetElementEvaluator = new LanguageExtension("com.intellij.targetElementEvaluator");

    public static TargetElementUtil getInstance() {
        return (TargetElementUtil)ServiceManager.getService(TargetElementUtil.class);
    }

    @Override
    public int getAllAccepted() {
        int result2 = 11;
        for (TargetElementUtilExtender each : (TargetElementUtilExtender[])Extensions.getExtensions(TargetElementUtilExtender.EP_NAME)) {
            result2 |= each.getAllAdditionalFlags();
        }
        return result2;
    }

    @Override
    public int getDefinitionSearchFlags() {
        int result2 = this.getAllAccepted();
        for (TargetElementUtilExtender each : (TargetElementUtilExtender[])Extensions.getExtensions(TargetElementUtilExtender.EP_NAME)) {
            result2 |= each.getAdditionalDefinitionSearchFlags();
        }
        return result2;
    }

    @Override
    public int getReferenceSearchFlags() {
        int result2 = this.getAllAccepted();
        for (TargetElementUtilExtender each : (TargetElementUtilExtender[])Extensions.getExtensions(TargetElementUtilExtender.EP_NAME)) {
            result2 |= each.getAdditionalReferenceSearchFlags();
        }
        return result2;
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/TargetElementUtil", "findReference"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiReference result2 = TargetElementUtil.findReference(editor, offset);
        if (result2 == null) {
            int expectedCaretOffset;
            int n2 = expectedCaretOffset = editor instanceof EditorEx ? ((EditorEx)editor).getExpectedCaretOffset() : offset;
            if (expectedCaretOffset != offset) {
                result2 = TargetElementUtil.findReference(editor, expectedCaretOffset);
            }
        }
        return result2;
    }

    @Nullable
    public static PsiReference findReference(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/TargetElementUtil", "findReference"));
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        offset = TargetElementUtil.adjustOffset(file2, document, offset);
        return file2.findReferenceAt(offset);
    }

    public static int adjustOffset(Document document, int offset) {
        return TargetElementUtil.adjustOffset(null, document, offset);
    }

    public static int adjustOffset(@Nullable PsiFile file2, Document document, int offset) {
        CharSequence text2 = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!TargetElementUtil.isIdentifierPart(file2, text2, offset)) {
            --correctedOffset;
        }
        if (correctedOffset < 0 || !TargetElementUtil.isIdentifierPart(file2, text2, correctedOffset)) {
            return offset;
        }
        return correctedOffset;
    }

    private static boolean isIdentifierPart(@Nullable PsiFile file2, CharSequence text2, int offset) {
        TargetElementEvaluatorEx evaluator2;
        if (file2 != null && (evaluator2 = TargetElementUtil.getInstance().getElementEvaluatorsEx(file2.getLanguage())) != null && evaluator2.isIdentifierPart(file2, text2, offset)) {
            return true;
        }
        return Character.isJavaIdentifierPart(text2.charAt(offset));
    }

    public static boolean inVirtualSpace(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/TargetElementUtil", "inVirtualSpace"));
        }
        return offset == editor.getCaretModel().getOffset() && EditorUtil.inVirtualSpace(editor, editor.getCaretModel().getLogicalPosition());
    }

    @Nullable
    public static PsiElement findTargetElement(Editor editor, int flags) {
        int expectedCaretOffset;
        ApplicationManager.getApplication().assertIsDispatchThread();
        int offset = editor.getCaretModel().getOffset();
        PsiElement result2 = TargetElementUtil.getInstance().findTargetElement(editor, flags, offset);
        if (result2 != null) {
            return result2;
        }
        int n2 = expectedCaretOffset = editor instanceof EditorEx ? ((EditorEx)editor).getExpectedCaretOffset() : offset;
        if (expectedCaretOffset != offset) {
            return TargetElementUtil.getInstance().findTargetElement(editor, flags, expectedCaretOffset);
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor, int flags, int offset) {
        TargetElementEvaluatorEx2 evaluator2;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/TargetElementUtil", "findTargetElement"));
        }
        PsiElement result2 = this.doFindTargetElement(editor, flags, offset);
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator2 = result2 != null ? this.getElementEvaluatorsEx2(result2.getLanguage()) : null;
        if (evaluator2 != null) {
            result2 = evaluator2.adjustTargetElement(editor, offset, flags, result2);
        }
        return result2;
    }

    @Nullable
    private PsiElement doFindTargetElement(@NotNull Editor editor, int flags, int offset) {
        PsiElement referenceOrReferencedElement;
        PsiElement element;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/TargetElementUtil", "doFindTargetElement"));
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        if (BitUtil.isSet((int)flags, (int)8) && (element = TargetElementUtil.getTargetElementFromLookup(project2)) != null) {
            return element;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        offset = TargetElementUtil.adjustOffset(file2, document, offset);
        PsiElement element2 = file2.findElementAt(offset);
        if (BitUtil.isSet((int)flags, (int)1) && this.isAcceptableReferencedElement(element2, referenceOrReferencedElement = this.getReferenceOrReferencedElement(file2, editor, flags, offset))) {
            return referenceOrReferencedElement;
        }
        if (element2 == null) {
            return null;
        }
        if (BitUtil.isSet((int)flags, (int)2)) {
            if (element2 instanceof PsiNamedElement) {
                return element2;
            }
            return this.getNamedElement(element2, offset - element2.getTextRange().getStartOffset());
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElementFromLookup(Project project2) {
        PsiElement psi;
        LookupElement item;
        LookupEx activeLookup = LookupManager.getInstance(project2).getActiveLookup();
        if (activeLookup != null && (item = activeLookup.getCurrentItem()) != null && item.isValid() && (psi = CompletionUtil.getTargetElement(item)) != null && psi.isValid()) {
            return psi;
        }
        return null;
    }

    protected boolean isAcceptableReferencedElement(@Nullable PsiElement element, @Nullable PsiElement referenceOrReferencedElement) {
        TargetElementEvaluatorEx2 evaluator2;
        if (referenceOrReferencedElement == null || !referenceOrReferencedElement.isValid()) {
            return false;
        }
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator2 = element != null ? this.getElementEvaluatorsEx2(element.getLanguage()) : null;
        if (evaluator2 != null) {
            ThreeState answer = evaluator2.isAcceptableReferencedElement(element, referenceOrReferencedElement);
            if (answer == ThreeState.YES) {
                return true;
            }
            if (answer == ThreeState.NO) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, @Nullable PsiElement element, @Nullable PsiElement contextElement) {
        TargetElementEvaluatorEx2 evaluator2;
        PsiElement langElement = element == null ? contextElement : element;
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator2 = langElement != null ? this.getElementEvaluatorsEx2(langElement.getLanguage()) : null;
        if (evaluator2 != null) {
            element = evaluator2.adjustElement(editor, flags, element, contextElement);
        }
        return element;
    }

    @Override
    @Nullable
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/TargetElementUtil", "adjustReference"));
        }
        PsiElement element = ref.getElement();
        TargetElementEvaluatorEx2 evaluator2 = element != null ? this.getElementEvaluatorsEx2(element.getLanguage()) : null;
        return evaluator2 != null ? evaluator2.adjustReference(ref) : null;
    }

    @Override
    @Nullable
    public PsiElement getNamedElement(@Nullable PsiElement element, int offsetInElement) {
        if (element == null) {
            return null;
        }
        ArrayList targets = ContainerUtil.newArrayList();
        Consumer consumer2 = target -> {
            if (target instanceof PsiDeclaredTarget) {
                PsiDeclaredTarget declaredTarget = (PsiDeclaredTarget)target;
                PsiElement navigationElement = declaredTarget.getNavigationElement();
                TextRange range = declaredTarget.getNameIdentifierRange();
                if (range != null && !range.shiftRight(navigationElement.getTextRange().getStartOffset()).contains(element.getTextRange().getStartOffset() + offsetInElement)) {
                    return;
                }
            }
            targets.add(target);
        };
        int offset = offsetInElement;
        for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
            for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
                searcher.findDeclarationsAt(parent, offset, consumer2);
                if (targets.isEmpty()) continue;
                PomTarget target2 = (PomTarget)targets.get(0);
                return target2 == null ? null : PomService.convertToPsi((Project)element.getProject(), (PomTarget)target2);
            }
            offset += parent.getStartOffsetInParent();
        }
        return this.getNamedElement(element);
    }

    @Nullable
    private PsiElement getNamedElement(@Nullable PsiElement element) {
        PsiElement result2;
        if (element == null) {
            return null;
        }
        TargetElementEvaluatorEx2 evaluator2 = this.getElementEvaluatorsEx2(element.getLanguage());
        if (evaluator2 != null && (result2 = evaluator2.getNamedElement(element)) != null) {
            return result2;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, PsiNamedElement.class, (boolean)false);
        if (parent != null) {
            boolean isInjected;
            boolean bl = isInjected = parent instanceof PsiFile && InjectedLanguageManager.getInstance((Project)parent.getProject()).isInjectedFragment((PsiFile)parent);
            if (!isInjected && parent.getTextOffset() == element.getTextRange().getStartOffset() && (evaluator2 == null || evaluator2.isAcceptableNamedParent(parent))) {
                return parent;
            }
        }
        return null;
    }

    @Nullable
    private PsiElement getReferenceOrReferencedElement(PsiFile file2, Editor editor, int flags, int offset) {
        PsiElement result2 = this.doGetReferenceOrReferencedElement(file2, editor, flags, offset);
        PsiElement languageElement = file2.findElementAt(offset);
        Language language = languageElement != null ? languageElement.getLanguage() : file2.getLanguage();
        TargetElementEvaluatorEx2 evaluator2 = this.getElementEvaluatorsEx2(language);
        if (evaluator2 != null) {
            result2 = evaluator2.adjustReferenceOrReferencedElement(file2, editor, offset, flags, result2);
        }
        return result2;
    }

    @Nullable
    private PsiElement doGetReferenceOrReferencedElement(PsiFile file2, Editor editor, int flags, int offset) {
        PsiElement element;
        PsiReference ref = TargetElementUtil.findReference(editor, offset);
        if (ref == null) {
            return null;
        }
        Language language = ref.getElement().getLanguage();
        TargetElementEvaluator evaluator2 = (TargetElementEvaluator)this.targetElementEvaluator.forLanguage(language);
        if (evaluator2 != null && (element = evaluator2.getElementByReference(ref, flags)) != null) {
            return element;
        }
        PsiManager manager = file2.getManager();
        PsiElement refElement = ref.resolve();
        if (refElement == null) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                DaemonCodeAnalyzer.getInstance((Project)manager.getProject()).updateVisibleHighlighters(editor);
            }
            return null;
        }
        return refElement;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getTargetCandidates(@NotNull PsiReference reference) {
        Collection<PsiElement> candidates;
        TargetElementEvaluatorEx2 evaluator2;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/TargetElementUtil", "getTargetCandidates"));
        }
        PsiElement refElement = reference.getElement();
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator2 = refElement != null ? this.getElementEvaluatorsEx2(refElement.getLanguage()) : null;
        if (evaluator2 != null && (candidates = evaluator2.getTargetCandidates(reference)) != null) {
            Collection<PsiElement> collection = candidates;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/TargetElementUtil", "getTargetCandidates"));
            }
            return collection;
        }
        if (reference instanceof PsiPolyVariantReference) {
            ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
            ArrayList<PsiElement> navigatableResults = new ArrayList<PsiElement>(results.length);
            for (ResolveResult r2 : results) {
                PsiElement element = r2.getElement();
                if (!EditSourceUtil.canNavigate((PsiElement)element) && (!(element instanceof Navigatable) || !((Navigatable)element).canNavigateToSource())) continue;
                navigatableResults.add(element);
            }
            ArrayList<PsiElement> arrayList = navigatableResults;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/TargetElementUtil", "getTargetCandidates"));
            }
            return arrayList;
        }
        PsiElement resolved = reference.resolve();
        if (resolved instanceof NavigationItem) {
            Set<PsiElement> set2 = Collections.singleton(resolved);
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/TargetElementUtil", "getTargetCandidates"));
            }
            return set2;
        }
        List<PsiElement> list2 = Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/TargetElementUtil", "getTargetCandidates"));
        }
        return list2;
    }

    @Override
    public PsiElement getGotoDeclarationTarget(PsiElement element, PsiElement navElement) {
        PsiElement result2;
        TargetElementEvaluatorEx2 evaluator2;
        TargetElementEvaluatorEx2 targetElementEvaluatorEx2 = evaluator2 = element != null ? this.getElementEvaluatorsEx2(element.getLanguage()) : null;
        if (evaluator2 != null && (result2 = evaluator2.getGotoDeclarationTarget(element, navElement)) != null) {
            return result2;
        }
        return navElement;
    }

    @Override
    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/TargetElementUtil", "includeSelfInGotoImplementation"));
        }
        TargetElementEvaluator evaluator2 = (TargetElementEvaluator)this.targetElementEvaluator.forLanguage(element.getLanguage());
        return evaluator2 == null || evaluator2.includeSelfInGotoImplementation(element);
    }

    @Override
    public boolean acceptImplementationForReference(@Nullable PsiReference reference, @Nullable PsiElement element) {
        TargetElementEvaluatorEx2 evaluator2 = element != null ? this.getElementEvaluatorsEx2(element.getLanguage()) : null;
        return evaluator2 == null || evaluator2.acceptImplementationForReference(reference, element);
    }

    @Override
    @NotNull
    public SearchScope getSearchScope(Editor editor, @NotNull PsiElement element) {
        SearchScope result2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/TargetElementUtil", "getSearchScope"));
        }
        TargetElementEvaluatorEx2 evaluator2 = this.getElementEvaluatorsEx2(element.getLanguage());
        SearchScope searchScope = result2 = evaluator2 != null ? evaluator2.getSearchScope(editor, element) : null;
        if (result2 != null) {
            SearchScope searchScope2 = result2;
            if (searchScope2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/TargetElementUtil", "getSearchScope"));
            }
            return searchScope2;
        }
        PsiFile file2 = element.getContainingFile();
        SearchScope searchScope3 = PsiSearchHelper.SERVICE.getInstance((Project)element.getProject()).getUseScope((PsiElement)(file2 != null ? file2 : element));
        if (searchScope3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/TargetElementUtil", "getSearchScope"));
        }
        return searchScope3;
    }

    @Nullable
    private TargetElementEvaluatorEx getElementEvaluatorsEx(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/TargetElementUtil", "getElementEvaluatorsEx"));
        }
        TargetElementEvaluator result2 = (TargetElementEvaluator)this.targetElementEvaluator.forLanguage(language);
        return result2 instanceof TargetElementEvaluatorEx ? (TargetElementEvaluatorEx)result2 : null;
    }

    @Nullable
    private TargetElementEvaluatorEx2 getElementEvaluatorsEx2(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/codeInsight/TargetElementUtil", "getElementEvaluatorsEx2"));
        }
        TargetElementEvaluator result2 = (TargetElementEvaluator)this.targetElementEvaluator.forLanguage(language);
        return result2 instanceof TargetElementEvaluatorEx2 ? (TargetElementEvaluatorEx2)result2 : null;
    }
}

