/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class FileTreeIterator {
    private Queue<PsiFile> myCurrentFiles;
    private Queue<PsiDirectory> myCurrentDirectories;

    public FileTreeIterator(@NotNull List<PsiFile> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/FileTreeIterator", "<init>"));
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentFiles.addAll(files2);
    }

    public FileTreeIterator(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/actions/FileTreeIterator", "<init>"));
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentDirectories.addAll(FileTreeIterator.collectModuleDirectories(module2));
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    public FileTreeIterator(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FileTreeIterator", "<init>"));
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentDirectories.addAll(FileTreeIterator.collectProjectDirectories(project2));
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    @NotNull
    public static List<PsiDirectory> collectProjectDirectories(@NotNull Project project2) {
        Module[] modules;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FileTreeIterator", "collectProjectDirectories"));
        }
        ArrayList directories = ContainerUtil.newArrayList();
        for (Module module2 : modules = ModuleManager.getInstance((Project)project2).getModules()) {
            directories.addAll(FileTreeIterator.collectModuleDirectories(module2));
        }
        ArrayList arrayList = directories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FileTreeIterator", "collectProjectDirectories"));
        }
        return arrayList;
    }

    public FileTreeIterator(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/codeInsight/actions/FileTreeIterator", "<init>"));
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentDirectories.add(directory);
        this.expandDirectoriesUntilFilesNotEmpty();
    }

    public FileTreeIterator(@NotNull FileTreeIterator fileTreeIterator) {
        if (fileTreeIterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTreeIterator", "com/intellij/codeInsight/actions/FileTreeIterator", "<init>"));
        }
        this.myCurrentFiles = new LinkedList<PsiFile>();
        this.myCurrentDirectories = new LinkedList<PsiDirectory>();
        this.myCurrentFiles = new LinkedList<PsiFile>(fileTreeIterator.myCurrentFiles);
        this.myCurrentDirectories = new LinkedList<PsiDirectory>(fileTreeIterator.myCurrentDirectories);
    }

    @NotNull
    public PsiFile next() {
        if (this.myCurrentFiles.isEmpty()) {
            throw new NoSuchElementException();
        }
        PsiFile current = this.myCurrentFiles.poll();
        this.expandDirectoriesUntilFilesNotEmpty();
        PsiFile psiFile = current;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FileTreeIterator", "next"));
        }
        return psiFile;
    }

    public boolean hasNext() {
        return !this.myCurrentFiles.isEmpty();
    }

    private void expandDirectoriesUntilFilesNotEmpty() {
        while (this.myCurrentFiles.isEmpty() && !this.myCurrentDirectories.isEmpty()) {
            PsiDirectory dir = this.myCurrentDirectories.poll();
            this.expandDirectory(dir);
        }
    }

    private void expandDirectory(@NotNull PsiDirectory dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/codeInsight/actions/FileTreeIterator", "expandDirectory"));
        }
        Collections.addAll(this.myCurrentFiles, dir.getFiles());
        Collections.addAll(this.myCurrentDirectories, dir.getSubdirectories());
    }

    @NotNull
    public static List<PsiDirectory> collectModuleDirectories(Module module2) {
        VirtualFile[] contentRoots;
        ArrayList dirs = ContainerUtil.newArrayList();
        for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            PsiDirectory dir = PsiManager.getInstance((Project)module2.getProject()).findDirectory(root);
            if (dir == null) continue;
            dirs.add(dir);
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FileTreeIterator", "collectModuleDirectories"));
        }
        return arrayList;
    }
}

