/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.formatting.FormattingProgressTask;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatCodeProcessor
extends AbstractLayoutCodeProcessor {
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.reformat.code", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.ReformatCodeProcessor");
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"reformat.progress.common.text", (Object[])new Object[0]);
    private final Collection<TextRange> myRanges;
    private SelectionModel mySelectionModel;

    public ReformatCodeProcessor(Project project2, boolean processChangedTextOnly) {
        super(project2, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, @NotNull SelectionModel selectionModel) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "<init>"));
        }
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "<init>"));
        }
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, false);
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, @NotNull SelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionModel", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "<init>"));
        }
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
        this.myRanges = new ArrayList<TextRange>();
        this.mySelectionModel = selectionModel;
    }

    public ReformatCodeProcessor(AbstractLayoutCodeProcessor processor2, boolean processChangedTextOnly) {
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
        this.myRanges = new ArrayList<TextRange>();
        this.setProcessChangedTextOnly(processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, Module module2, boolean processChangedTextOnly) {
        super(project2, module2, COMMAND_NAME, PROGRESS_TEXT, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project2, PsiDirectory directory, boolean includeSubdirs, boolean processChangedTextOnly) {
        super(project2, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project2, PsiFile file2, @Nullable TextRange range, boolean processChangedTextOnly) {
        super(project2, file2, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
        if (range != null) {
            this.myRanges.add(range);
        }
    }

    public ReformatCodeProcessor(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "<init>"));
        }
        super(file2.getProject(), file2, PROGRESS_TEXT, COMMAND_NAME, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    public ReformatCodeProcessor(Project project2, PsiFile[] files2, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        this(project2, files2, COMMAND_NAME, postRunnable, processChangedTextOnly);
    }

    public ReformatCodeProcessor(Project project2, PsiFile[] files2, String commandName, @Nullable Runnable postRunnable, boolean processChangedTextOnly) {
        super(project2, files2, PROGRESS_TEXT, commandName, postRunnable, processChangedTextOnly);
        this.myRanges = new ArrayList<TextRange>();
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) throws IncorrectOperationException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareTask"));
        }
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "lambda$prepareTask$0"));
            }
            FormattingProgressTask.FORMATTING_CANCELLED_FLAG.set(false);
            try {
                CharSequence before = null;
                Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file2);
                if (this.getInfoCollector() != null) {
                    LOG.assertTrue(document != null);
                    before = document.getImmutableCharSequence();
                }
                CaretVisualPositionKeeper caretPositionKeeper = new CaretVisualPositionKeeper(document);
                if (processChangedTextOnly) {
                    ChangedRangesInfo info = FormatChangedTextUtil.getInstance().getChangedRangesInfo(file2);
                    if (info != null) {
                        CodeStyleManager.getInstance((Project)this.myProject).reformatTextWithContext(file2, info);
                    }
                } else {
                    Collection<TextRange> ranges = this.getRangesToFormat(file2);
                    CodeStyleManager.getInstance((Project)this.myProject).reformatText(file2, ranges);
                }
                caretPositionKeeper.restoreOriginalLocation();
                if (before != null) {
                    this.prepareUserNotificationMessage(document, before);
                }
                Boolean bl = FormattingProgressTask.FORMATTING_CANCELLED_FLAG.get() == false;
                return bl;
            }
            catch (FilesTooBigForDiffException e2) {
                this.handleFileTooBigException(LOG, e2, file2);
                Boolean bl = false;
                return bl;
            }
            catch (IncorrectOperationException e3) {
                LOG.error((Throwable)e3);
                Boolean bl = false;
                return bl;
            }
            finally {
                this.myRanges.clear();
            }
        });
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareTask"));
        }
        return futureTask;
    }

    private void prepareUserNotificationMessage(@NotNull Document document, @NotNull CharSequence before) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareUserNotificationMessage"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "prepareUserNotificationMessage"));
        }
        LOG.assertTrue(this.getInfoCollector() != null);
        int number = FormatChangedTextUtil.getInstance().calculateChangedLinesNumber(document, before);
        if (number > 0) {
            String message2 = "formatted " + number + " line" + (number > 1 ? "s" : "");
            this.getInfoCollector().setReformatCodeNotification(message2);
        }
    }

    @NotNull
    private Collection<TextRange> getRangesToFormat(PsiFile file2) {
        if (this.mySelectionModel != null) {
            List<TextRange> list2 = ReformatCodeProcessor.getSelectedRanges(this.mySelectionModel);
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "getRangesToFormat"));
            }
            return list2;
        }
        ArrayList arrayList = !this.myRanges.isEmpty() ? this.myRanges : ContainerUtil.newArrayList((Object[])new TextRange[]{file2.getTextRange()});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/ReformatCodeProcessor", "getRangesToFormat"));
        }
        return arrayList;
    }
}

