/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.codeInsight.actions.LastRunReformatCodeOptionsProvider;
import com.intellij.codeInsight.actions.ReformatFilesOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.search.SearchScope;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReformatFilesDialog
extends DialogWrapper
implements ReformatFilesOptions {
    private JPanel myPanel;
    private JCheckBox myOptimizeImports;
    private JCheckBox myOnlyChangedText;
    private JCheckBox myRearrangeEntriesCb;
    private final LastRunReformatCodeOptionsProvider myLastRunSettings;

    public ReformatFilesDialog(@NotNull Project project2, @NotNull VirtualFile[] files2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/ReformatFilesDialog", "<init>"));
        }
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/ReformatFilesDialog", "<init>"));
        }
        super(project2, true);
        this.$$$setupUI$$$();
        this.myLastRunSettings = new LastRunReformatCodeOptionsProvider(PropertiesComponent.getInstance());
        boolean canTargetVcsChanges = FormatChangedTextUtil.hasChanges(files2, project2);
        this.myOnlyChangedText.setEnabled(canTargetVcsChanges);
        this.myOnlyChangedText.setSelected(canTargetVcsChanges && this.myLastRunSettings.getLastTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
        this.myOptimizeImports.setSelected(this.myLastRunSettings.getLastOptimizeImports());
        this.myRearrangeEntriesCb.setSelected(this.myLastRunSettings.getLastRearrangeCode());
        this.myRearrangeEntriesCb.setEnabled(ReformatFilesDialog.containsAtLeastOneFileToRearrange(files2));
        this.setTitle(CodeInsightBundle.message((String)"dialog.reformat.files.title", (Object[])new Object[0]));
        this.init();
    }

    private static boolean containsAtLeastOneFileToRearrange(@NotNull VirtualFile[] files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/ReformatFilesDialog", "containsAtLeastOneFileToRearrange"));
        }
        for (VirtualFile file2 : files2) {
            Language language;
            FileType fileType = file2.getFileType();
            if (!(fileType instanceof LanguageFileType) || Rearranger.EXTENSION.forLanguage(language = ((LanguageFileType)fileType).getLanguage()) == null) continue;
            return true;
        }
        return false;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    public boolean isOptimizeImports() {
        return this.myOptimizeImports.isSelected();
    }

    @Override
    public TextRangeType getTextRangeType() {
        return this.myOnlyChangedText.isEnabled() && this.myOnlyChangedText.isSelected() ? TextRangeType.VCS_CHANGED_TEXT : TextRangeType.WHOLE_FILE;
    }

    @Override
    public boolean isRearrangeCode() {
        return this.myRearrangeEntriesCb.isSelected();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myLastRunSettings.saveOptimizeImportsState(this.isOptimizeImports());
        if (this.myRearrangeEntriesCb.isEnabled()) {
            this.myLastRunSettings.saveRearrangeCodeState(this.isRearrangeCode());
        }
        if (this.myOnlyChangedText.isEnabled()) {
            this.myLastRunSettings.saveProcessVcsChangedTextState(this.getTextRangeType() == TextRangeType.VCS_CHANGED_TEXT);
        }
    }

    @Override
    @Nullable
    public SearchScope getSearchScope() {
        return null;
    }

    @Override
    @Nullable
    public String getFileTypeMask() {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 4, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("dialog.reformat.files.reformat.selected.files.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptimizeImports = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("dialog.reformat.files.optimize.imports.checkbox"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOnlyChangedText = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/CodeInsightBundle").getString("reformat.option.vcs.changed.region"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRearrangeEntriesCb = jCheckBox = new JCheckBox();
        jCheckBox.setText("Rearrange entries");
        jCheckBox.setMnemonic('R');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            if (string2.charAt(i2) == '&') {
                if (++i2 == string2.length()) break;
                if (!bl && string2.charAt(i2) != '&') {
                    bl = true;
                    c2 = string2.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string2.charAt(i2));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }
}

