/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.StringComboboxEditor;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public class ComboEditorCompletionContributor
extends CompletionContributor
implements DumbAware {
    public static final Key<Boolean> CONTINUE_RUN_COMPLETION = Key.create((String)"CONTINUE_RUN_COMPLETION");

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        JComboBox comboBox;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/ComboEditorCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/ComboEditorCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getInvocationCount() == 0) {
            return;
        }
        PsiFile file2 = parameters.getOriginalFile();
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document != null && (comboBox = (JComboBox)document.getUserData(StringComboboxEditor.COMBO_BOX_KEY)) != null) {
            String substring = document.getText().substring(0, parameters.getOffset());
            boolean plainPrefixMatcher = Boolean.TRUE.equals(document.getUserData(StringComboboxEditor.USE_PLAIN_PREFIX_MATCHER));
            CompletionResultSet resultSet = plainPrefixMatcher ? result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(substring)) : result2.withPrefixMatcher(substring);
            int count = comboBox.getItemCount();
            for (int i2 = 0; i2 < count; ++i2) {
                Object o2 = comboBox.getItemAt(i2);
                if (!(o2 instanceof String)) continue;
                resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)((String)o2)).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(InsertionContext context2, LookupElement item) {
                        Document document = context2.getEditor().getDocument();
                        document.deleteString(context2.getEditor().getCaretModel().getOffset(), document.getTextLength());
                    }
                }), (double)(count - i2)));
            }
            if (!Boolean.TRUE.equals(document.getUserData(CONTINUE_RUN_COMPLETION))) {
                result2.stopHere();
            }
        }
    }
}

