/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionLookupArranger
extends LookupArranger {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionLookupArranger");
    private static final Key<String> GLOBAL_PRESENTATION_INVARIANT = Key.create((String)"PRESENTATION_INVARIANT");
    private final Key<String> PRESENTATION_INVARIANT = Key.create((String)"PRESENTATION_INVARIANT");
    private final Comparator<LookupElement> BY_PRESENTATION_COMPARATOR = (o1, o2) -> {
        String invariant = (String)this.PRESENTATION_INVARIANT.get((UserDataHolder)o1);
        assert (invariant != null);
        return StringUtil.naturalCompare((String)invariant, (String)((String)this.PRESENTATION_INVARIANT.get((UserDataHolder)o2)));
    };
    static final int MAX_PREFERRED_COUNT = 5;
    public static final String OVERFLOW_MESSAGE = "Not all variants are shown, please type more letters to see the rest";
    public static final Key<WeighingContext> WEIGHING_CONTEXT = Key.create((String)"WEIGHING_CONTEXT");
    public static final Key<Integer> PREFIX_CHANGES = Key.create((String)"PREFIX_CHANGES");
    private static final UISettings ourUISettings = UISettings.getInstance();
    private final List<LookupElement> myFrozenItems = new ArrayList<LookupElement>();
    private final int myLimit = Registry.intValue((String)"ide.completion.variant.limit");
    private boolean myOverflow;
    private final CompletionLocation myLocation;
    private final CompletionParameters myParameters;
    private final CompletionProgressIndicator myProcess;
    private final Map<CompletionSorterImpl, Classifier<LookupElement>> myClassifiers = new java.util.LinkedHashMap<CompletionSorterImpl, Classifier<LookupElement>>();
    private final CompletionFinalSorter myFinalSorter = CompletionFinalSorter.newSorter();
    private int myPrefixChanges;

    public CompletionLookupArranger(CompletionParameters parameters, CompletionProgressIndicator process2) {
        this.myParameters = parameters;
        this.myProcess = process2;
        this.myLocation = new CompletionLocation(parameters);
    }

    private MultiMap<CompletionSorterImpl, LookupElement> groupItemsBySorter(Iterable<LookupElement> source) {
        MultiMap inputBySorter = MultiMap.createLinked();
        for (LookupElement element : source) {
            inputBySorter.putValue((Object)this.obtainSorter(element), (Object)element);
        }
        for (CompletionSorterImpl sorter : inputBySorter.keySet()) {
            inputBySorter.put((Object)sorter, this.sortByPresentation(inputBySorter.get((Object)sorter)));
        }
        return inputBySorter;
    }

    @NotNull
    private CompletionSorterImpl obtainSorter(LookupElement element) {
        CompletionSorterImpl completionSorterImpl = this.myProcess.getSorter(element);
        if (completionSorterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger", "obtainSorter"));
        }
        return completionSorterImpl;
    }

    @Override
    @NotNull
    public Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<LookupElement> items2, boolean hideSingleValued) {
        if (items2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/completion/CompletionLookupArranger", "getRelevanceObjects"));
        }
        IdentityHashMap map2 = ContainerUtil.newIdentityHashMap();
        MultiMap<CompletionSorterImpl, LookupElement> inputBySorter = this.groupItemsBySorter(items2);
        int sorterNumber = 0;
        for (CompletionSorterImpl sorter : inputBySorter.keySet()) {
            ++sorterNumber;
            Collection thisSorterItems = inputBySorter.get((Object)sorter);
            for (LookupElement element : thisSorterItems) {
                map2.put(element, ContainerUtil.newArrayList((Object[])new Pair[]{new Pair((Object)"frozen", (Object)this.myFrozenItems.contains(element)), new Pair((Object)"sorter", (Object)sorterNumber)}));
            }
            ProcessingContext context2 = this.createContext();
            for (Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter); classifier != null; classifier = classifier.getNext()) {
                THashSet itemSet = ContainerUtil.newIdentityTroveSet((Collection)thisSorterItems);
                List unsortedItems = ContainerUtil.filter((Collection)this.myItems, lookupElement -> itemSet.contains(lookupElement));
                List<Pair<LookupElement, Object>> pairs = classifier.getSortingWeights(unsortedItems, context2);
                if (hideSingleValued && CompletionLookupArranger.haveSameWeights(pairs)) continue;
                for (Pair<LookupElement, Object> pair : pairs) {
                    ((List)map2.get(pair.first)).add(Pair.create((Object)classifier.getPresentableName(), (Object)pair.second));
                }
            }
        }
        LinkedHashMap result2 = new LinkedHashMap(EqualityPolicy.IDENTITY);
        Map<LookupElement, List<Pair<String, Object>>> additional = this.myFinalSorter.getRelevanceObjects(items2);
        for (LookupElement item : items2) {
            List mainRelevance = (List)map2.get(item);
            List<Pair<String, Object>> additionalRelevance = additional.get(item);
            result2.put(item, additionalRelevance == null ? mainRelevance : ContainerUtil.concat((List)mainRelevance, additionalRelevance));
        }
        LinkedHashMap linkedHashMap = result2;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger", "getRelevanceObjects"));
        }
        return linkedHashMap;
    }

    private static boolean haveSameWeights(List<Pair<LookupElement, Object>> pairs) {
        if (pairs.isEmpty()) {
            return true;
        }
        for (int i2 = 1; i2 < pairs.size(); ++i2) {
            if (Comparing.equal((Object)pairs.get((int)i2).second, (Object)pairs.get((int)0).second)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addElement(LookupElement element, LookupElementPresentation presentation) {
        StatisticsWeigher.clearBaseStatisticsInfo(element);
        String tail = CompletionLookupArranger.getTailTextOrSpace(presentation);
        String invariant = presentation.getItemText() + "\u0000###" + String.format("%02d", tail.length()) + tail + "###" + presentation.getTypeText();
        element.putUserData(this.PRESENTATION_INVARIANT, (Object)invariant);
        element.putUserData(GLOBAL_PRESENTATION_INVARIANT, (Object)invariant);
        CompletionSorterImpl sorter = this.obtainSorter(element);
        Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter);
        if (classifier == null) {
            classifier = sorter.buildClassifier(new EmptyClassifier());
            this.myClassifiers.put(sorter, classifier);
        }
        ProcessingContext context2 = this.createContext();
        classifier.addElement(element, context2);
        super.addElement(element, presentation);
        this.trimToLimit(context2);
    }

    @Override
    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
        this.myProcess.itemSelected(lookupItem, completionChar);
    }

    private void trimToLimit(ProcessingContext context2) {
        if (this.myItems.size() < this.myLimit) {
            return;
        }
        List<LookupElement> items2 = this.getMatchingItems();
        Iterator<LookupElement> iterator2 = this.sortByRelevance(this.groupItemsBySorter(items2)).iterator();
        THashSet retainedSet = ContainerUtil.newIdentityTroveSet();
        retainedSet.addAll(this.getPrefixItems(true));
        retainedSet.addAll(this.getPrefixItems(false));
        retainedSet.addAll(this.myFrozenItems);
        while (retainedSet.size() < this.myLimit / 2 && iterator2.hasNext()) {
            retainedSet.add(iterator2.next());
        }
        if (!iterator2.hasNext()) {
            return;
        }
        List<LookupElement> removed = this.retainItems((Set<LookupElement>)retainedSet);
        for (LookupElement element : removed) {
            this.removeItem(element, context2);
        }
        if (!this.myOverflow) {
            this.myOverflow = true;
            this.myProcess.addAdvertisement(OVERFLOW_MESSAGE, null);
            this.myProcess.addWatchedPrefix(0, (ElementPattern<String>)StandardPatterns.string());
        }
    }

    private void removeItem(LookupElement element, ProcessingContext context2) {
        CompletionSorterImpl sorter = this.obtainSorter(element);
        Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter);
        classifier.removeElement(element, context2);
    }

    @NotNull
    private static String getTailTextOrSpace(LookupElementPresentation presentation) {
        String tailText = presentation.getTailText();
        String string2 = tailText == null || tailText.isEmpty() ? " " : tailText;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger", "getTailTextOrSpace"));
        }
        return string2;
    }

    private List<LookupElement> sortByPresentation(Iterable<LookupElement> source) {
        ArrayList startMatches = ContainerUtil.newArrayList();
        ArrayList middleMatches = ContainerUtil.newArrayList();
        for (LookupElement element : source) {
            (this.itemMatcher(element).isStartMatch(element) ? startMatches : middleMatches).add(element);
        }
        ContainerUtil.sort((List)startMatches, this.BY_PRESENTATION_COMPARATOR);
        ContainerUtil.sort((List)middleMatches, this.BY_PRESENTATION_COMPARATOR);
        startMatches.addAll(middleMatches);
        return startMatches;
    }

    private static boolean isAlphaSorted() {
        return ourUISettings.getSortLookupElementsLexicographically();
    }

    @Override
    public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup, boolean onExplicitAction) {
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/completion/CompletionLookupArranger", "arrangeItems"));
        }
        List<LookupElement> items2 = this.getMatchingItems();
        Iterable<LookupElement> sortedByRelevance = this.sortByRelevance(this.groupItemsBySorter(items2));
        LookupElement relevantSelection = this.findMostRelevantItem(sortedByRelevance);
        LookupImpl lookupImpl = (LookupImpl)lookup;
        List<LookupElement> listModel2 = CompletionLookupArranger.isAlphaSorted() ? this.sortByPresentation(items2) : this.fillModelByRelevance(lookupImpl, (Set<LookupElement>)ContainerUtil.newIdentityTroveSet(items2), sortedByRelevance, relevantSelection);
        int toSelect = this.getItemToSelect(lookupImpl, listModel2, onExplicitAction, relevantSelection);
        LOG.assertTrue(toSelect >= 0);
        CompletionLookupArranger.addDummyItems(items2.size() - listModel2.size(), listModel2);
        return new Pair(listModel2, (Object)toSelect);
    }

    private static void addDummyItems(int count, List<LookupElement> listModel2) {
        EmptyLookupItem dummy = new EmptyLookupItem("loading...", true);
        for (int i2 = count; i2 > 0; --i2) {
            listModel2.add(dummy);
        }
    }

    private List<LookupElement> fillModelByRelevance(LookupImpl lookup, Set<LookupElement> items2, Iterable<LookupElement> sortedElements, @Nullable LookupElement relevantSelection) {
        Iterator<LookupElement> byRelevance = sortedElements.iterator();
        LinkedHashSet<LookupElement> model2 = new LinkedHashSet<LookupElement>();
        this.addPrefixItems(model2);
        this.addFrozenItems(items2, model2);
        if (model2.size() < 5) {
            CompletionLookupArranger.addSomeItems(model2, byRelevance, (Condition<LookupElement>)((Condition)lastAdded -> model2.size() >= 5));
        }
        CompletionLookupArranger.addCurrentlySelectedItemToTop(lookup, items2, model2);
        this.freezeTopItems(lookup, model2);
        CompletionLookupArranger.ensureItemAdded(items2, model2, byRelevance, lookup.getCurrentItem());
        CompletionLookupArranger.ensureItemAdded(items2, model2, byRelevance, relevantSelection);
        CompletionLookupArranger.ensureEverythingVisibleAdded(lookup, model2, byRelevance);
        return new ArrayList<LookupElement>(model2);
    }

    private static void ensureEverythingVisibleAdded(LookupImpl lookup, LinkedHashSet<LookupElement> model2, Iterator<LookupElement> byRelevance) {
        JList list2 = lookup.getList();
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        int limit = Math.max(list2.getLastVisibleIndex(), model2.size()) + ourUISettings.getMaxLookupListHeight() * 3;
        CompletionLookupArranger.addSomeItems(model2, byRelevance, (Condition<LookupElement>)((Condition)lastAdded -> !testMode && model2.size() >= limit));
    }

    private static void ensureItemAdded(Set<LookupElement> items2, LinkedHashSet<LookupElement> model2, Iterator<LookupElement> byRelevance, @Nullable LookupElement item) {
        if (item != null && items2.contains(item) && !model2.contains(item)) {
            CompletionLookupArranger.addSomeItems(model2, byRelevance, (Condition<LookupElement>)((Condition)lastAdded -> lastAdded == item));
        }
    }

    private void freezeTopItems(LookupImpl lookup, LinkedHashSet<LookupElement> model2) {
        this.myFrozenItems.clear();
        if (lookup.isShown()) {
            this.myFrozenItems.addAll(model2);
        }
    }

    private void addFrozenItems(Set<LookupElement> items2, LinkedHashSet<LookupElement> model2) {
        Iterator<LookupElement> iterator2 = this.myFrozenItems.iterator();
        while (iterator2.hasNext()) {
            LookupElement element = iterator2.next();
            if (element.isValid() && items2.contains(element)) continue;
            iterator2.remove();
        }
        model2.addAll(this.myFrozenItems);
    }

    private void addPrefixItems(LinkedHashSet<LookupElement> model2) {
        ContainerUtil.addAll(model2, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(true))));
        ContainerUtil.addAll(model2, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(false))));
    }

    private static void addCurrentlySelectedItemToTop(Lookup lookup, Set<LookupElement> items2, LinkedHashSet<LookupElement> model2) {
        LookupElement lastSelection;
        if (!lookup.isSelectionTouched() && items2.contains(lastSelection = lookup.getCurrentItem())) {
            model2.add(lastSelection);
        }
    }

    private static void addSomeItems(LinkedHashSet<LookupElement> model2, Iterator<LookupElement> iterator2, Condition<LookupElement> stopWhen) {
        while (iterator2.hasNext()) {
            LookupElement item = iterator2.next();
            model2.add(item);
            if (!stopWhen.value((Object)item)) continue;
            break;
        }
    }

    private Iterable<LookupElement> sortByRelevance(MultiMap<CompletionSorterImpl, LookupElement> inputBySorter) {
        ArrayList byClassifier = ContainerUtil.newArrayList();
        for (CompletionSorterImpl sorter : this.myClassifiers.keySet()) {
            ProcessingContext context2 = this.createContext();
            byClassifier.add(this.myClassifiers.get((Object)sorter).classify(inputBySorter.get((Object)sorter), context2));
        }
        Iterable result2 = ContainerUtil.concat((Iterable[])byClassifier.toArray(new Iterable[byClassifier.size()]));
        return this.myFinalSorter.sort(result2, this.myParameters);
    }

    private ProcessingContext createContext() {
        ProcessingContext context2 = new ProcessingContext();
        context2.put(PREFIX_CHANGES, (Object)this.myPrefixChanges);
        context2.put(WEIGHING_CONTEXT, (Object)this);
        return context2;
    }

    @Override
    public LookupArranger createEmptyCopy() {
        return new CompletionLookupArranger(this.myParameters, this.myProcess);
    }

    private int getItemToSelect(LookupImpl lookup, List<LookupElement> items2, boolean onExplicitAction, @Nullable LookupElement mostRelevant) {
        LookupElement exactMatch;
        if (items2.isEmpty() || lookup.getFocusDegree() == LookupImpl.FocusDegree.UNFOCUSED) {
            return 0;
        }
        if (lookup.isSelectionTouched() || !onExplicitAction) {
            int index;
            LookupElement lastSelection = lookup.getCurrentItem();
            int old = ContainerUtil.indexOfIdentity(items2, (Object)lastSelection);
            if (old >= 0) {
                return old;
            }
            Object selectedValue = lookup.getList().getSelectedValue();
            if (selectedValue instanceof EmptyLookupItem && ((EmptyLookupItem)((Object)selectedValue)).isLoading() && (index = lookup.getList().getSelectedIndex()) >= 0 && index < items2.size()) {
                return index;
            }
            for (int i2 = 0; i2 < items2.size(); ++i2) {
                String invariant = (String)this.PRESENTATION_INVARIANT.get((UserDataHolder)items2.get(i2));
                if (invariant == null || !invariant.equals(GLOBAL_PRESENTATION_INVARIANT.get((UserDataHolder)lastSelection))) continue;
                return i2;
            }
        }
        return Math.max(0, ContainerUtil.indexOfIdentity(items2, (Object)((exactMatch = this.getBestExactMatch(lookup, items2)) != null ? exactMatch : mostRelevant)));
    }

    private List<LookupElement> getExactMatches(LookupImpl lookup, List<LookupElement> items2) {
        String selectedText = lookup.getTopLevelEditor().getSelectionModel().getSelectedText();
        SmartList exactMatches = new SmartList();
        for (int i2 = 0; i2 < items2.size(); ++i2) {
            LookupElement item = items2.get(i2);
            boolean isSuddenLiveTemplate = CompletionLookupArranger.isSuddenLiveTemplate(item);
            if (this.isPrefixItem(item, true) && !isSuddenLiveTemplate || item.getLookupString().equals(selectedText)) {
                if (item instanceof LiveTemplateLookupElement) {
                    return Collections.singletonList(item);
                }
                exactMatches.add(item);
                continue;
            }
            if (i2 != 0 || !isSuddenLiveTemplate || items2.size() <= 1 || CompletionServiceImpl.isStartMatch(items2.get(1), this)) continue;
            return Collections.singletonList(item);
        }
        return exactMatches;
    }

    @Nullable
    private LookupElement getBestExactMatch(LookupImpl lookup, List<LookupElement> items2) {
        List<LookupElement> exactMatches = this.getExactMatches(lookup, items2);
        if (exactMatches.isEmpty()) {
            return null;
        }
        if (exactMatches.size() == 1) {
            return exactMatches.get(0);
        }
        return this.sortByRelevance(this.groupItemsBySorter(exactMatches)).iterator().next();
    }

    @Nullable
    private LookupElement findMostRelevantItem(Iterable<LookupElement> sorted) {
        CompletionPreselectSkipper[] skippers = (CompletionPreselectSkipper[])CompletionPreselectSkipper.EP_NAME.getExtensions();
        for (LookupElement element : sorted) {
            if (this.shouldSkip(skippers, element)) continue;
            return element;
        }
        return null;
    }

    private static boolean isSuddenLiveTemplate(LookupElement element) {
        return element instanceof LiveTemplateLookupElement && ((LiveTemplateLookupElement)element).sudden;
    }

    private boolean shouldSkip(CompletionPreselectSkipper[] skippers, LookupElement element) {
        for (CompletionPreselectSkipper skipper : skippers) {
            if (!skipper.skipElement(element, this.myLocation)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped element " + element + " by " + skipper);
            }
            return true;
        }
        return false;
    }

    @Override
    public void prefixChanged(Lookup lookup) {
        ++this.myPrefixChanges;
        this.myFrozenItems.clear();
        super.prefixChanged(lookup);
    }

    private static class EmptyClassifier
    extends Classifier<LookupElement> {
        private EmptyClassifier() {
            super(null, "empty");
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<LookupElement> items2, @NotNull ProcessingContext context2) {
            if (items2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/codeInsight/completion/CompletionLookupArranger$EmptyClassifier", "getSortingWeights"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/CompletionLookupArranger$EmptyClassifier", "getSortingWeights"));
            }
            List<Pair<LookupElement, Object>> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger$EmptyClassifier", "getSortingWeights"));
            }
            return list2;
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<LookupElement> source, @NotNull ProcessingContext context2) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/codeInsight/completion/CompletionLookupArranger$EmptyClassifier", "classify"));
            }
            if (context2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/CompletionLookupArranger$EmptyClassifier", "classify"));
            }
            Iterable<LookupElement> iterable = source;
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionLookupArranger$EmptyClassifier", "classify"));
            }
            return iterable;
        }
    }
}

