/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.XmlSchemaProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class XmlLocationCompletionContributor
extends CompletionContributor {
    public static final Function<Object, LookupElement> MAPPING = o2 -> o2 instanceof LookupElement ? (LookupElement)o2 : LookupElementBuilder.create((Object)o2);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/XmlLocationCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/XmlLocationCompletionContributor", "fillCompletionVariants"));
        }
        PsiReference reference = parameters.getPosition().getContainingFile().findReferenceAt(parameters.getOffset());
        if (reference instanceof URLReference) {
            if (((URLReference)reference).isSchemaLocation()) {
                Object[] objects = XmlLocationCompletionContributor.completeSchemaLocation(reference.getElement());
                result2.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
                return;
            }
            Object[] objects = XmlLocationCompletionContributor.completeNamespace(reference.getElement());
            result2.addAllElements((Iterable)ContainerUtil.map((Object[])objects, MAPPING));
            return;
        }
        if (reference instanceof PsiMultiReference) {
            reference = ((PsiMultiReference)reference).getReferences()[0];
        }
        if (reference instanceof DependentNSReference) {
            MultiMap<String, String> map2 = ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(parameters.getOriginalFile().getProject());
            String namespace = ((DependentNSReference)reference).getNamespaceReference().getCanonicalText();
            Collection strings = map2.get((Object)namespace);
            for (String string2 : strings) {
                if (namespace.equals(string2)) continue;
                result2.consume(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)string2), (double)100.0));
            }
            if (!strings.isEmpty()) {
                result2.stopHere();
            }
        }
    }

    private static Object[] completeNamespace(PsiElement myElement) {
        XmlFile file2 = (XmlFile)myElement.getContainingFile();
        PsiElement parent = myElement.getParent();
        HashSet<String> preferred = new HashSet<String>();
        if (parent instanceof XmlAttribute && "xmlns".equals(((XmlAttribute)parent).getName())) {
            XmlNamespaceHelper helper = XmlNamespaceHelper.getHelper((PsiFile)file2);
            preferred.addAll(helper.guessUnboundNamespaces(parent.getParent(), file2));
        }
        HashSet list2 = new HashSet();
        for (XmlSchemaProvider provider : (XmlSchemaProvider[])Extensions.getExtensions((ExtensionPointName)XmlSchemaProvider.EP_NAME)) {
            if (!provider.isAvailable(file2)) continue;
            list2.addAll(provider.getAvailableNamespaces(file2, null));
        }
        if (!list2.isEmpty()) {
            return ArrayUtil.toObjectArray(list2);
        }
        Object[] resourceUrls = ExternalResourceManagerEx.getInstanceEx().getUrlsByNamespace(myElement.getProject()).keySet().toArray();
        XmlDocument document = file2.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        ArrayList additionalNs = new ArrayList();
        if (rootTag != null) {
            URLReference.processWsdlSchemas(rootTag, (Processor<XmlTag>)((Processor)xmlTag -> {
                String s2 = xmlTag.getAttributeValue("targetNamespace");
                if (s2 != null) {
                    additionalNs.add(s2);
                }
                return true;
            }));
        }
        resourceUrls = ArrayUtil.mergeArrays((Object[])resourceUrls, (Object[])ArrayUtil.toStringArray(additionalNs));
        return ContainerUtil.map2Array((Object[])resourceUrls, o2 -> {
            LookupElementBuilder builder = LookupElementBuilder.create((Object)o2);
            return preferred.contains(o2) ? PrioritizedLookupElement.withPriority((LookupElement)builder, (double)100.0) : builder;
        });
    }

    private static Object[] completeSchemaLocation(PsiElement element) {
        XmlTag tag = (XmlTag)element.getParent().getParent();
        Object[] attributes = tag.getAttributes();
        PsiReference[] refs = element.getReferences();
        return ContainerUtil.mapNotNull((Object[])attributes, attribute -> {
            String attributeValue = attribute.getValue();
            return attributeValue != null && attribute.isNamespaceDeclaration() && ContainerUtil.find((Object[])refs, ref -> ref.getCanonicalText().equals(attributeValue)) == null ? attributeValue + " " : null;
        }, (Object[])ArrayUtil.EMPTY_OBJECT_ARRAY);
    }
}

