/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsImpl;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.LineMarkersUtil;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.StatusBarUpdater;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.FileLevelIntentionComponent;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DaemonCodeAnalyzer", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DaemonCodeAnalyzerImpl
extends DaemonCodeAnalyzerEx
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
    private static final Key<List<HighlightInfo>> FILE_LEVEL_HIGHLIGHTS = Key.create((String)"FILE_LEVEL_HIGHLIGHTS");
    private final Project myProject;
    private final DaemonCodeAnalyzerSettings mySettings;
    @NotNull
    private final EditorTracker myEditorTracker;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    private DaemonProgressIndicator myUpdateProgress;
    private final UpdateRunnable myUpdateRunnable;
    private final ScheduledExecutorService myAlarm;
    @NotNull
    private volatile Future<?> myUpdateRunnableFuture;
    private boolean myUpdateByTimerEnabled;
    private final Collection<VirtualFile> myDisabledHintsFiles;
    private final Collection<VirtualFile> myDisabledHighlightingFiles;
    private final FileStatusMap myFileStatusMap;
    private DaemonCodeAnalyzerSettings myLastSettings;
    private volatile IntentionHintComponent myLastIntentionHint;
    private volatile boolean myDisposed;
    private volatile boolean myInitialized;
    @NonNls
    private static final String DISABLE_HINTS_TAG = "disable_hints";
    @NonNls
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String URL_ATT = "url";
    private final PassExecutorService myPassExecutorService;
    private volatile boolean mustWaitForSmartMode;
    private int myDisableCount;
    private final Runnable submitPassesRunnable;

    public DaemonCodeAnalyzerImpl(@NotNull Project project2, @NotNull DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings, @NotNull EditorTracker editorTracker, @NotNull PsiDocumentManager psiDocumentManager, @NotNull NamedScopeManager namedScopeManager, @NotNull DependencyValidationManager dependencyValidationManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (daemonCodeAnalyzerSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "daemonCodeAnalyzerSettings", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (editorTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorTracker", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (psiDocumentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDocumentManager", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (namedScopeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedScopeManager", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        if (dependencyValidationManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyValidationManager", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "<init>"));
        }
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myAlarm = EdtExecutorService.getScheduledExecutorInstance();
        this.myUpdateRunnableFuture = CompletableFuture.completedFuture(null);
        this.myUpdateByTimerEnabled = true;
        this.myDisabledHintsFiles = new THashSet();
        this.myDisabledHighlightingFiles = new THashSet();
        this.mustWaitForSmartMode = true;
        this.submitPassesRunnable = new Runnable(){

            @Override
            public void run() {
                PassExecutorService.log(DaemonCodeAnalyzerImpl.this.getUpdateProgress(), null, "Update Runnable. myUpdateByTimerEnabled:", DaemonCodeAnalyzerImpl.this.myUpdateByTimerEnabled, " something disposed:", PowerSaveMode.isEnabled() || DaemonCodeAnalyzerImpl.this.myDisposed || !DaemonCodeAnalyzerImpl.this.myProject.isInitialized(), " activeEditors:", DaemonCodeAnalyzerImpl.this.myProject.isDisposed() ? null : DaemonCodeAnalyzerImpl.this.getSelectedEditors());
                if (!DaemonCodeAnalyzerImpl.this.myUpdateByTimerEnabled) {
                    return;
                }
                if (DaemonCodeAnalyzerImpl.this.myDisposed) {
                    return;
                }
                ApplicationManager.getApplication().assertIsDispatchThread();
                Collection activeEditors = DaemonCodeAnalyzerImpl.this.getSelectedEditors();
                if (activeEditors.isEmpty()) {
                    return;
                }
                if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                    return;
                }
                PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)DaemonCodeAnalyzerImpl.this.myPsiDocumentManager;
                if (documentManager.hasUncommitedDocuments()) {
                    documentManager.cancelAndRunWhenAllCommitted("restart daemon when all committed", this);
                    return;
                }
                if (RefResolveService.ENABLED && !RefResolveService.getInstance((Project)DaemonCodeAnalyzerImpl.this.myProject).isUpToDate() && RefResolveService.getInstance((Project)DaemonCodeAnalyzerImpl.this.myProject).getQueueSize() == 1) {
                    return;
                }
                THashMap passes = new THashMap(activeEditors.size());
                for (FileEditor fileEditor : activeEditors) {
                    BackgroundEditorHighlighter highlighter2 = fileEditor.getBackgroundHighlighter();
                    if (highlighter2 == null) continue;
                    HighlightingPass[] highlightingPasses = highlighter2.createPassesForEditor();
                    passes.put(fileEditor, highlightingPasses);
                }
                DaemonCodeAnalyzerImpl.this.cancelUpdateProgress(true, "Cancel by alarm");
                DaemonCodeAnalyzerImpl.this.myUpdateRunnableFuture.cancel(false);
                DaemonProgressIndicator progress = DaemonCodeAnalyzerImpl.this.createUpdateProgress();
                DaemonCodeAnalyzerImpl.this.myPassExecutorService.submitPasses((Map<FileEditor, HighlightingPass[]>)passes, progress);
            }
        };
        this.myProject = project2;
        this.mySettings = daemonCodeAnalyzerSettings;
        this.myEditorTracker = editorTracker;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)daemonCodeAnalyzerSettings).clone();
        this.myFileStatusMap = new FileStatusMap(project2);
        this.myPassExecutorService = new PassExecutorService(project2);
        Disposer.register((Disposable)this, (Disposable)this.myPassExecutorService);
        Disposer.register((Disposable)this, (Disposable)this.myFileStatusMap);
        DaemonProgressIndicator.setDebug(LOG.isDebugEnabled());
        assert (!this.myInitialized) : "Double Initializing";
        Disposer.register((Disposable)this, (Disposable)new StatusBarUpdater(project2));
        this.myInitialized = true;
        this.myDisposed = false;
        this.myFileStatusMap.markAllFilesDirty("DCAI init");
        this.myUpdateRunnable = new UpdateRunnable(this.myProject);
        Disposer.register((Disposable)this, () -> {
            assert (this.myInitialized) : "Disposing not initialized component";
            assert (!this.myDisposed) : "Double dispose";
            this.myUpdateRunnable.clearFieldsOnDispose();
            this.stopProcess(false, "Dispose");
            this.myDisposed = true;
            this.myLastSettings = null;
        });
    }

    public synchronized void dispose() {
        this.myUpdateProgress = new DaemonProgressIndicator();
        this.myUpdateRunnableFuture.cancel(true);
    }

    @NotNull
    public static List<HighlightInfo> getHighlights(@NotNull Document document, HighlightSeverity minSeverity, @NotNull Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        DaemonCodeAnalyzerImpl.processHighlights(document, project2, minSeverity, 0, document.getTextLength(), (Processor<HighlightInfo>)Processors.cancelableCollectProcessor(infos));
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getHighlights"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<HighlightInfo> getFileLevelHighlights(@NotNull Project project2, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        VirtualFile vFile = file2.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project2);
        List<HighlightInfo> list2 = Arrays.stream(manager.getEditors(vFile)).map(fileEditor -> (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS)).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileLevelHighlights"));
        }
        return list2;
    }

    @Override
    public void cleanFileLevelHighlights(@NotNull Project project2, int group, PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "cleanFileLevelHighlights"));
        }
        if (psiFile == null) {
            return;
        }
        FileViewProvider provider = psiFile.getViewProvider();
        VirtualFile vFile = provider.getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project2);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            List infos = (List)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (infos == null) continue;
            ArrayList<HighlightInfo> infosToRemove = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : infos) {
                if (info.getGroup() != group) continue;
                manager.removeTopComponent(fileEditor, info.fileLevelComponent);
                infosToRemove.add(info);
            }
            infos.removeAll(infosToRemove);
        }
    }

    @Override
    public void addFileLevelHighlight(@NotNull Project project2, int group, @NotNull HighlightInfo info, @NotNull PsiFile psiFile) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "addFileLevelHighlight"));
        }
        VirtualFile vFile = psiFile.getViewProvider().getVirtualFile();
        FileEditorManager manager = FileEditorManager.getInstance((Project)project2);
        for (FileEditor fileEditor : manager.getEditors(vFile)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            FileLevelIntentionComponent component = new FileLevelIntentionComponent(info.getDescription(), info.getSeverity(), info.getGutterIconRenderer(), info.quickFixActionRanges, project2, psiFile, ((TextEditor)fileEditor).getEditor(), info.getToolTip());
            manager.addTopComponent(fileEditor, (JComponent)((Object)component));
            ArrayList<HighlightInfo> fileLevelInfos = (ArrayList<HighlightInfo>)fileEditor.getUserData(FILE_LEVEL_HIGHLIGHTS);
            if (fileLevelInfos == null) {
                fileLevelInfos = new ArrayList<HighlightInfo>();
                fileEditor.putUserData(FILE_LEVEL_HIGHLIGHTS, fileLevelInfos);
            }
            info.fileLevelComponent = component;
            info.setGroup(group);
            fileLevelInfos.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<HighlightInfo> runMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull ProgressIndicator progress) {
        ArrayList<HighlightInfo> result2;
        block13: {
            if (psiFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new IllegalStateException("Must not run highlighting from under EDT");
            }
            if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
                throw new IllegalStateException("Must run highlighting from under read action");
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (!(indicator instanceof DaemonProgressIndicator)) {
                throw new IllegalStateException("Must run highlighting under progress with DaemonProgressIndicator");
            }
            this.myFileStatusMap.markAllFilesDirty("prepare to run main passes");
            this.stopProcess(false, "disable background daemon");
            this.myPassExecutorService.cancelAll(true);
            try {
                result2 = new ArrayList<HighlightInfo>();
                VirtualFile virtualFile = psiFile.getVirtualFile();
                if (virtualFile == null || virtualFile.getFileType().isBinary()) break block13;
                List<TextEditorHighlightingPass> passes = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject).instantiateMainPasses(psiFile, document, HighlightInfoProcessor.getEmpty());
                Collections.sort(passes, (o1, o2) -> {
                    if (o1 instanceof GeneralHighlightingPass) {
                        return -1;
                    }
                    if (o2 instanceof GeneralHighlightingPass) {
                        return 1;
                    }
                    return 0;
                });
                try {
                    for (TextEditorHighlightingPass pass : passes) {
                        pass.doCollectInformation(progress);
                        result2.addAll(pass.getInfos());
                    }
                }
                catch (ProcessCanceledException e2) {
                    LOG.debug("Canceled: " + progress);
                    throw e2;
                }
            }
            finally {
                this.stopProcess(true, "re-enable background daemon after main passes run");
            }
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runMainPasses"));
        }
        return arrayList;
    }

    @NotNull
    public List<HighlightInfo> runPasses(@NotNull PsiFile file2, @NotNull Document document, @NotNull TextEditor textEditor, @NotNull int[] toIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (textEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        List<HighlightInfo> list2 = this.runPasses(file2, document, Collections.singletonList(textEditor), toIgnore, canChangeDocument, callbackWhileWaiting);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        return list2;
    }

    public void mustWaitForSmartMode(boolean mustWait, @NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "mustWaitForSmartMode"));
        }
        boolean old = this.mustWaitForSmartMode;
        this.mustWaitForSmartMode = mustWait;
        Disposer.register((Disposable)parent, () -> {
            this.mustWaitForSmartMode = old;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<HighlightInfo> runPasses(@NotNull PsiFile file2, @NotNull Document document, @NotNull List<TextEditor> textEditors, @NotNull int[] toIgnore, boolean canChangeDocument, @Nullable Runnable callbackWhileWaiting) throws ProcessCanceledException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (textEditors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textEditors", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        if (toIgnore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toIgnore", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        assert (this.myInitialized);
        assert (!this.myDisposed);
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.assertIsDispatchThread();
        if (application.isWriteAccessAllowed()) {
            throw new AssertionError((Object)"Must not start highlighting from within write action, or deadlock is imminent");
        }
        DaemonProgressIndicator.setDebug(!ApplicationInfoImpl.isInStressTest());
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
        UIUtil.dispatchAllInvocationEvents();
        while (RefreshQueueImpl.isRefreshInProgress() || HeavyProcessLatch.INSTANCE.isRunning()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        long dstart = System.currentTimeMillis();
        while (this.mustWaitForSmartMode && DumbService.getInstance((Project)this.myProject).isDumb()) {
            if (System.currentTimeMillis() > dstart + 100000L) {
                throw new IllegalStateException("Timeout waiting for smart mode. If you absolutely want to be dumb, please use DaemonCodeAnalyzerImpl.mustWaitForSmartMode(false).");
            }
            UIUtil.dispatchAllInvocationEvents();
        }
        UIUtil.dispatchAllInvocationEvents();
        Project project2 = file2.getProject();
        FileStatusMap fileStatusMap = this.getFileStatusMap();
        fileStatusMap.allowDirt(canChangeDocument);
        HashMap<FileEditor, HighlightingPass[]> map2 = new HashMap<FileEditor, HighlightingPass[]>();
        for (TextEditor textEditor : textEditors) {
            TextEditorBackgroundHighlighter highlighter2;
            if (textEditor instanceof TextEditorImpl) {
                try {
                    ((TextEditorImpl)textEditor).waitForLoaded(10L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e2) {
                    throw new RuntimeException(textEditor + " has not completed loading in 10 seconds");
                }
            }
            if ((highlighter2 = (TextEditorBackgroundHighlighter)textEditor.getBackgroundHighlighter()) == null) {
                Editor editor = textEditor.getEditor();
                throw new RuntimeException("Null highlighter from " + textEditor + "; loaded: " + AsyncEditorLoader.isEditorLoaded(editor));
            }
            List<TextEditorHighlightingPass> passes = highlighter2.getPasses(toIgnore);
            HighlightingPass[] array2 = passes.toArray(new HighlightingPass[passes.size()]);
            assert (array2.length != 0) : "Highlighting is disabled for the file " + file2;
            map2.put((FileEditor)textEditor, array2);
        }
        for (Object ignoreId : (Object)toIgnore) {
            fileStatusMap.markFileUpToDate(document, (int)ignoreId);
        }
        this.myUpdateRunnableFuture.cancel(false);
        DaemonProgressIndicator progress = this.createUpdateProgress();
        this.myPassExecutorService.submitPasses(map2, progress);
        long start2 = System.currentTimeMillis();
        while (progress.isRunning() && System.currentTimeMillis() < start2 + 300000L) {
            DaemonCodeAnalyzerImpl.wrap(() -> {
                progress.checkCanceled();
                if (callbackWhileWaiting != null) {
                    callbackWhileWaiting.run();
                }
                this.waitInOtherThread(50, canChangeDocument);
                UIUtil.dispatchAllInvocationEvents();
                Throwable savedException = PassExecutorService.getSavedException(progress);
                if (savedException != null) {
                    throw savedException;
                }
            });
        }
        if (progress.isRunning() && !progress.isCanceled()) {
            throw new RuntimeException("Highlighting still running after " + (System.currentTimeMillis() - start2) / 1000L + " seconds.\n" + ThreadDumper.dumpThreadsToString());
        }
        HighlightingSessionImpl session2 = (HighlightingSessionImpl)HighlightingSessionImpl.getOrCreateHighlightingSession(file2, textEditors.get(0).getEditor(), progress, null);
        DaemonCodeAnalyzerImpl.wrap(() -> {
            if (!this.waitInOtherThread(60000, canChangeDocument)) {
                throw new TimeoutException("Unable to complete in 60s");
            }
            session2.waitForHighlightInfosApplied();
        });
        UIUtil.dispatchAllInvocationEvents();
        UIUtil.dispatchAllInvocationEvents();
        assert (progress.isCanceled() && progress.isDisposed());
        List<HighlightInfo> list2 = DaemonCodeAnalyzerImpl.getHighlights(document, null, project2);
        List<HighlightInfo> list3 = list2;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "runPasses"));
        }
        return list3;
        finally {
            DaemonProgressIndicator.setDebug(false);
            fileStatusMap.allowDirt(true);
            this.waitForTermination();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitInOtherThread(int millis, boolean canChangeDocument) throws Throwable {
        Disposable disposable = Disposer.newDisposable();
        this.myProject.getMessageBus().connect(disposable).subscribe(PsiModificationTracker.TOPIC, () -> {
            throw new IllegalStateException("You must not perform PSI modifications from inside highlighting");
        });
        if (!canChangeDocument) {
            this.myProject.getMessageBus().connect(disposable).subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListenerAdapter(){

                public void daemonCancelEventOccurred(@NotNull String reason) {
                    if (reason == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$1", "daemonCancelEventOccurred"));
                    }
                    throw new IllegalStateException("You must not cancel daemon inside highlighting test: " + reason);
                }
            });
        }
        try {
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    return this.myPassExecutorService.waitFor(millis);
                }
                catch (Throwable e2) {
                    throw new RuntimeException(e2);
                }
            });
            boolean bl = (Boolean)future2.get();
            return bl;
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public void prepareForTest() {
        this.setUpdateByTimerEnabled(false);
        this.waitForTermination();
    }

    public void cleanupAfterTest() {
        if (this.myProject.isOpen()) {
            this.prepareForTest();
        }
    }

    void waitForTermination() {
        this.myPassExecutorService.cancelAll(true);
    }

    public void settingsChanged() {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        if (settings.isCodeHighlightingChanged(this.myLastSettings)) {
            this.restart();
        }
        this.myLastSettings = ((DaemonCodeAnalyzerSettingsImpl)settings).clone();
    }

    public void updateVisibleHighlighters(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "updateVisibleHighlighters"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    public void setUpdateByTimerEnabled(boolean value2) {
        this.myUpdateByTimerEnabled = value2;
        this.stopProcess(value2, "Update by timer change");
    }

    public void disableUpdateByTimer(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "disableUpdateByTimer"));
        }
        this.setUpdateByTimerEnabled(false);
        ++this.myDisableCount;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.register((Disposable)parentDisposable, () -> {
            --this.myDisableCount;
            if (this.myDisableCount == 0) {
                this.setUpdateByTimerEnabled(true);
            }
        });
    }

    boolean isUpdateByTimerEnabled() {
        return this.myUpdateByTimerEnabled;
    }

    public void setImportHintsEnabled(@NotNull PsiFile file2, boolean value2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setImportHintsEnabled"));
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (value2) {
            this.myDisabledHintsFiles.remove(vFile);
            this.stopProcess(true, "Import hints change");
        } else {
            this.myDisabledHintsFiles.add(vFile);
            HintManager.getInstance().hideAllHints();
        }
    }

    public void resetImportHintsEnabledForProject() {
        this.myDisabledHintsFiles.clear();
    }

    public void setHighlightingEnabled(@NotNull PsiFile file2, boolean value2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setHighlightingEnabled"));
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file2);
        if (value2) {
            this.myDisabledHighlightingFiles.remove(virtualFile);
        } else {
            this.myDisabledHighlightingFiles.add(virtualFile);
        }
    }

    public boolean isHighlightingAvailable(@Nullable PsiFile file2) {
        if (file2 == null || !file2.isPhysical()) {
            return false;
        }
        if (this.myDisabledHighlightingFiles.contains(PsiUtilCore.getVirtualFile((PsiElement)file2))) {
            return false;
        }
        if (file2 instanceof PsiCompiledElement) {
            return false;
        }
        FileType fileType = file2.getFileType();
        return !fileType.isBinary();
    }

    public boolean isImportHintsEnabled(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isImportHintsEnabled"));
        }
        return this.isAutohintsAvailable(file2) && !this.myDisabledHintsFiles.contains(file2.getVirtualFile());
    }

    public boolean isAutohintsAvailable(PsiFile file2) {
        return this.isHighlightingAvailable(file2) && !(file2 instanceof PsiCompiledElement);
    }

    public void restart() {
        this.doRestart();
    }

    boolean doRestart() {
        this.myFileStatusMap.markAllFilesDirty("Global restart");
        return this.stopProcess(true, "Global restart");
    }

    public void restart(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "restart"));
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(file2);
        if (document == null) {
            return;
        }
        String reason = "Psi file restart: " + file2.getName();
        this.myFileStatusMap.markFileScopeDirty(document, new TextRange(0, document.getTextLength()), file2.getTextLength(), reason);
        this.stopProcess(true, reason);
    }

    @NotNull
    List<TextEditorHighlightingPass> getPassesToShowProgressFor(Document document) {
        List<TextEditorHighlightingPass> allPasses = this.myPassExecutorService.getAllSubmittedPasses();
        ArrayList<TextEditorHighlightingPass> result2 = new ArrayList<TextEditorHighlightingPass>(allPasses.size());
        for (TextEditorHighlightingPass pass : allPasses) {
            if (pass.getDocument() != document && pass.getDocument() != null) continue;
            result2.add(pass);
        }
        ArrayList<TextEditorHighlightingPass> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getPassesToShowProgressFor"));
        }
        return arrayList;
    }

    boolean isAllAnalysisFinished(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isAllAnalysisFinished"));
        }
        if (this.myDisposed) {
            return false;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(file2);
        return document != null && document.getModificationStamp() == file2.getViewProvider().getModificationStamp() && this.myFileStatusMap.allDirtyScopesAreNull(document);
    }

    @Override
    public boolean isErrorAnalyzingFinished(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isErrorAnalyzingFinished"));
        }
        if (this.myDisposed) {
            return false;
        }
        Document document = this.myPsiDocumentManager.getCachedDocument(file2);
        return document != null && document.getModificationStamp() == file2.getViewProvider().getModificationStamp() && this.myFileStatusMap.getFileDirtyScope(document, 4) == null;
    }

    @Override
    @NotNull
    public FileStatusMap getFileStatusMap() {
        FileStatusMap fileStatusMap = this.myFileStatusMap;
        if (fileStatusMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getFileStatusMap"));
        }
        return fileStatusMap;
    }

    synchronized boolean isRunning() {
        return !this.myUpdateProgress.isCanceled();
    }

    public boolean isRunningOrPending() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.isRunning() || !this.myUpdateRunnableFuture.isDone();
    }

    synchronized boolean stopProcess(boolean toRestartAlarm, @NotNull @NonNls String reason) {
        boolean restart;
        if (reason == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "stopProcess"));
        }
        boolean canceled = this.cancelUpdateProgress(toRestartAlarm, reason);
        boolean bl = restart = toRestartAlarm && !this.myDisposed && this.myInitialized;
        if (restart && this.myUpdateRunnableFuture.isDone()) {
            this.myUpdateRunnableFuture.cancel(false);
            this.myUpdateRunnableFuture = this.myAlarm.schedule(this.myUpdateRunnable, (long)this.mySettings.AUTOREPARSE_DELAY, TimeUnit.MILLISECONDS);
        }
        return canceled;
    }

    private synchronized boolean cancelUpdateProgress(boolean toRestartAlarm, @NonNls String reason) {
        DaemonProgressIndicator updateProgress = this.myUpdateProgress;
        if (this.myDisposed) {
            return false;
        }
        boolean wasCanceled = updateProgress.isCanceled();
        this.myPassExecutorService.cancelAll(false);
        if (!wasCanceled) {
            PassExecutorService.log(updateProgress, null, "Cancel", reason, toRestartAlarm);
            updateProgress.cancel();
            return true;
        }
        return false;
    }

    static boolean processHighlightsNearOffset(@NotNull Document document, @NotNull Project project2, @NotNull HighlightSeverity minSeverity, int offset, boolean includeFixRange, @NotNull Processor<HighlightInfo> processor2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (minSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "processHighlightsNearOffset"));
        }
        return DaemonCodeAnalyzerImpl.processHighlights(document, project2, null, 0, document.getTextLength(), (Processor<HighlightInfo>)((Processor)info -> {
            if (minSeverity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "lambda$processHighlightsNearOffset$9"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "lambda$processHighlightsNearOffset$9"));
            }
            if (!DaemonCodeAnalyzerImpl.isOffsetInsideHighlightInfo(offset, info, includeFixRange)) {
                return true;
            }
            int compare = info.getSeverity().compareTo(minSeverity);
            return compare < 0 || processor2.process(info);
        }));
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        return this.findHighlightByOffset(document, offset, includeFixRange, HighlightSeverity.INFORMATION);
    }

    @Nullable
    HighlightInfo findHighlightByOffset(@NotNull Document document, int offset, boolean includeFixRange, @NotNull HighlightSeverity minSeverity) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        if (minSeverity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minSeverity", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "findHighlightByOffset"));
        }
        SmartList foundInfoList = new SmartList();
        DaemonCodeAnalyzerImpl.processHighlightsNearOffset(document, this.myProject, minSeverity, offset, includeFixRange, (Processor<HighlightInfo>)((Processor)arg_0 -> DaemonCodeAnalyzerImpl.lambda$findHighlightByOffset$10((List)foundInfoList, arg_0)));
        if (foundInfoList.isEmpty()) {
            return null;
        }
        if (foundInfoList.size() == 1) {
            return (HighlightInfo)foundInfoList.get(0);
        }
        return new HighlightInfoComposite((List<HighlightInfo>)foundInfoList);
    }

    private static boolean isOffsetInsideHighlightInfo(int offset, @NotNull HighlightInfo info, boolean includeFixRange) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "isOffsetInsideHighlightInfo"));
        }
        RangeHighlighterEx highlighter2 = info.getHighlighter();
        if (highlighter2 == null || !highlighter2.isValid()) {
            return false;
        }
        int startOffset = highlighter2.getStartOffset();
        int endOffset = highlighter2.getEndOffset();
        if (startOffset <= offset && offset <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        RangeMarker fixMarker = info.fixMarker;
        if (fixMarker != null) {
            if (!fixMarker.isValid()) {
                return false;
            }
            startOffset = fixMarker.getStartOffset();
            endOffset = fixMarker.getEndOffset();
            return startOffset <= offset && offset <= endOffset;
        }
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo> getLineMarkers(@NotNull Document document, @NotNull Project project2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getLineMarkers"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getLineMarkers"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>();
        LineMarkersUtil.processLineMarkers(project2, document, (Segment)new TextRange(0, document.getTextLength()), -1, (Processor<LineMarkerInfo>)new CommonProcessors.CollectProcessor(result2));
        ArrayList<LineMarkerInfo> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getLineMarkers"));
        }
        return arrayList;
    }

    void setLastIntentionHint(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentions, boolean hasToRecreate) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "setLastIntentionHint"));
        }
        if (!editor.getSettings().isShowIntentionBulb()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.hideLastIntentionHint();
        if (editor.getCaretModel().getCaretCount() > 1) {
            return;
        }
        IntentionHintComponent hintComponent = IntentionHintComponent.showIntentionHint(project2, file2, editor, intentions, false);
        if (hasToRecreate) {
            hintComponent.recreate();
        }
        this.myLastIntentionHint = hintComponent;
    }

    void hideLastIntentionHint() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        IntentionHintComponent hint = this.myLastIntentionHint;
        if (hint != null && hint.isVisible()) {
            hint.hide();
            this.myLastIntentionHint = null;
        }
    }

    @Nullable
    public IntentionHintComponent getLastIntentionHint() {
        return this.myLastIntentionHint;
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        if (this.myDisabledHintsFiles.isEmpty()) {
            return state;
        }
        SmartList array2 = new SmartList();
        for (VirtualFile file2 : this.myDisabledHintsFiles) {
            if (!file2.isValid()) continue;
            array2.add(file2.getUrl());
        }
        if (!array2.isEmpty()) {
            Collections.sort(array2);
            Element disableHintsElement = new Element(DISABLE_HINTS_TAG);
            state.addContent(disableHintsElement);
            for (String url : array2) {
                disableHintsElement.addContent(new Element(FILE_TAG).setAttribute(URL_ATT, url));
            }
        }
        return state;
    }

    public void loadState(Element state) {
        this.myDisabledHintsFiles.clear();
        Element element = state.getChild(DISABLE_HINTS_TAG);
        if (element != null) {
            for (Element e2 : element.getChildren(FILE_TAG)) {
                VirtualFile file2;
                String url = e2.getAttributeValue(URL_ATT);
                if (url == null || (file2 = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
                this.myDisabledHintsFiles.add(file2);
            }
        }
    }

    @NotNull
    private synchronized DaemonProgressIndicator createUpdateProgress() {
        DaemonProgressIndicator old = this.myUpdateProgress;
        if (!old.isCanceled()) {
            old.cancel();
        }
        DaemonProgressIndicator progress = new DaemonProgressIndicator(){

            @Override
            public void stopIfRunning() {
                super.stopIfRunning();
                ((DaemonCodeAnalyzer.DaemonListener)DaemonCodeAnalyzerImpl.this.myProject.getMessageBus().syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC)).daemonFinished();
            }
        };
        progress.setModalityProgress(null);
        progress.start();
        this.myUpdateProgress = progress;
        DaemonProgressIndicator daemonProgressIndicator = progress;
        if (daemonProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "createUpdateProgress"));
        }
        return daemonProgressIndicator;
    }

    public void autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "autoImportReferenceAtCursor"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", FILE_TAG, "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "autoImportReferenceAtCursor"));
        }
        for (ReferenceImporter importer : (ReferenceImporter[])Extensions.getExtensions(ReferenceImporter.EP_NAME)) {
            if (importer.autoImportReferenceAtCursor(editor, file2)) break;
        }
    }

    @NotNull
    synchronized DaemonProgressIndicator getUpdateProgress() {
        DaemonProgressIndicator daemonProgressIndicator = this.myUpdateProgress;
        if (daemonProgressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getUpdateProgress"));
        }
        return daemonProgressIndicator;
    }

    @NotNull
    private Collection<FileEditor> getSelectedEditors() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        List<Editor> editors = this.getActiveEditors();
        THashSet activeTextEditors = new THashSet(editors.size());
        for (Editor editor : editors) {
            if (editor.isDisposed()) continue;
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
            activeTextEditors.add(textEditor);
        }
        if (ApplicationManager.getApplication().getCurrentModalityState() != ModalityState.NON_MODAL) {
            THashSet tHashSet = activeTextEditors;
            if (tHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getSelectedEditors"));
            }
            return tHashSet;
        }
        THashSet result2 = new THashSet();
        THashSet files2 = new THashSet(activeTextEditors.size());
        FileEditor[] tabEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors();
        for (FileEditor tabEditor : tabEditors) {
            if (!tabEditor.isValid()) continue;
            VirtualFile file2 = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(tabEditor);
            if (file2 != null) {
                files2.add(file2);
            }
            result2.add(tabEditor);
        }
        for (FileEditor fileEditor : activeTextEditors) {
            VirtualFile file3 = ((FileEditorManagerEx)FileEditorManager.getInstance((Project)this.myProject)).getFile(fileEditor);
            if (file3 != null && files2.contains(file3)) continue;
            result2.add(fileEditor);
        }
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getSelectedEditors"));
        }
        return tHashSet;
    }

    @NotNull
    private List<Editor> getActiveEditors() {
        List<Editor> list2 = this.myEditorTracker.getActiveEditors();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "getActiveEditors"));
        }
        return list2;
    }

    private static void wrap(@NotNull ThrowableRunnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl", "wrap"));
        }
        try {
            runnable2.run();
        }
        catch (Error | RuntimeException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            throw new RuntimeException(e3);
        }
    }

    private static /* synthetic */ boolean lambda$findHighlightByOffset$10(List foundInfoList, HighlightInfo info) {
        if (info.getSeverity() == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY) {
            return true;
        }
        if (!foundInfoList.isEmpty()) {
            HighlightInfo foundInfo = (HighlightInfo)foundInfoList.get(0);
            int compare = foundInfo.getSeverity().compareTo(info.getSeverity());
            if (compare < 0) {
                foundInfoList.clear();
            } else if (compare > 0) {
                return true;
            }
        }
        foundInfoList.add(info);
        return true;
    }

    private static class UpdateRunnable
    implements Runnable {
        private Project myProject;

        private UpdateRunnable(@NotNull Project project2) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl$UpdateRunnable", "<init>"));
            }
            this.myProject = project2;
        }

        @Override
        public void run() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            Project project2 = this.myProject;
            DaemonCodeAnalyzerImpl daemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project2);
            if (project2 == null || !project2.isInitialized() || project2.isDisposed() || PowerSaveMode.isEnabled() || daemonCodeAnalyzer.myDisposed) {
                return;
            }
            if (HeavyProcessLatch.INSTANCE.isRunning()) {
                HeavyProcessLatch.INSTANCE.executeOutOfHeavyProcess(() -> daemonCodeAnalyzer.stopProcess(true, "re-scheduled to execute after heavy processing finished"));
                return;
            }
            Editor activeEditor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
            if (activeEditor == null) {
                AutoPopupController.runTransactionWithEverythingCommitted(project2, daemonCodeAnalyzer.submitPassesRunnable);
            } else {
                ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)project2)).cancelAndRunWhenAllCommitted("start daemon when all committed", daemonCodeAnalyzer.submitPassesRunnable);
            }
        }

        private void clearFieldsOnDispose() {
            this.myProject = null;
        }
    }
}

