/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.GotoNextErrorHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.ex.ErrorStripeAdapter;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ErrorStripeHandler
extends ErrorStripeAdapter {
    private final Project myProject;

    public ErrorStripeHandler(Project project2) {
        this.myProject = project2;
    }

    @Override
    public void errorMarkerClicked(@NotNull ErrorStripeEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/ErrorStripeHandler", "errorMarkerClicked"));
        }
        RangeHighlighter highlighter2 = e2.getHighlighter();
        if (!highlighter2.isValid()) {
            return;
        }
        HighlightInfo info = ErrorStripeHandler.findInfo(highlighter2);
        if (info != null) {
            GotoNextErrorHandler.navigateToError(this.myProject, e2.getEditor(), info);
        }
    }

    private static HighlightInfo findInfo(RangeHighlighter highlighter2) {
        Object o2 = highlighter2.getErrorStripeTooltip();
        if (o2 instanceof HighlightInfo) {
            return (HighlightInfo)o2;
        }
        return null;
    }
}

