/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ExternalToolPassFactory;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalToolPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(ExternalToolPass.class);
    private final AnnotationHolderImpl myAnnotationHolder;
    private final Map<ExternalAnnotator, MyData> myAnnotator2DataMap;
    private final ExternalToolPassFactory myExternalToolPassFactory;
    private final boolean myMainHighlightingPass;

    ExternalToolPass(@NotNull ExternalToolPassFactory externalToolPassFactory, @NotNull PsiFile file2, @NotNull Editor editor, int startOffset, int endOffset) {
        if (externalToolPassFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalToolPassFactory", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        super(file2.getProject(), editor.getDocument(), "External annotators", file2, editor, new TextRange(startOffset, endOffset), false, new DefaultHighlightInfoProcessor());
        this.myAnnotator2DataMap = new HashMap();
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
        this.myExternalToolPassFactory = externalToolPassFactory;
        this.myMainHighlightingPass = false;
    }

    ExternalToolPass(@NotNull ExternalToolPassFactory externalToolPassFactory, @NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, @NotNull HighlightInfoProcessor highlightInfoProcessor, boolean mainHighlightingPass) {
        if (externalToolPassFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalToolPassFactory", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "<init>"));
        }
        super(file2.getProject(), document, "External annotators", file2, null, new TextRange(startOffset, endOffset), false, highlightInfoProcessor);
        this.myAnnotator2DataMap = new HashMap();
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
        this.myExternalToolPassFactory = externalToolPassFactory;
        this.myMainHighlightingPass = mainHighlightingPass;
    }

    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "collectInformationWithProgress"));
        }
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        Set relevantLanguages = viewProvider.getLanguages();
        int externalAnnotatorsInRoots = 0;
        for (Language language : relevantLanguages) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)psiRoot)) continue;
            List externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)psiRoot);
            externalAnnotatorsInRoots += externalAnnotators.size();
        }
        this.setProgressLimit(externalAnnotatorsInRoots);
        InspectionProfileImpl profile2 = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        for (Language language : relevantLanguages) {
            List externalAnnotators;
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (!HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)psiRoot) || (externalAnnotators = ExternalLanguageAnnotators.allForFile((Language)language, (PsiFile)psiRoot)).isEmpty()) continue;
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
            boolean errorFound = daemonCodeAnalyzer.getFileStatusMap().wasErrorFound(this.myDocument);
            for (ExternalAnnotator externalAnnotator : externalAnnotators) {
                Editor editor;
                String shortName = externalAnnotator.getPairedBatchInspectionShortName();
                if (shortName != null) {
                    HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
                    LOG.assertTrue(key != null, (Object)("Paired tool '" + shortName + "' not found for external annotator: " + externalAnnotator));
                    if (!profile2.isToolEnabled(key, (PsiElement)this.myFile)) continue;
                }
                Object collectedInfo = (editor = this.getEditor()) != null ? externalAnnotator.collectInformation(psiRoot, editor, errorFound) : externalAnnotator.collectInformation(psiRoot);
                this.advanceProgress(1L);
                if (collectedInfo == null) continue;
                this.myAnnotator2DataMap.put(externalAnnotator, new MyData(psiRoot, collectedInfo));
            }
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        if (this.myProject.isDisposed()) {
            List<HighlightInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "getInfos"));
            }
            return list2;
        }
        if (this.myMainHighlightingPass) {
            this.doAnnotate();
            this.applyRelevant();
            List<HighlightInfo> list3 = this.getHighlights();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "getInfos"));
            }
            return list3;
        }
        List<HighlightInfo> list4 = super.getInfos();
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "getInfos"));
        }
        return list4;
    }

    @Override
    protected void applyInformationWithProgress() {
        final long modificationStampBefore = this.myDocument.getModificationStamp();
        Update update2 = new Update(this.myFile){

            public void setRejected() {
                super.setRejected();
                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
            }

            public void run() {
                if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                    return;
                }
                ExternalToolPass.this.doAnnotate();
                ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                    if (ExternalToolPass.this.documentChanged(modificationStampBefore) || ExternalToolPass.this.myProject.isDisposed()) {
                        return;
                    }
                    ExternalToolPass.this.applyRelevant();
                    ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
                });
            }
        };
        this.myExternalToolPassFactory.scheduleExternalActivity(update2);
    }

    private boolean documentChanged(long modificationStampBefore) {
        return this.myDocument.getModificationStamp() != modificationStampBefore;
    }

    @NotNull
    private List<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myAnnotationHolder.size());
        Iterator iterator2 = this.myAnnotationHolder.iterator();
        while (iterator2.hasNext()) {
            Annotation annotation = (Annotation)iterator2.next();
            infos.add(HighlightInfo.fromAnnotation(annotation));
        }
        ArrayList<HighlightInfo> arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "getHighlights"));
        }
        return arrayList;
    }

    private void applyRelevant() {
        for (ExternalAnnotator annotator : this.myAnnotator2DataMap.keySet()) {
            MyData data = this.myAnnotator2DataMap.get(annotator);
            if (data == null || data.myAnnotationResult == null) continue;
            annotator.apply(data.myPsiRoot, data.myAnnotationResult, (AnnotationHolder)this.myAnnotationHolder);
        }
    }

    private void doFinish(@NotNull List<HighlightInfo> highlights, long modificationStampBefore) {
        if (highlights == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlights", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "doFinish"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            void highlights;
            if (highlights == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlights", "com/intellij/codeInsight/daemon/impl/ExternalToolPass", "lambda$doFinish$0"));
            }
            if (this.documentChanged(modificationStampBefore) || this.myProject.isDisposed()) {
                return;
            }
            UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), (Collection<HighlightInfo>)highlights, this.getColorsScheme(), this.getId());
            DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
            daemonCodeAnalyzer.getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
        }, ModalityState.stateForComponent((Component)this.getEditor().getComponent()));
    }

    private void doAnnotate() {
        for (ExternalAnnotator annotator : DumbService.getInstance((Project)this.myProject).filterByDumbAwareness(this.myAnnotator2DataMap.keySet())) {
            MyData data = this.myAnnotator2DataMap.get(annotator);
            if (data == null) continue;
            data.myAnnotationResult = annotator.doAnnotate(data.myCollectedInfo);
        }
    }

    private static class MyData {
        private final PsiFile myPsiRoot;
        private final Object myCollectedInfo;
        private volatile Object myAnnotationResult;

        private MyData(@NotNull PsiFile psiRoot, @NotNull Object collectedInfo) {
            if (psiRoot == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiRoot", "com/intellij/codeInsight/daemon/impl/ExternalToolPass$MyData", "<init>"));
            }
            if (collectedInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectedInfo", "com/intellij/codeInsight/daemon/impl/ExternalToolPass$MyData", "<init>"));
            }
            this.myPsiRoot = psiRoot;
            this.myCollectedInfo = collectedInfo;
        }
    }
}

