/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GutterIntentionAction
extends AbstractIntentionAction
implements Comparable<IntentionAction>,
Iconable,
ShortcutProvider {
    private final AnAction myAction;
    private final int myOrder;
    private final Icon myIcon;
    private String myText;

    private GutterIntentionAction(AnAction action2, int order, Icon icon) {
        this.myAction = action2;
        this.myOrder = order;
        this.myIcon = icon;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "invoke"));
        }
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        this.myAction.actionPerformed(new AnActionEvent((InputEvent)relativePoint.toMouseEvent(), ((EditorEx)editor).getDataContext(), this.myText, new Presentation(), ActionManager.getInstance(), 0));
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "isAvailable"));
        }
        return this.myText != null ? StringUtil.isNotEmpty((String)this.myText) : this.isAvailable(GutterIntentionAction.createActionEvent((EditorEx)editor));
    }

    @NotNull
    private static AnActionEvent createActionEvent(EditorEx editor) {
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)editor.getDataContext());
        if (anActionEvent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "createActionEvent"));
        }
        return anActionEvent;
    }

    private boolean isAvailable(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "isAvailable"));
        }
        if (this.myText == null) {
            String text2;
            this.myAction.update(event);
            this.myText = event.getPresentation().isEnabled() && event.getPresentation().isVisible() ? ((text2 = event.getPresentation().getText()) != null ? text2 : StringUtil.notNullize((String)this.myAction.getTemplatePresentation().getText())) : "";
        }
        return StringUtil.isNotEmpty((String)this.myText);
    }

    @NotNull
    public String getText() {
        String string2 = StringUtil.notNullize((String)this.myText);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "getText"));
        }
        return string2;
    }

    static void addActions(@NotNull Editor hostEditor, @NotNull ShowIntentionsPass.IntentionsInfo intentions, Project project2, List<RangeHighlighterEx> result2) {
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostEditor", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (intentions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentions", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        AnActionEvent event = GutterIntentionAction.createActionEvent((EditorEx)hostEditor);
        for (RangeHighlighterEx highlighter2 : result2) {
            GutterIntentionAction.addActions(project2, highlighter2, intentions.guttersToShow, event);
        }
    }

    private static void addActions(@NotNull Project project2, @NotNull RangeHighlighterEx info, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull AnActionEvent event) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        GutterIconRenderer r2 = info.getGutterIconRenderer();
        if (r2 == null || DumbService.isDumb((Project)project2) && !DumbService.isDumbAware((Object)r2)) {
            return;
        }
        ArrayList<HighlightInfo.IntentionActionDescriptor> list2 = new ArrayList<HighlightInfo.IntentionActionDescriptor>();
        for (AnAction action2 : (AnAction[])ContainerUtil.ar((Object[])new AnAction[]{r2.getClickAction(), r2.getMiddleButtonClickAction(), r2.getRightButtonClickAction(), r2.getPopupMenuActions()})) {
            if (action2 == null) continue;
            GutterIntentionAction.addActions(action2, list2, r2, 0, event);
        }
        if (list2.isEmpty()) {
            return;
        }
        if (list2.size() == 1) {
            descriptors.addAll(list2);
        } else {
            HighlightInfo.IntentionActionDescriptor first = (HighlightInfo.IntentionActionDescriptor)list2.get(0);
            List options = ContainerUtil.map(list2.subList(1, list2.size()), HighlightInfo.IntentionActionDescriptor::getAction);
            descriptors.add(new HighlightInfo.IntentionActionDescriptor(first.getAction(), options, null, first.getIcon()));
        }
    }

    private static void addActions(@NotNull AnAction action2, @NotNull List<HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull GutterIconRenderer renderer, int order, @NotNull AnActionEvent event) {
        GutterIntentionAction gutterAction;
        Icon icon;
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "addActions"));
        }
        if (action2 instanceof ActionGroup) {
            AnAction[] children2 = ((ActionGroup)action2).getChildren(null);
            for (int i2 = 0; i2 < children2.length; ++i2) {
                GutterIntentionAction.addActions(children2[i2], descriptors, renderer, i2 + order, event);
            }
        }
        if ((icon = action2.getTemplatePresentation().getIcon()) == null) {
            icon = renderer.getIcon();
        }
        if (icon.getIconWidth() < 16) {
            icon = IconUtil.toSize((Icon)icon, (int)16, (int)16);
        }
        if (!(gutterAction = new GutterIntentionAction(action2, order, icon)).isAvailable(event)) {
            return;
        }
        descriptors.add(new HighlightInfo.IntentionActionDescriptor((IntentionAction)gutterAction, Collections.emptyList(), null, icon){

            @Override
            @NotNull
            public String getDisplayName() {
                String string2 = gutterAction.getText();
                if (string2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction$1", "getDisplayName"));
                }
                return string2;
            }
        });
    }

    @Override
    public int compareTo(@NotNull IntentionAction o2) {
        if (o2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/codeInsight/daemon/impl/GutterIntentionAction", "compareTo"));
        }
        if (o2 instanceof GutterIntentionAction) {
            return this.myOrder - ((GutterIntentionAction)o2).myOrder;
        }
        return 0;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.myIcon;
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction.getShortcutSet();
    }
}

