/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HighlightersRecycler {
    private final MultiMap<TextRange, RangeHighlighter> incinerator = MultiMap.createSmart();

    HighlightersRecycler() {
    }

    void recycleHighlighter(@NotNull RangeHighlighter highlighter2) {
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/codeInsight/daemon/impl/HighlightersRecycler", "recycleHighlighter"));
        }
        if (highlighter2.isValid()) {
            this.incinerator.putValue((Object)ProperTextRange.create((Segment)highlighter2), (Object)highlighter2);
        }
    }

    @Nullable
    RangeHighlighter pickupHighlighterFromGarbageBin(int startOffset, int endOffset, int layer) {
        TextRange range = new TextRange(startOffset, endOffset);
        Collection collection = this.incinerator.get((Object)range);
        for (RangeHighlighter highlighter2 : collection) {
            if (!highlighter2.isValid() || highlighter2.getLayer() != layer) continue;
            this.incinerator.remove((Object)range, (Object)highlighter2);
            return highlighter2;
        }
        return null;
    }

    @NotNull
    Collection<? extends RangeHighlighter> forAllInGarbageBin() {
        Collection collection = this.incinerator.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightersRecycler", "forAllInGarbageBin"));
        }
        return collection;
    }
}

