/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LineMarkersUtil {
    private static final Logger LOG = Logger.getInstance(LineMarkersUtil.class);
    private static final Key<LineMarkerInfo> LINE_MARKER_INFO = Key.create((String)"LINE_MARKER_INFO");

    LineMarkersUtil() {
    }

    static boolean processLineMarkers(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, int group, @NotNull Processor<LineMarkerInfo> processor2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "processLineMarkers"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "processLineMarkers"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "processLineMarkers"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "processLineMarkers"));
        }
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        return markupModel.processRangeHighlightersOverlappingWith(bounds.getStartOffset(), bounds.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)highlighter2 -> {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "lambda$processLineMarkers$0"));
            }
            LineMarkerInfo info = LineMarkersUtil.getLineMarkerInfo(highlighter2);
            return info == null || group != -1 && info.updatePass != group || processor2.process((Object)info);
        }));
    }

    static void setLineMarkersToEditor(@NotNull Project project2, @NotNull Document document, @NotNull Segment bounds, @NotNull Collection<LineMarkerInfo> markers, int group) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        if (markers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "setLineMarkersToEditor"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        HighlightersRecycler toReuse = new HighlightersRecycler();
        LineMarkersUtil.processLineMarkers(project2, document, bounds, group, (Processor<LineMarkerInfo>)((Processor)info -> {
            toReuse.recycleHighlighter(info.highlighter);
            return true;
        }));
        if (LOG.isDebugEnabled()) {
            List<LineMarkerInfo> oldMarkers = DaemonCodeAnalyzerImpl.getLineMarkers(document, project2);
            LOG.debug("LineMarkersUtil.setLineMarkersToEditor(markers: " + markers + ", group: " + group + "); oldMarkers: " + oldMarkers + "; reused: " + toReuse.forAllInGarbageBin().size());
        }
        for (LineMarkerInfo lineMarkerInfo : markers) {
            TextRange elementRange;
            TextRange textRange;
            PsiElement element = lineMarkerInfo.getElement();
            if (element == null || (textRange = element.getTextRange()) == null || !TextRange.containsRange((Segment)bounds, (Segment)(elementRange = InjectedLanguageManager.getInstance((Project)project2).injectedToHost(element, textRange)))) continue;
            LineMarkersUtil.createOrReuseLineMarker(lineMarkerInfo, markupModel, toReuse);
        }
        for (RangeHighlighter rangeHighlighter : toReuse.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
        }
    }

    @NotNull
    private static RangeHighlighter createOrReuseLineMarker(@NotNull LineMarkerInfo info, @NotNull MarkupModel markupModel, @Nullable HighlightersRecycler toReuse) {
        boolean lineSeparatorPlacementChanged;
        RangeHighlighter highlighter2;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "createOrReuseLineMarker"));
        }
        if (markupModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markupModel", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "createOrReuseLineMarker"));
        }
        RangeHighlighter rangeHighlighter = highlighter2 = toReuse == null ? null : toReuse.pickupHighlighterFromGarbageBin(info.startOffset, info.endOffset, 3000);
        if (highlighter2 == null) {
            highlighter2 = markupModel.addRangeHighlighter(info.startOffset, info.endOffset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        }
        highlighter2.putUserData(LINE_MARKER_INFO, (Object)info);
        LineMarkerInfo.LineMarkerGutterIconRenderer newRenderer = (LineMarkerInfo.LineMarkerGutterIconRenderer)info.createGutterRenderer();
        LineMarkerInfo.LineMarkerGutterIconRenderer oldRenderer = highlighter2.getGutterIconRenderer() instanceof LineMarkerInfo.LineMarkerGutterIconRenderer ? (LineMarkerInfo.LineMarkerGutterIconRenderer)highlighter2.getGutterIconRenderer() : null;
        boolean rendererChanged = oldRenderer == null || newRenderer == null || !newRenderer.equals((Object)oldRenderer);
        boolean lineSeparatorColorChanged = !Comparing.equal((Object)highlighter2.getLineSeparatorColor(), (Object)info.separatorColor);
        boolean bl = lineSeparatorPlacementChanged = !Comparing.equal((Object)highlighter2.getLineSeparatorPlacement(), (Object)info.separatorPlacement);
        if (rendererChanged || lineSeparatorColorChanged || lineSeparatorPlacementChanged) {
            ((MarkupModelEx)markupModel).changeAttributesInBatch((RangeHighlighterEx)highlighter2, (Consumer<RangeHighlighterEx>)((Consumer)markerEx -> {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "lambda$createOrReuseLineMarker$2"));
                }
                if (rendererChanged) {
                    markerEx.setGutterIconRenderer((GutterIconRenderer)newRenderer);
                }
                if (lineSeparatorColorChanged) {
                    markerEx.setLineSeparatorColor(info.separatorColor);
                }
                if (lineSeparatorPlacementChanged) {
                    markerEx.setLineSeparatorPlacement(info.separatorPlacement);
                }
            }));
        }
        info.highlighter = highlighter2;
        RangeHighlighter rangeHighlighter2 = highlighter2;
        if (rangeHighlighter2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "createOrReuseLineMarker"));
        }
        return rangeHighlighter2;
    }

    static void addLineMarkerToEditorIncrementally(@NotNull Project project2, @NotNull Document document, @NotNull LineMarkerInfo marker) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "addLineMarkerToEditorIncrementally"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "addLineMarkerToEditorIncrementally"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "addLineMarkerToEditorIncrementally"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        LineMarkerInfo[] markerInTheWay = new LineMarkerInfo[]{null};
        boolean allIsClear = markupModel.processRangeHighlightersOverlappingWith(marker.startOffset, marker.endOffset, (Processor<? super RangeHighlighterEx>)((Processor)highlighter2 -> {
            markerInTheWay[0] = LineMarkersUtil.getLineMarkerInfo(highlighter2);
            return markerInTheWay[0] == null;
        }));
        if (allIsClear) {
            LineMarkersUtil.createOrReuseLineMarker(marker, markupModel, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("LineMarkersUtil.addLineMarkerToEditorIncrementally: " + marker + " " + (allIsClear ? "created" : " (was not added because " + markerInTheWay[0] + " was in the way)"));
        }
    }

    private static LineMarkerInfo getLineMarkerInfo(@NotNull RangeHighlighter highlighter2) {
        if (highlighter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/codeInsight/daemon/impl/LineMarkersUtil", "getLineMarkerInfo"));
        }
        return (LineMarkerInfo)highlighter2.getUserData(LINE_MARKER_INFO);
    }
}

