/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.Alarm;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPresentationManager
implements Disposable {
    private static final Key<MyFontMetrics> HINT_FONT_METRICS = Key.create((String)"ParameterHintFontMetrics");
    private static final Key<AnimationStep> ANIMATION_STEP = Key.create((String)"ParameterHintAnimationStep");
    private static final int ANIMATION_STEP_MS = 25;
    private static final int ANIMATION_CHARS_PER_STEP = 3;
    private static final float BACKGROUND_ALPHA = 0.55f;
    private final Alarm myAlarm = new Alarm((Disposable)this);

    public static ParameterHintsPresentationManager getInstance() {
        return (ParameterHintsPresentationManager)ServiceManager.getService(ParameterHintsPresentationManager.class);
    }

    private ParameterHintsPresentationManager() {
    }

    public boolean isParameterHint(@NotNull Inlay inlay) {
        if (inlay == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "isParameterHint"));
        }
        return inlay.getRenderer() instanceof MyRenderer;
    }

    public String getHintText(@NotNull Inlay inlay) {
        if (inlay == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "getHintText"));
        }
        EditorCustomElementRenderer renderer = inlay.getRenderer();
        return renderer instanceof MyRenderer ? ((MyRenderer)renderer).getText() : null;
    }

    public void addHint(@NotNull Editor editor, int offset, @NotNull String hintText, boolean useAnimation) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "addHint"));
        }
        if (hintText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintText", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "addHint"));
        }
        MyRenderer renderer = new MyRenderer(editor, hintText, useAnimation);
        Inlay inlay = editor.getInlayModel().addInlineElement(offset, (EditorCustomElementRenderer)renderer);
        if (useAnimation && inlay != null) {
            this.scheduleRendererUpdate(editor, inlay);
        }
    }

    public void deleteHint(@NotNull Editor editor, @NotNull Inlay hint) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "deleteHint"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "deleteHint"));
        }
        this.updateRenderer(editor, hint, null);
    }

    public void replaceHint(@NotNull Editor editor, @NotNull Inlay hint, @NotNull String newText) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "replaceHint"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "replaceHint"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "replaceHint"));
        }
        this.updateRenderer(editor, hint, newText);
    }

    private void updateRenderer(@NotNull Editor editor, @NotNull Inlay hint, @Nullable String newText) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "updateRenderer"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "updateRenderer"));
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        renderer.update(editor, newText);
        hint.updateSize();
        this.scheduleRendererUpdate(editor, hint);
    }

    public void dispose() {
    }

    private void scheduleRendererUpdate(@NotNull Editor editor, @NotNull Inlay inlay) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "scheduleRendererUpdate"));
        }
        if (inlay == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "scheduleRendererUpdate"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        AnimationStep step = (AnimationStep)editor.getUserData(ANIMATION_STEP);
        if (step == null) {
            step = new AnimationStep(editor);
            editor.putUserData(ANIMATION_STEP, (Object)step);
        }
        step.inlays.add(inlay);
        this.scheduleAnimationStep(step);
    }

    private void scheduleAnimationStep(@NotNull AnimationStep step) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "scheduleAnimationStep"));
        }
        this.myAlarm.cancelRequest((Runnable)step);
        this.myAlarm.addRequest((Runnable)step, 25, ModalityState.any());
    }

    private static Font getFont(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "getFont"));
        }
        return ParameterHintsPresentationManager.getFontMetrics(editor).getFont();
    }

    private static MyFontMetrics getFontMetrics(@NotNull Editor editor) {
        Font font;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "getFontMetrics"));
        }
        String familyName = UIManager.getFont("Label.font").getFamily();
        int size = Math.max(1, editor.getColorsScheme().getEditorFontSize() - 1);
        MyFontMetrics metrics = (MyFontMetrics)editor.getUserData(HINT_FONT_METRICS);
        if (metrics != null) {
            font = metrics.getFont();
            if (!familyName.equals(font.getFamily()) || size != font.getSize()) {
                metrics = null;
            } else {
                FontRenderContext currentContext = FontInfo.getFontRenderContext(editor.getContentComponent());
                if (currentContext.equals(metrics.metrics.getFontRenderContext())) {
                    metrics = null;
                }
            }
        }
        if (metrics == null) {
            font = new Font(familyName, 0, size);
            metrics = new MyFontMetrics(editor, font);
            editor.putUserData(HINT_FONT_METRICS, (Object)metrics);
        }
        return metrics;
    }

    private class AnimationStep
    implements Runnable {
        private final Editor myEditor;
        private final Set<Inlay> inlays;

        AnimationStep(Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$AnimationStep", "<init>"));
            }
            this.inlays = new HashSet<Inlay>();
            this.myEditor = editor;
            Disposer.register((Disposable)((EditorImpl)editor).getDisposable(), () -> ParameterHintsPresentationManager.this.myAlarm.cancelRequest((Runnable)this));
        }

        @Override
        public void run() {
            Iterator<Inlay> it = this.inlays.iterator();
            while (it.hasNext()) {
                Inlay inlay = it.next();
                if (inlay.isValid()) {
                    MyRenderer renderer = (MyRenderer)inlay.getRenderer();
                    if (!renderer.nextStep()) {
                        it.remove();
                    }
                    if (renderer.calcWidthInPixels(this.myEditor) == 0) {
                        Disposer.dispose((Disposable)inlay);
                        continue;
                    }
                    inlay.updateSize();
                    continue;
                }
                it.remove();
            }
            if (this.inlays.isEmpty()) {
                this.myEditor.putUserData(ANIMATION_STEP, null);
            } else {
                ParameterHintsPresentationManager.this.scheduleAnimationStep(this);
            }
        }
    }

    private static class MyRenderer
    implements EditorCustomElementRenderer {
        private String myText;
        private int startWidth;
        private int steps;
        private int step;

        private MyRenderer(Editor editor, String text2, boolean animated) {
            this.updateState(editor, text2);
            if (!animated) {
                this.step = this.steps + 1;
            }
        }

        private String getText() {
            return this.myText;
        }

        public void update(Editor editor, String newText) {
            this.updateState(editor, newText);
        }

        @Nullable
        public String getContextMenuGroupId() {
            return "ParameterNameHints";
        }

        private void updateState(Editor editor, String text2) {
            FontMetrics metrics = ParameterHintsPresentationManager.getFontMetrics(editor).metrics;
            this.startWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            this.myText = text2;
            int endWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            this.step = 1;
            this.steps = Math.max(1, Math.abs(endWidth - this.startWidth) / metrics.charWidth('a') / 3);
        }

        public boolean nextStep() {
            return ++this.step <= this.steps;
        }

        public int calcWidthInPixels(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "calcWidthInPixels"));
            }
            FontMetrics metrics = ParameterHintsPresentationManager.getFontMetrics(editor).metrics;
            int endWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            return this.step <= this.steps ? Math.max(1, this.startWidth + (endWidth - this.startWidth) / this.steps * this.step) : endWidth;
        }

        private static int doCalcWidth(@Nullable String text2, @NotNull FontMetrics fontMetrics) {
            if (fontMetrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "doCalcWidth"));
            }
            return text2 == null ? 0 : fontMetrics.stringWidth(text2) + 14;
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g2, @NotNull Rectangle r2) {
            TextAttributes attributes;
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "paint"));
            }
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "paint"));
            }
            if (r2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "paint"));
            }
            if (this.myText != null && (this.step > this.steps || this.startWidth != 0) && (attributes = editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT)) != null) {
                Color foregroundColor;
                MyFontMetrics fontMetrics = ParameterHintsPresentationManager.getFontMetrics(editor);
                Color backgroundColor = attributes.getBackgroundColor();
                if (backgroundColor != null) {
                    GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
                    GraphicsUtil.paintWithAlpha((Graphics)g2, (float)0.55f);
                    g2.setColor(backgroundColor);
                    int gap = r2.height < fontMetrics.lineHeight + 2 ? 1 : 2;
                    g2.fillRoundRect(r2.x + 2, r2.y + gap, r2.width - 4, r2.height - gap * 2, 8, 8);
                    config.restore();
                }
                if ((foregroundColor = attributes.getForegroundColor()) != null) {
                    g2.setColor(foregroundColor);
                    g2.setFont(ParameterHintsPresentationManager.getFont(editor));
                    Shape savedClip = g2.getClip();
                    g2.clipRect(r2.x + 3, r2.y + 2, r2.width - 6, r2.height - 4);
                    int editorAscent = editor instanceof EditorImpl ? ((EditorImpl)editor).getAscent() : 0;
                    FontMetrics metrics = fontMetrics.metrics;
                    g2.drawString(this.myText, r2.x + 7, r2.y + Math.max(editorAscent, (r2.height + metrics.getAscent() - metrics.getDescent()) / 2) - 1);
                    g2.setClip(savedClip);
                }
            }
        }
    }

    private static class MyFontMetrics {
        private final FontMetrics metrics;
        private final int lineHeight;

        private MyFontMetrics(Editor editor, Font font) {
            this.metrics = editor.getContentComponent().getFontMetrics(font);
            this.lineHeight = (int)Math.ceil(font.createGlyphVector(this.metrics.getFontRenderContext(), "Ap").getVisualBounds().getHeight());
        }

        private Font getFont() {
            return this.metrics.getFont();
        }
    }
}

