/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

abstract class ThreadLocalAnnotatorMap<K, V> {
    private volatile int version;
    private final ThreadLocal<VersionedMap<K, V>> CACHE = new ThreadLocal<VersionedMap<K, V>>(){

        @Override
        protected VersionedMap<K, V> initialValue() {
            return new VersionedMap(ThreadLocalAnnotatorMap.this.version);
        }
    };

    ThreadLocalAnnotatorMap() {
    }

    @NotNull
    public abstract Collection<V> initialValue(@NotNull K var1);

    @NotNull
    private List<V> cloneTemplates(@NotNull Collection<V> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "cloneTemplates"));
        }
        ArrayList<Object> result2 = new ArrayList<Object>(templates.size());
        PicoContainer container = ApplicationManager.getApplication().getPicoContainer();
        for (V template : templates) {
            Class<?> aClass = template.getClass();
            Object clone = new CachingConstructorInjectionComponentAdapter((Object)aClass.getName(), aClass).getComponentInstance(container);
            result2.add(clone);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "cloneTemplates"));
        }
        return arrayList;
    }

    @NotNull
    public List<V> get(@NotNull K key) {
        List<V> cached;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "get"));
        }
        VersionedMap<K, V> map2 = this.CACHE.get();
        if (this.version != ((VersionedMap)map2).version) {
            this.CACHE.remove();
            map2 = this.CACHE.get();
        }
        if ((cached = (List<V>)map2.get(key)) == null) {
            Collection<V> templates = this.initialValue(key);
            cached = this.cloneTemplates(templates);
            map2.put(key, cached);
        }
        List<V> list2 = cached;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ThreadLocalAnnotatorMap", "get"));
        }
        return list2;
    }

    public void clear() {
        ++this.version;
    }

    private static class VersionedMap<K, V>
    extends THashMap<K, List<V>> {
        private final int version;

        private VersionedMap(int version) {
            this.version = version;
        }
    }
}

