/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficProgressPanel;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.update.ComparableObject;
import java.awt.Point;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;

class TrafficTooltipRendererImpl
extends ComparableObject.Impl
implements TrafficTooltipRenderer {
    private TrafficProgressPanel myPanel;
    private final Runnable onHide;
    private TrafficLightRenderer myTrafficLightRenderer;

    TrafficTooltipRendererImpl(@NotNull Runnable onHide, @NotNull Editor editor) {
        if (onHide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onHide", "com/intellij/codeInsight/daemon/impl/TrafficTooltipRendererImpl", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/TrafficTooltipRendererImpl", "<init>"));
        }
        super(new Object[]{editor});
        this.onHide = onHide;
    }

    @Override
    public void repaintTooltipWindow() {
        if (this.myPanel != null) {
            SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(this.myTrafficLightRenderer.getProject());
            TrafficLightRenderer.DaemonCodeAnalyzerStatus status = this.myTrafficLightRenderer.getDaemonCodeAnalyzerStatus(severityRegistrar);
            this.myPanel.updatePanel(status, false);
        }
    }

    @Override
    public LightweightHint show(@NotNull Editor editor, @NotNull Point p2, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/TrafficTooltipRendererImpl", "show"));
        }
        if (p2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/codeInsight/daemon/impl/TrafficTooltipRendererImpl", "show"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/codeInsight/daemon/impl/TrafficTooltipRendererImpl", "show"));
        }
        if (hintHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintHint", "com/intellij/codeInsight/daemon/impl/TrafficTooltipRendererImpl", "show"));
        }
        this.myTrafficLightRenderer = (TrafficLightRenderer)((EditorMarkupModelImpl)editor.getMarkupModel()).getErrorStripeRenderer();
        this.myPanel = new TrafficProgressPanel(this.myTrafficLightRenderer, editor, hintHint);
        this.repaintTooltipWindow();
        LineTooltipRenderer.correctLocation(editor, this.myPanel, p2, alignToRight, true, this.myPanel.getMinWidth());
        LightweightHint hint = new LightweightHint(this.myPanel);
        HintManagerImpl hintManager = (HintManagerImpl)HintManager.getInstance();
        hintManager.showEditorHint(hint, editor, p2, 58, 0, false, hintHint);
        hint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                if (TrafficTooltipRendererImpl.this.myPanel == null) {
                    return;
                }
                TrafficTooltipRendererImpl.this.myPanel = null;
                TrafficTooltipRendererImpl.this.onHide.run();
            }
        });
        return hint;
    }
}

