/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHighlightInfoHolder
extends HighlightInfoHolder {
    private final EditorColorsScheme myCustomColorsScheme;

    public CustomHighlightInfoHolder(@NotNull PsiFile contextFile, HighlightInfoFilter ... filters2) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "<init>"));
        }
        if (filters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "<init>"));
        }
        this(contextFile, (EditorColorsScheme)null, filters2);
    }

    public CustomHighlightInfoHolder(@NotNull PsiFile contextFile, @Nullable EditorColorsScheme customColorsScheme, HighlightInfoFilter ... filters2) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "<init>"));
        }
        if (filters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "<init>"));
        }
        super(contextFile, filters2);
        this.myCustomColorsScheme = customColorsScheme;
    }

    @Override
    @NotNull
    public TextAttributesScheme getColorsScheme() {
        if (this.myCustomColorsScheme != null) {
            EditorColorsScheme editorColorsScheme = this.myCustomColorsScheme;
            if (editorColorsScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "getColorsScheme"));
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/CustomHighlightInfoHolder", "getColorsScheme"));
        }
        return editorColorsScheme;
    }
}

