/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReference;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlEncodingReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.encoding.XmlEncodingReferenceProvider");
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider", "getReferencesByElement"));
        }
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider", "getReferencesByElement"));
        }
        LOG.assertTrue(element instanceof XmlAttributeValue);
        XmlAttributeValue value2 = (XmlAttributeValue)element;
        PsiReference[] psiReferenceArray = new PsiReference[]{new XmlEncodingReference(value2, value2.getValue(), XmlEncodingReferenceProvider.xmlAttributeValueRange(value2), 0)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/encoding/XmlEncodingReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    protected static TextRange xmlAttributeValueRange(XmlAttributeValue xmlAttributeValue) {
        ASTNode valueNode = XmlChildRole.ATTRIBUTE_VALUE_VALUE_FINDER.findChild(xmlAttributeValue.getNode());
        XmlAttributeValue toHighlight = valueNode == null ? xmlAttributeValue : valueNode.getPsi();
        TextRange childRange = toHighlight.getTextRange();
        TextRange range = xmlAttributeValue.getTextRange();
        return childRange.shiftRight(-range.getStartOffset());
    }

    public static PsiReference[] extractFromContentAttribute(XmlAttributeValue value2) {
        String text2 = value2.getValue();
        int start2 = text2.indexOf(CHARSET_PREFIX);
        if (start2 != -1) {
            int end = text2.indexOf(59, start2 += CHARSET_PREFIX.length());
            if (end == -1) {
                end = text2.length();
            }
            String charsetName = text2.substring(start2, end);
            TextRange textRange = new TextRange(start2, end).shiftRight(XmlEncodingReferenceProvider.xmlAttributeValueRange(value2).getStartOffset());
            return new PsiReference[]{new XmlEncodingReference(value2, charsetName, textRange, 0)};
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

