/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.RenameFileReferenceIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceQuickFixProvider {
    private FileReferenceQuickFixProvider() {
    }

    @NotNull
    public static List<? extends LocalQuickFix> registerQuickFix(@NotNull FileReference reference) {
        boolean isdirectory;
        PsiFile containingFile;
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
        }
        FileReferenceSet fileReferenceSet = reference.getFileReferenceSet();
        int index = reference.getIndex();
        if (index < 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list2;
        }
        String newFileName = reference.getFileNameToCreate();
        if (newFileName.isEmpty() || newFileName.indexOf(92) != -1 || newFileName.indexOf(42) != -1 || newFileName.indexOf(63) != -1 || SystemInfo.isWindows && newFileName.indexOf(58) != -1) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list3;
        }
        PsiFileSystemItem context2 = null;
        PsiElement element = reference.getElement();
        PsiFile psiFile = containingFile = element == null ? null : element.getContainingFile();
        if (index > 0) {
            context2 = fileReferenceSet.getReference(index - 1).resolve();
        } else {
            Collection<PsiFileSystemItem> defaultContexts = fileReferenceSet.getDefaultContexts();
            if (defaultContexts.isEmpty()) {
                List list4 = Collections.emptyList();
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list4;
            }
            Module module2 = containingFile == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
            for (PsiFileSystemItem defaultContext : defaultContexts) {
                VirtualFile virtualFile;
                if (defaultContext == null || (virtualFile = defaultContext.getVirtualFile()) == null || !defaultContext.isDirectory() || !virtualFile.isInLocalFileSystem()) continue;
                if (context2 == null) {
                    context2 = defaultContext;
                }
                if (module2 == null || module2 != FileReferenceQuickFixProvider.getModuleForContext(defaultContext)) continue;
                context2 = defaultContext;
                break;
            }
            if (context2 == null && ApplicationManager.getApplication().isUnitTestMode()) {
                context2 = defaultContexts.iterator().next();
            }
        }
        if (context2 == null) {
            List list5 = Collections.emptyList();
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list5;
        }
        VirtualFile virtualFile = context2.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            List list6 = Collections.emptyList();
            if (list6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list6;
        }
        PsiDirectory directory = context2.getManager().findDirectory(virtualFile);
        if (directory == null) {
            List list7 = Collections.emptyList();
            if (list7 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
            }
            return list7;
        }
        if (fileReferenceSet.isCaseSensitive()) {
            PsiFileSystemItem psiElement;
            PsiFileSystemItem psiFileSystemItem = psiElement = containingFile == null ? null : reference.innerSingleResolve(false, containingFile);
            if (psiElement != null) {
                String existingElementName = ((PsiNamedElement)psiElement).getName();
                RenameFileReferenceIntentionAction renameRefAction = new RenameFileReferenceIntentionAction(existingElementName, reference);
                RenameFileFix renameFileFix = new RenameFileFix(newFileName);
                List<LocalQuickFix> list8 = Arrays.asList(renameRefAction, renameFileFix);
                if (list8 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list8;
            }
        }
        if (!reference.isLast()) {
            try {
                directory.checkCreateSubdirectory(newFileName);
            }
            catch (IncorrectOperationException ex) {
                List list9 = Collections.emptyList();
                if (list9 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list9;
            }
            isdirectory = true;
        } else {
            FileType ft = FileTypeManager.getInstance().getFileTypeByFileName(newFileName);
            if (ft instanceof UnknownFileType) {
                List list10 = Collections.emptyList();
                if (list10 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list10;
            }
            try {
                directory.checkCreateFile(newFileName);
            }
            catch (IncorrectOperationException ex) {
                List list11 = Collections.emptyList();
                if (list11 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
                }
                return list11;
            }
            isdirectory = false;
        }
        MyCreateFileFix action2 = new MyCreateFileFix(isdirectory, newFileName, directory, reference);
        List<MyCreateFileFix> list12 = Collections.singletonList(action2);
        if (list12 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "registerQuickFix"));
        }
        return list12;
    }

    @Nullable
    private static Module getModuleForContext(@NotNull PsiFileSystemItem context2) {
        if (context2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider", "getModuleForContext"));
        }
        VirtualFile file2 = context2.getVirtualFile();
        return file2 != null ? ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)context2.getProject()) : null;
    }

    private static class MyCreateFileFix
    extends CreateFileFix {
        private final boolean isDirectory;
        private final String myNewFileTemplateName;

        public MyCreateFileFix(boolean isdirectory, String newFileName, PsiDirectory directory, FileReference reference) {
            super(isdirectory, newFileName, directory);
            this.isDirectory = isdirectory;
            this.myNewFileTemplateName = this.isDirectory ? null : reference.getNewFileTemplateName();
        }

        @Override
        protected String getFileText() {
            Project project2;
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            if (!this.isDirectory && this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project2 = this.getStartElement().getProject()))) != null) {
                try {
                    return template.getText(fileTemplateManager.getDefaultProperties());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return super.getFileText();
        }

        private FileTemplate findTemplate(FileTemplateManager fileTemplateManager) {
            FileTemplate template = fileTemplateManager.getTemplate(this.myNewFileTemplateName);
            if (template == null) {
                template = fileTemplateManager.findInternalTemplate(this.myNewFileTemplateName);
            }
            return template;
        }

        @Override
        protected void openFile(@NotNull Project project2, PsiDirectory directory, PsiFile newFile, String text2) {
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider$MyCreateFileFix", "openFile"));
            }
            super.openFile(project2, directory, newFile, text2);
            if (!this.isDirectory && this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project2))) != null && template.isLiveTemplateEnabled()) {
                CreateFromTemplateActionBase.startLiveTemplate(newFile);
            }
        }
    }
}

