/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class RenameFileReferenceIntentionAction
implements IntentionAction,
LocalQuickFix {
    private final String myExistingElementName;
    private final FileReference myFileReference;

    public RenameFileReferenceIntentionAction(String existingElementName, FileReference fileReference) {
        this.myExistingElementName = existingElementName;
        this.myFileReference = fileReference;
    }

    @NotNull
    public String getText() {
        String string2 = CodeInsightBundle.message((String)"rename.file.reference.text", (Object[])new Object[]{this.myExistingElementName});
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction", "getText"));
        }
        return string2;
    }

    @NotNull
    public String getName() {
        String string2 = this.getText();
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction", "getName"));
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message((String)"rename.file.reference.family", (Object[])new Object[0]);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction", "getFamilyName"));
        }
        return string2;
    }

    public void applyFix(final @NotNull Project project2, final @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction", "applyFix"));
        }
        if (this.isAvailable(project2, null, null)) {
            new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction$1", "run"));
                    }
                    RenameFileReferenceIntentionAction.this.invoke(project2, null, descriptor2.getPsiElement().getContainingFile());
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/quickFix/RenameFileReferenceIntentionAction", "invoke"));
        }
        this.myFileReference.handleElementRename(this.myExistingElementName);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

