/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.ElementLocationUtil;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.actions.ExternalJavaDocAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;

public class DocumentationComponent
extends JPanel
implements Disposable,
DataProvider {
    private static final Logger LOG = Logger.getInstance(DocumentationComponent.class);
    private static final Color DOCUMENTATION_COLOR = new JBColor(new Color(0xF6F6F6), new Color(5066577));
    public static final ColorKey COLOR_KEY = ColorKey.createColorKey((String)"DOCUMENTATION_COLOR", (Color)DOCUMENTATION_COLOR);
    private static final Highlighter.HighlightPainter LINK_HIGHLIGHTER = new LinkHighlighter();
    @NonNls
    private static final String DOCUMENTATION_TOPIC_ID = "reference.toolWindows.Documentation";
    private static final int PREFERRED_WIDTH_EM = 37;
    private static final int PREFERRED_HEIGHT_MIN_EM = 7;
    private static final int PREFERRED_HEIGHT_MAX_EM = 20;
    private DocumentationManager myManager;
    private SmartPsiElementPointer myElement;
    private long myModificationCount;
    private static final String QUICK_DOC_FONT_SIZE_PROPERTY = "quick.doc.font.size";
    private final Stack<Context> myBackStack = new Stack();
    private final Stack<Context> myForwardStack = new Stack();
    private final ActionToolbar myToolBar;
    private volatile boolean myIsEmpty;
    private boolean myIsShown;
    private final JLabel myElementLabel;
    private final MutableAttributeSet myFontSizeStyle = new SimpleAttributeSet();
    private JSlider myFontSizeSlider;
    private final JComponent mySettingsPanel;
    private final MyShowSettingsButton myShowSettingsButton;
    private boolean myIgnoreFontSizeSliderChange;
    private String myEffectiveExternalUrl;
    private final MyDictionary<String, Image> myImageProvider = new MyDictionary<String, Image>(){

        @Override
        public Image get(Object key) {
            if (DocumentationComponent.this.myManager == null || key == null) {
                return null;
            }
            PsiElement element = DocumentationComponent.this.getElement();
            if (element == null) {
                return null;
            }
            URL url = (URL)key;
            Image inMemory = DocumentationComponent.this.myManager.getElementImage(element, url.toExternalForm());
            if (inMemory != null) {
                return inMemory;
            }
            Url parsedUrl = Urls.parseEncoded(url.toExternalForm());
            BuiltInServerManager builtInServerManager = BuiltInServerManager.getInstance();
            if (parsedUrl != null && builtInServerManager.isOnBuiltInWebServer(parsedUrl)) {
                try {
                    url = new URL(builtInServerManager.addAuthToken(parsedUrl).toExternalForm());
                }
                catch (MalformedURLException e2) {
                    LOG.warn((Throwable)e2);
                }
            }
            return Toolkit.getDefaultToolkit().createImage(url);
        }
    };
    private final JScrollPane myScrollPane;
    private final JEditorPane myEditorPane;
    private String myText;
    private final JPanel myControlPanel;
    private boolean myControlPanelVisible;
    private final ExternalDocAction myExternalDocAction;
    private Consumer<PsiElement> myNavigateCallback;
    private int myHighlightedLink = -1;
    private Object myHighlightingTag;
    private JBPopup myHint;
    private final Map<KeyStroke, ActionListener> myKeyboardActions = new HashMap();

    @Override
    public boolean requestFocusInWindow() {
        if (ScreenReader.isActive()) {
            return this.myEditorPane.requestFocusInWindow();
        }
        return this.myScrollPane.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        if (ScreenReader.isActive()) {
            this.myEditorPane.requestFocus();
        } else {
            this.myScrollPane.requestFocus();
        }
    }

    public DocumentationComponent(final DocumentationManager manager, AnAction[] additionalActions) {
        this.myManager = manager;
        this.myIsEmpty = true;
        this.myIsShown = false;
        this.myEditorPane = new JEditorPane("text/html", ""){
            {
                this.enableEvents(8L);
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                int em = DocumentationComponent.this.myEditorPane.getFont().getSize();
                int prefWidth = 37 * em;
                int prefHeightMin = 7 * em;
                int prefHeightMax = 20 * em;
                if (this.getWidth() == 0 || this.getHeight() == 0) {
                    this.setSize(prefWidth, prefHeightMax);
                }
                Insets ins = DocumentationComponent.this.myEditorPane.getInsets();
                View rootView = DocumentationComponent.this.myEditorPane.getUI().getRootView(DocumentationComponent.this.myEditorPane);
                rootView.setSize(prefWidth, prefHeightMax);
                int prefHeight = (int)rootView.getPreferredSpan(1) + ins.bottom + ins.top + ((DocumentationComponent)DocumentationComponent.this).myScrollPane.getHorizontalScrollBar().getMaximumSize().height;
                prefHeight = Math.max(prefHeightMin, Math.min(prefHeightMax, prefHeight));
                return new Dimension(prefWidth, prefHeight);
            }

            @Override
            protected void processKeyEvent(KeyEvent e2) {
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e2);
                ActionListener listener2 = (ActionListener)DocumentationComponent.this.myKeyboardActions.get(keyStroke);
                if (listener2 != null) {
                    listener2.actionPerformed(new ActionEvent(DocumentationComponent.this, 0, ""));
                    e2.consume();
                    return;
                }
                super.processKeyEvent(e2);
            }

            @Override
            protected void paintComponent(Graphics g2) {
                GraphicsUtil.setupAntialiasing((Graphics)g2);
                super.paintComponent(g2);
            }

            @Override
            public void setDocument(Document doc) {
                super.setDocument(doc);
                if (doc instanceof StyledDocument) {
                    doc.putProperty("imageCache", DocumentationComponent.this.myImageProvider);
                }
            }
        };
        DataProvider helpDataProvider = new DataProvider(){

            public Object getData(@NonNls String dataId) {
                return PlatformDataKeys.HELP_ID.is(dataId) ? DocumentationComponent.DOCUMENTATION_TOPIC_ID : null;
            }
        };
        this.myEditorPane.putClientProperty("DataProvider", helpDataProvider);
        this.myText = "";
        this.myEditorPane.setEditable(false);
        if (ScreenReader.isActive()) {
            this.myEditorPane.getCaret().setVisible(true);
        }
        this.myEditorPane.setBackground(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)COLOR_KEY));
        this.myEditorPane.setEditorKit(UIUtil.getHTMLEditorKit((boolean)false));
        this.myScrollPane = new JBScrollPane(this.myEditorPane){

            protected void processMouseWheelEvent(MouseWheelEvent e2) {
                if (!EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() || !EditorUtil.isChangeFontSize(e2)) {
                    super.processMouseWheelEvent(e2);
                    return;
                }
                int rotation = e2.getWheelRotation();
                if (rotation == 0) {
                    return;
                }
                boolean increase = rotation <= 0;
                FontSize newFontSize = DocumentationComponent.getQuickDocFontSize();
                for (int change = Math.abs(rotation); change > 0; --change) {
                    newFontSize = increase ? newFontSize.larger() : newFontSize.smaller();
                }
                if (newFontSize == DocumentationComponent.getQuickDocFontSize()) {
                    return;
                }
                DocumentationComponent.this.setQuickDocFontSize(newFontSize);
                DocumentationComponent.this.applyFontSize();
                DocumentationComponent.this.setFontSizeSliderSize(newFontSize);
            }
        };
        this.myScrollPane.setBorder(null);
        this.myScrollPane.putClientProperty("DataProvider", helpDataProvider);
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                DocumentationComponent.this.myManager.requestFocus();
                DocumentationComponent.this.myShowSettingsButton.hideSettings();
            }
        };
        this.myEditorPane.addMouseListener(mouseAdapter);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeMouseListener(mouseAdapter);
            }
        });
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e2) {
                Component previouslyFocused = WindowManagerEx.getInstanceEx().getFocusedComponent(manager.getProject(DocumentationComponent.this.getElement()));
                if (previouslyFocused != DocumentationComponent.this.myEditorPane && DocumentationComponent.this.myHint != null && !DocumentationComponent.this.myHint.isDisposed()) {
                    DocumentationComponent.this.myHint.cancel();
                }
            }
        };
        this.myEditorPane.addFocusListener(focusAdapter);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeFocusListener(focusAdapter);
            }
        });
        this.setLayout(new BorderLayout());
        JBLayeredPane layeredPane = new JBLayeredPane(){

            public void doLayout() {
                Rectangle r2 = this.getBounds();
                for (Component component : this.getComponents()) {
                    if (component instanceof JScrollPane) {
                        component.setBounds(0, 0, r2.width, r2.height);
                        continue;
                    }
                    int insets = 2;
                    Dimension d2 = component.getPreferredSize();
                    component.setBounds(r2.width - d2.width - insets, insets, d2.width, d2.height);
                }
            }

            public Dimension getPreferredSize() {
                Dimension editorPaneSize = DocumentationComponent.this.myEditorPane.getPreferredScrollableViewportSize();
                Dimension controlPanelSize = DocumentationComponent.this.myControlPanel.getPreferredSize();
                return this.getSize(editorPaneSize, controlPanelSize);
            }

            public Dimension getMinimumSize() {
                JBDimension editorPaneSize = new JBDimension(20, 20);
                Dimension controlPanelSize = DocumentationComponent.this.myControlPanel.getMinimumSize();
                return this.getSize((Dimension)editorPaneSize, controlPanelSize);
            }

            private Dimension getSize(Dimension editorPaneSize, Dimension controlPanelSize) {
                return new Dimension(Math.max(editorPaneSize.width, controlPanelSize.width), editorPaneSize.height + controlPanelSize.height);
            }
        };
        layeredPane.add(this.myScrollPane);
        layeredPane.setLayer(this.myScrollPane, 0);
        this.mySettingsPanel = this.createSettingsPanel();
        layeredPane.add(this.mySettingsPanel);
        layeredPane.setLayer(this.mySettingsPanel, JLayeredPane.POPUP_LAYER);
        this.add((Component)layeredPane, "Center");
        this.setOpaque(true);
        this.myScrollPane.setViewportBorder((Border)JBScrollPane.createIndentBorder());
        DefaultActionGroup actions2 = new DefaultActionGroup();
        BackAction back = new BackAction();
        ForwardAction forward = new ForwardAction();
        EditDocumentationSourceAction edit = new EditDocumentationSourceAction();
        actions2.add((AnAction)back);
        actions2.add((AnAction)forward);
        this.myExternalDocAction = new ExternalDocAction();
        actions2.add((AnAction)this.myExternalDocAction);
        actions2.add((AnAction)edit);
        try {
            String backKey = ScreenReader.isActive() ? "alt LEFT" : "LEFT";
            CustomShortcutSet backShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)backKey), KeymapUtil.parseMouseShortcut((String)"button4")});
            String forwardKey = ScreenReader.isActive() ? "alt RIGHT" : "RIGHT";
            CustomShortcutSet forwardShortcutSet = new CustomShortcutSet(new Shortcut[]{KeyboardShortcut.fromString((String)forwardKey), KeymapUtil.parseMouseShortcut((String)"button5")});
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this);
            back.registerCustomShortcutSet((ShortcutSet)backShortcutSet, this.myEditorPane);
            forward.registerCustomShortcutSet((ShortcutSet)forwardShortcutSet, this.myEditorPane);
        }
        catch (InvalidDataException e2) {
            LOG.error((Throwable)e2);
        }
        this.myExternalDocAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"UP"}), this);
        edit.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this);
        if (additionalActions != null) {
            for (AnAction action2 : additionalActions) {
                actions2.add(action2);
                ShortcutSet shortcutSet = action2.getShortcutSet();
                if (shortcutSet == null) continue;
                action2.registerCustomShortcutSet(shortcutSet, (JComponent)this);
            }
        }
        new NextLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"TAB"}), this);
        new PreviousLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), this);
        new ActivateLinkAction().registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ENTER"}), this);
        this.myToolBar = ActionManager.getInstance().createActionToolbar("JavadocToolbar", (ActionGroup)actions2, true);
        this.myControlPanel = new JPanel(new BorderLayout(5, 5));
        this.myControlPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myElementLabel = new JLabel();
        this.myElementLabel.setMinimumSize(new Dimension(100, 0));
        this.myControlPanel.add((Component)this.myToolBar.getComponent(), "West");
        this.myControlPanel.add((Component)this.myElementLabel, "Center");
        this.myShowSettingsButton = new MyShowSettingsButton();
        this.myControlPanel.add((Component)this.myShowSettingsButton, "East");
        this.myControlPanelVisible = false;
        final HyperlinkListener hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e2) {
                HyperlinkEvent.EventType type = e2.getEventType();
                if (type == HyperlinkEvent.EventType.ACTIVATED) {
                    manager.navigateByLink(DocumentationComponent.this, e2.getDescription());
                }
            }
        };
        this.myEditorPane.addHyperlinkListener(hyperlinkListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DocumentationComponent.this.myEditorPane.removeHyperlinkListener(hyperlinkListener);
            }
        });
        this.registerActions();
        this.updateControlState();
    }

    public DocumentationComponent(DocumentationManager manager) {
        this(manager, null);
    }

    public Object getData(@NonNls String dataId) {
        if (DocumentationManager.SELECTED_QUICK_DOC_TEXT.getName().equals(dataId)) {
            String selectedText = this.myEditorPane.getSelectedText();
            return selectedText == null ? null : selectedText.replace('\u00a0', ' ');
        }
        return null;
    }

    private JComponent createSettingsPanel() {
        JPanel result2 = new JPanel(new FlowLayout(2, 3, 0));
        result2.add(new JLabel(ApplicationBundle.message((String)"label.font.size", (Object[])new Object[0])));
        this.myFontSizeSlider = new JSlider(0, 0, FontSize.values().length - 1, 3);
        this.myFontSizeSlider.setMinorTickSpacing(1);
        this.myFontSizeSlider.setPaintTicks(true);
        this.myFontSizeSlider.setPaintTrack(true);
        this.myFontSizeSlider.setSnapToTicks(true);
        UIUtil.setSliderIsFilled((JSlider)this.myFontSizeSlider, (boolean)true);
        result2.add(this.myFontSizeSlider);
        result2.setBorder(BorderFactory.createLineBorder(JBColor.border(), 1));
        this.myFontSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                if (DocumentationComponent.this.myIgnoreFontSizeSliderChange) {
                    return;
                }
                DocumentationComponent.this.setQuickDocFontSize(FontSize.values()[DocumentationComponent.this.myFontSizeSlider.getValue()]);
                DocumentationComponent.this.applyFontSize();
            }
        });
        String tooltipText = ApplicationBundle.message((String)"quickdoc.tooltip.font.size.by.wheel", (Object[])new Object[0]);
        result2.setToolTipText(tooltipText);
        this.myFontSizeSlider.setToolTipText(tooltipText);
        result2.setVisible(false);
        result2.setOpaque(true);
        this.myFontSizeSlider.setOpaque(true);
        return result2;
    }

    @NotNull
    public static FontSize getQuickDocFontSize() {
        String strValue = PropertiesComponent.getInstance().getValue(QUICK_DOC_FONT_SIZE_PROPERTY);
        if (strValue != null) {
            FontSize fontSize;
            try {
                fontSize = FontSize.valueOf((String)strValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (fontSize == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationComponent", "getQuickDocFontSize"));
            }
            return fontSize;
        }
        FontSize fontSize = FontSize.SMALL;
        if (fontSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/DocumentationComponent", "getQuickDocFontSize"));
        }
        return fontSize;
    }

    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "com/intellij/codeInsight/documentation/DocumentationComponent", "setQuickDocFontSize"));
        }
        PropertiesComponent.getInstance().setValue(QUICK_DOC_FONT_SIZE_PROPERTY, fontSize.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFontSizeSliderSize(FontSize fontSize) {
        this.myIgnoreFontSizeSliderChange = true;
        try {
            FontSize[] sizes = FontSize.values();
            for (int i2 = 0; i2 < sizes.length; ++i2) {
                if (fontSize != sizes[i2]) continue;
                this.myFontSizeSlider.setValue(i2);
                break;
            }
        }
        finally {
            this.myIgnoreFontSizeSliderChange = false;
        }
    }

    public boolean isEmpty() {
        return this.myIsEmpty;
    }

    public void startWait() {
        this.myIsEmpty = true;
    }

    private void setControlPanelVisible(boolean visible) {
        if (visible == this.myControlPanelVisible) {
            return;
        }
        if (visible) {
            this.add((Component)this.myControlPanel, "North");
        } else {
            this.remove(this.myControlPanel);
        }
        this.myControlPanelVisible = visible;
    }

    public void setHint(JBPopup hint) {
        this.myHint = hint;
    }

    public JBPopup getHint() {
        return this.myHint;
    }

    public JComponent getComponent() {
        return this.myEditorPane;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement != null ? this.myElement.getElement() : null;
    }

    private void setElement(SmartPsiElementPointer element) {
        this.myElement = element;
        this.myModificationCount = this.getCurrentModificationCount();
    }

    public boolean isUpToDate() {
        return this.getElement() != null && this.myModificationCount == this.getCurrentModificationCount();
    }

    private long getCurrentModificationCount() {
        return this.myElement != null ? PsiModificationTracker.SERVICE.getInstance((Project)this.myElement.getProject()).getModificationCount() : -1L;
    }

    public void setNavigateCallback(Consumer<PsiElement> navigateCallback) {
        this.myNavigateCallback = navigateCallback;
    }

    public void setText(String text2, @Nullable PsiElement element, boolean clearHistory) {
        this.setText(text2, element, false, clearHistory);
    }

    public void setText(String text2, PsiElement element, boolean clean, boolean clearHistory) {
        if (clean && this.myElement != null) {
            this.myBackStack.push(this.saveContext());
            this.myForwardStack.clear();
        }
        this.updateControlState();
        this.setData(element, text2, clearHistory, null);
        if (clean) {
            this.myIsEmpty = false;
        }
        if (clearHistory) {
            this.clearHistory();
        }
    }

    public void replaceText(String text2, PsiElement element) {
        PsiElement current = this.getElement();
        if (current == null || !current.getManager().areElementsEquivalent(current, element)) {
            return;
        }
        this.setText(text2, element, false);
        if (!this.myBackStack.empty()) {
            this.myBackStack.pop();
        }
    }

    private void clearHistory() {
        this.myForwardStack.clear();
        this.myBackStack.clear();
    }

    public void setData(PsiElement _element2, String text2, boolean clearHistory, String effectiveExternalUrl) {
        this.setData(_element2, text2, clearHistory, effectiveExternalUrl, null);
    }

    public void setData(PsiElement _element2, String text2, boolean clearHistory, String effectiveExternalUrl, String ref) {
        SmartPsiElementPointer element;
        if (this.myElement != null) {
            this.myBackStack.push(this.saveContext());
            this.myForwardStack.clear();
        }
        this.myEffectiveExternalUrl = effectiveExternalUrl;
        SmartPsiElementPointer smartPsiElementPointer = element = _element2 != null && _element2.isValid() ? SmartPointerManager.getInstance((Project)_element2.getProject()).createSmartPsiElementPointer(_element2) : null;
        if (element != null) {
            this.setElement(element);
        }
        this.myIsEmpty = false;
        this.updateControlState();
        this.setDataInternal(element, text2, new Rectangle(0, 0), ref);
        if (clearHistory) {
            this.clearHistory();
        }
    }

    private void setDataInternal(SmartPsiElementPointer element, String text2, Rectangle viewRect, String ref) {
        this.setElement(element);
        this.highlightLink(-1);
        this.myEditorPane.setText(text2);
        this.applyFontSize();
        if (!this.myIsShown && this.myHint != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myManager.showHint(this.myHint);
            this.myIsShown = true;
        }
        this.myText = text2;
        SwingUtilities.invokeLater(() -> {
            this.myEditorPane.scrollRectToVisible(viewRect);
            if (ref != null) {
                this.myEditorPane.scrollToReference(ref);
            } else if (ScreenReader.isActive()) {
                this.myEditorPane.setCaretPosition(0);
            }
        });
    }

    private void applyFontSize() {
        Document document = this.myEditorPane.getDocument();
        if (!(document instanceof StyledDocument)) {
            return;
        }
        StyledDocument styledDocument = (StyledDocument)document;
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme scheme2 = colorsManager.getGlobalScheme();
        StyleConstants.setFontSize(this.myFontSizeStyle, JBUI.scale((int)DocumentationComponent.getQuickDocFontSize().getSize()));
        if (Registry.is((String)"documentation.component.editor.font")) {
            StyleConstants.setFontFamily(this.myFontSizeStyle, scheme2.getEditorFontName());
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.myFontSizeStyle, false));
    }

    private void goBack() {
        if (this.myBackStack.isEmpty()) {
            return;
        }
        Context context2 = this.myBackStack.pop();
        this.myForwardStack.push(this.saveContext());
        this.restoreContext(context2);
        this.updateControlState();
    }

    private void goForward() {
        if (this.myForwardStack.isEmpty()) {
            return;
        }
        Context context2 = this.myForwardStack.pop();
        this.myBackStack.push(this.saveContext());
        this.restoreContext(context2);
        this.updateControlState();
    }

    private Context saveContext() {
        Rectangle rect = this.myScrollPane.getViewport().getViewRect();
        return new Context(this.myElement, this.myText, this.myEffectiveExternalUrl, rect, this.myHighlightedLink);
    }

    private void restoreContext(Context context2) {
        PsiElement element;
        this.setDataInternal(context2.element, context2.text, context2.viewRect, null);
        this.myEffectiveExternalUrl = context2.externalUrl;
        if (this.myNavigateCallback != null && (element = context2.element.getElement()) != null) {
            this.myNavigateCallback.consume((Object)element);
        }
        this.highlightLink(context2.highlightedLink);
    }

    private void updateControlState() {
        ElementLocationUtil.customizeElementLabel(this.myElement != null ? this.myElement.getElement() : null, this.myElementLabel);
        this.myToolBar.updateActionsImmediately();
        this.setControlPanelVisible(true);
    }

    private void registerActions() {
        this.myExternalDocAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), this.myEditorPane);
        if (!ScreenReader.isActive()) {
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(38, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value2 = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                    value2 = Math.max(value2, 0);
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(40, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value2 = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                    value2 = Math.min(value2, scrollBar.getMaximum());
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(37, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    int value2 = scrollBar.getValue() - scrollBar.getUnitIncrement(-1);
                    value2 = Math.max(value2, 0);
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(39, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    int value2 = scrollBar.getValue() + scrollBar.getUnitIncrement(1);
                    value2 = Math.min(value2, scrollBar.getMaximum());
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(33, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value2 = scrollBar.getValue() - scrollBar.getBlockIncrement(-1);
                    value2 = Math.max(value2, 0);
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(34, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    int value2 = scrollBar.getValue() + scrollBar.getBlockIncrement(1);
                    value2 = Math.min(value2, scrollBar.getMaximum());
                    scrollBar.setValue(value2);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(36, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(0);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(35, 0), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getHorizontalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(36, 2), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(0);
                }
            });
            this.myKeyboardActions.put(KeyStroke.getKeyStroke(35, 2), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    JScrollBar scrollBar = DocumentationComponent.this.myScrollPane.getVerticalScrollBar();
                    scrollBar.setValue(scrollBar.getMaximum());
                }
            });
        }
    }

    public String getText() {
        return this.myText;
    }

    public void dispose() {
        this.myBackStack.clear();
        this.myForwardStack.clear();
        this.myKeyboardActions.clear();
        this.myElement = null;
        this.myManager = null;
        this.myHint = null;
        this.myNavigateCallback = null;
    }

    private int getLinkCount() {
        HTMLDocument document = (HTMLDocument)this.myEditorPane.getDocument();
        int linkCount = 0;
        HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
        while (it.isValid()) {
            if (it.getAttributes().isDefined(HTML.Attribute.HREF)) {
                ++linkCount;
            }
            it.next();
        }
        return linkCount;
    }

    @Nullable
    private HTMLDocument.Iterator getLink(int n2) {
        if (n2 >= 0) {
            HTMLDocument document = (HTMLDocument)this.myEditorPane.getDocument();
            int linkCount = 0;
            HTMLDocument.Iterator it = document.getIterator(HTML.Tag.A);
            while (it.isValid()) {
                if (it.getAttributes().isDefined(HTML.Attribute.HREF) && linkCount++ == n2) {
                    return it;
                }
                it.next();
            }
        }
        return null;
    }

    private void highlightLink(int n2) {
        this.myHighlightedLink = n2;
        Highlighter highlighter2 = this.myEditorPane.getHighlighter();
        HTMLDocument.Iterator link = this.getLink(n2);
        if (link != null) {
            int startOffset = link.getStartOffset();
            int endOffset = link.getEndOffset();
            try {
                if (this.myHighlightingTag == null) {
                    this.myHighlightingTag = highlighter2.addHighlight(startOffset, endOffset, LINK_HIGHLIGHTER);
                } else {
                    highlighter2.changeHighlight(this.myHighlightingTag, startOffset, endOffset);
                }
                this.myEditorPane.setCaretPosition(startOffset);
            }
            catch (BadLocationException e2) {
                LOG.warn("Error highlighting link", (Throwable)e2);
            }
        } else if (this.myHighlightingTag != null) {
            highlighter2.removeHighlight(this.myHighlightingTag);
            this.myHighlightingTag = null;
        }
    }

    private void activateLink(int n2) {
        HTMLDocument.Iterator link = this.getLink(n2);
        if (link != null) {
            String href = (String)link.getAttributes().getAttribute(HTML.Attribute.HREF);
            this.myManager.navigateByLink(this, href);
        }
    }

    private static class LinkHighlighter
    implements Highlighter.HighlightPainter {
        private static final Stroke STROKE = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 0.0f);

        private LinkHighlighter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g2, int p0, int p1, Shape bounds, JTextComponent c2) {
            try {
                Rectangle target = c2.getUI().getRootView(c2).modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, bounds).getBounds();
                Graphics2D g2d = (Graphics2D)g2.create();
                try {
                    g2d.setStroke(STROKE);
                    g2d.setColor(c2.getSelectionColor());
                    g2d.drawRect(target.x, target.y, target.width - 1, target.height - 1);
                }
                finally {
                    g2d.dispose();
                }
            }
            catch (Exception e2) {
                LOG.warn("Error painting link highlight", (Throwable)e2);
            }
        }
    }

    private class ActivateLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ActivateLinkAction() {
        }

        public void actionPerformed(AnActionEvent e2) {
            DocumentationComponent.this.activateLink(DocumentationComponent.this.myHighlightedLink);
        }
    }

    private class NextLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private NextLinkAction() {
        }

        public void actionPerformed(AnActionEvent e2) {
            int linkCount = DocumentationComponent.this.getLinkCount();
            if (linkCount <= 0) {
                return;
            }
            DocumentationComponent.this.highlightLink((DocumentationComponent.this.myHighlightedLink + 1) % linkCount);
        }
    }

    private class PreviousLinkAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private PreviousLinkAction() {
        }

        public void actionPerformed(AnActionEvent e2) {
            int linkCount = DocumentationComponent.this.getLinkCount();
            if (linkCount <= 0) {
                return;
            }
            DocumentationComponent.this.highlightLink(DocumentationComponent.this.myHighlightedLink < 0 ? linkCount - 1 : (DocumentationComponent.this.myHighlightedLink + linkCount - 1) % linkCount);
        }
    }

    private static abstract class MyDictionary<K, V>
    extends Dictionary<K, V> {
        private MyDictionary() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<K> keys() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Enumeration<V> elements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(K key, V value2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }

    private class MyShowSettingsAction
    extends ToggleAction {
        private MyShowSettingsAction() {
        }

        public boolean isSelected(AnActionEvent e2) {
            return DocumentationComponent.this.mySettingsPanel.isVisible();
        }

        public void setSelected(AnActionEvent e2, boolean state) {
            if (!state) {
                DocumentationComponent.this.mySettingsPanel.setVisible(false);
                return;
            }
            DocumentationComponent.this.setFontSizeSliderSize(DocumentationComponent.getQuickDocFontSize());
            DocumentationComponent.this.mySettingsPanel.setVisible(true);
        }
    }

    private class MyShowSettingsButton
    extends ActionButton {
        private MyShowSettingsButton() {
            this((AnAction)documentationComponent.new MyShowSettingsAction(), new Presentation(), "JavadocInplaceSettings", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        }

        private MyShowSettingsButton(AnAction action2, Presentation presentation, @NotNull String place, Dimension minimumSize) {
            if (minimumSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumSize", "com/intellij/codeInsight/documentation/DocumentationComponent$MyShowSettingsButton", "<init>"));
            }
            super(action2, presentation, place, minimumSize);
            this.myPresentation.setIcon(AllIcons.General.SecondaryGroup);
        }

        private void hideSettings() {
            if (!DocumentationComponent.this.mySettingsPanel.isVisible()) {
                return;
            }
            AnActionEvent event = AnActionEvent.createFromDataContext((String)this.myPlace, (Presentation)this.myPresentation, (DataContext)DataContext.EMPTY_CONTEXT);
            this.myAction.actionPerformed(event);
        }
    }

    private class ExternalDocAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        private ExternalDocAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.view.external", (Object[])new Object[0]), null, AllIcons.Actions.Browser_externalJavaDoc);
            this.registerCustomShortcutSet(ActionManager.getInstance().getAction("ExternalJavaDoc").getShortcutSet(), null);
        }

        public void actionPerformed(AnActionEvent e2) {
            if (DocumentationComponent.this.myElement == null) {
                return;
            }
            PsiElement element = DocumentationComponent.this.myElement.getElement();
            PsiElement originalElement = DocumentationManager.getOriginalElement(element);
            ExternalJavaDocAction.showExternalJavadoc(element, originalElement, DocumentationComponent.this.myEffectiveExternalUrl, e2.getDataContext());
        }

        public void update(AnActionEvent e2) {
            Presentation presentation = e2.getPresentation();
            presentation.setEnabled(false);
            if (DocumentationComponent.this.myElement != null) {
                PsiElement element = DocumentationComponent.this.myElement.getElement();
                DocumentationProvider provider = DocumentationManager.getProviderFromElement(element);
                PsiElement originalElement = DocumentationManager.getOriginalElement(element);
                if (provider instanceof ExternalDocumentationProvider) {
                    presentation.setEnabled(element != null && ((ExternalDocumentationProvider)provider).hasDocumentationFor(element, originalElement));
                } else {
                    List urls = provider.getUrlFor(element, originalElement);
                    presentation.setEnabled(element != null && urls != null && !urls.isEmpty());
                }
            }
        }
    }

    private class EditDocumentationSourceAction
    extends BaseNavigateToSourceAction {
        private EditDocumentationSourceAction() {
            super(true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.EditSource);
            this.getTemplatePresentation().setText("Edit Source");
        }

        @Override
        public void actionPerformed(AnActionEvent e2) {
            super.actionPerformed(e2);
            JBPopup hint = DocumentationComponent.this.myHint;
            if (hint != null && hint.isVisible()) {
                hint.cancel();
            }
        }

        @Override
        @Nullable
        protected Navigatable[] getNavigatables(DataContext dataContext) {
            SmartPsiElementPointer element = DocumentationComponent.this.myElement;
            if (element != null) {
                Navigatable[] navigatableArray;
                PsiElement psiElement = element.getElement();
                if (psiElement instanceof Navigatable) {
                    Navigatable[] navigatableArray2 = new Navigatable[1];
                    navigatableArray = navigatableArray2;
                    navigatableArray2[0] = (Navigatable)psiElement;
                } else {
                    navigatableArray = null;
                }
                return navigatableArray;
            }
            return null;
        }
    }

    private class ForwardAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public ForwardAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.forward", (Object[])new Object[0]), null, AllIcons.Actions.Forward);
        }

        public void actionPerformed(AnActionEvent e2) {
            DocumentationComponent.this.goForward();
        }

        public void update(AnActionEvent e2) {
            Presentation presentation = e2.getPresentation();
            presentation.setEnabled(!DocumentationComponent.this.myForwardStack.isEmpty());
        }
    }

    private class BackAction
    extends AnAction
    implements HintManagerImpl.ActionToIgnore {
        public BackAction() {
            super(CodeInsightBundle.message((String)"javadoc.action.back", (Object[])new Object[0]), null, AllIcons.Actions.Back);
        }

        public void actionPerformed(AnActionEvent e2) {
            DocumentationComponent.this.goBack();
        }

        public void update(AnActionEvent e2) {
            Presentation presentation = e2.getPresentation();
            presentation.setEnabled(!DocumentationComponent.this.myBackStack.isEmpty());
        }
    }

    private static class Context {
        private final SmartPsiElementPointer element;
        private final String text;
        private final String externalUrl;
        private final Rectangle viewRect;
        private final int highlightedLink;

        public Context(SmartPsiElementPointer element, String text2, String externalUrl, Rectangle viewRect, int highlightedLink) {
            this.element = element;
            this.text = text2;
            this.externalUrl = externalUrl;
            this.viewRect = viewRect;
            this.highlightedLink = highlightedLink;
        }
    }
}

