/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ShowQuickDocInfoAction
extends BaseCodeInsightAction
implements HintManagerImpl.ActionToIgnore,
DumbAware,
PopupAction {
    public static final String CODEASSISTS_QUICKJAVADOC_FEATURE = "codeassists.quickjavadoc";
    public static final String CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE = "codeassists.quickjavadoc.lookup";
    public static final String CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE = "codeassists.quickjavadoc.ctrln";

    public ShowQuickDocInfoAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = new CodeInsightActionHandler(){

            public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction$1", "invoke"));
                }
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction$1", "invoke"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction$1", "invoke"));
                }
                DocumentationManager.getInstance(project2).showJavaDocInfo(editor, file2, LookupManager.getActiveLookup(editor) == null);
            }

            public boolean startInWriteAction() {
                return false;
            }
        };
        if (codeInsightActionHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/actions/ShowQuickDocInfoAction", "getHandler"));
        }
        return codeInsightActionHandler;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    @Override
    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        presentation.setEnabled(false);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (editor == null && element == null) {
            return;
        }
        if (LookupManager.getInstance(project2).getActiveLookup() != null) {
            if (this.isValidForLookup()) {
                presentation.setEnabled(true);
            }
        } else {
            if (editor != null) {
                if (EditorGutter.KEY.getData(event.getDataContext()) != null) {
                    return;
                }
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
                if (file2 == null && element == null) {
                    return;
                }
            }
            presentation.setEnabled(true);
        }
    }

    public void actionPerformed(AnActionEvent e2) {
        DataContext dataContext = e2.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (project2 != null && editor != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_FEATURE);
            LookupImpl lookup = (LookupImpl)LookupManager.getInstance(project2).getActiveLookup();
            if (lookup != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_LOOKUP_FEATURE);
            }
            this.actionPerformedImpl(project2, editor);
        } else if (project2 != null && element != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKJAVADOC_CTRLN_FEATURE);
            CommandProcessor.getInstance().executeCommand(project2, () -> DocumentationManager.getInstance(project2).showJavaDocInfo(element, null), this.getCommandName(), null);
        }
    }
}

