/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.BackspaceModeOverride;
import com.intellij.codeInsight.editorActions.LanguageBackspaceModeOverride;
import com.intellij.codeInsight.editorActions.SmartBackspaceMode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;

abstract class AbstractIndentingBackspaceHandler
extends BackspaceHandlerDelegate {
    private final SmartBackspaceMode myMode;
    private boolean myEnabled;

    AbstractIndentingBackspaceHandler(SmartBackspaceMode mode) {
        this.myMode = mode;
    }

    public void beforeCharDeleted(char c2, PsiFile file2, Editor editor) {
        this.myEnabled = false;
        if (editor.isColumnMode() || !StringUtil.isWhiteSpace((char)c2)) {
            return;
        }
        SmartBackspaceMode mode = AbstractIndentingBackspaceHandler.getBackspaceMode(file2.getLanguage());
        if (mode != this.myMode) {
            return;
        }
        this.doBeforeCharDeleted(c2, file2, editor);
        this.myEnabled = true;
    }

    public boolean charDeleted(char c2, PsiFile file2, Editor editor) {
        if (!this.myEnabled) {
            return false;
        }
        return this.doCharDeleted(c2, file2, editor);
    }

    protected abstract void doBeforeCharDeleted(char var1, PsiFile var2, Editor var3);

    protected abstract boolean doCharDeleted(char var1, PsiFile var2, Editor var3);

    private static SmartBackspaceMode getBackspaceMode(Language language) {
        SmartBackspaceMode mode = CodeInsightSettings.getInstance().getBackspaceMode();
        BackspaceModeOverride override = (BackspaceModeOverride)LanguageBackspaceModeOverride.INSTANCE.forLanguage(language);
        if (override != null) {
            mode = override.getBackspaceMode(mode);
        }
        return mode;
    }
}

